/*  tfftiv.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
    Test:  fftgc
    Uses:  pfac
*/
#include <stdio.h>
#include "ccmath.h"
#include <math.h>
#define MPT 100
struct complex ft[MPT],*pc[MPT];
void main(void)
{ struct complex *f,**p,**h;
  double tpi=6.283185307179586,ang,ann;
  int kk[32],n=MPT,i,j;
  printf(" Test of FFT Inverse\n");
  printf("     F(k)=cos(2pi*5*k/n),sin(2pi*4*k/n)\n");
  ang=5*tpi/n; ann=4*tpi/n;
  for(i=0,f=ft; i<n ;++i){ f->re=cos(ang*i); (f++)->im=sin(ann*i);}
  n=pfac(n,kk,'o');
  printf("      n= %d\n",n);
  fftgc(pc,ft,n,kk,'d');
  fftgc(pc,ft,n,kk,'i');
  for(p=pc,h=pc+n/2,i=0,j=n/2; i<n/2 ;++p,++h){
    printf("%3d %9.6f %9.6f  ",i++,(*p)->re,(*p)->im);
    printf("  %3d %9.6f %9.6f\n",j++,(*h)->re,(*h)->im);
   }
}
/* Test output

 Test of FFT Inverse
     F(k)=cos(2pi*5*k/n),sin(2pi*4*k/n)
      n= 100
  0  1.000000 -0.000000     50 -1.000000  0.000000
  1  0.951057  0.248690     51 -0.951057  0.248690
  2  0.809017  0.481754     52 -0.809017  0.481754
  3  0.587785  0.684547     53 -0.587785  0.684547
  4  0.309017  0.844328     54 -0.309017  0.844328
  5  0.000000  0.951057     55 -0.000000  0.951057
  6 -0.309017  0.998027     56  0.309017  0.998027
  7 -0.587785  0.982287     57  0.587785  0.982287
  8 -0.809017  0.904827     58  0.809017  0.904827
  9 -0.951057  0.770513     59  0.951057  0.770513
 10 -1.000000  0.587785     60  1.000000  0.587785
 11 -0.951057  0.368125     61  0.951057  0.368125
 12 -0.809017  0.125333     62  0.809017  0.125333
 13 -0.587785 -0.125333     63  0.587785 -0.125333
 14 -0.309017 -0.368125     64  0.309017 -0.368125
 15 -0.000000 -0.587785     65 -0.000000 -0.587785
 16  0.309017 -0.770513     66 -0.309017 -0.770513
 17  0.587785 -0.904827     67 -0.587785 -0.904827
 18  0.809017 -0.982287     68 -0.809017 -0.982287
 19  0.951057 -0.998027     69 -0.951057 -0.998027
 20  1.000000 -0.951057     70 -1.000000 -0.951057
 21  0.951057 -0.844328     71 -0.951057 -0.844328
 22  0.809017 -0.684547     72 -0.809017 -0.684547
 23  0.587785 -0.481754     73 -0.587785 -0.481754
 24  0.309017 -0.248690     74 -0.309017 -0.248690
 25  0.000000  0.000000     75 -0.000000 -0.000000
 26 -0.309017  0.248690     76  0.309017  0.248690
 27 -0.587785  0.481754     77  0.587785  0.481754
 28 -0.809017  0.684547     78  0.809017  0.684547
 29 -0.951057  0.844328     79  0.951057  0.844328
 30 -1.000000  0.951057     80  1.000000  0.951057
 31 -0.951057  0.998027     81  0.951057  0.998027
 32 -0.809017  0.982287     82  0.809017  0.982287
 33 -0.587785  0.904827     83  0.587785  0.904827
 34 -0.309017  0.770513     84  0.309017  0.770513
 35 -0.000000  0.587785     85 -0.000000  0.587785
 36  0.309017  0.368125     86 -0.309017  0.368125
 37  0.587785  0.125333     87 -0.587785  0.125333
 38  0.809017 -0.125333     88 -0.809017 -0.125333
 39  0.951057 -0.368125     89 -0.951057 -0.368125
 40  1.000000 -0.587785     90 -1.000000 -0.587785
 41  0.951057 -0.770513     91 -0.951057 -0.770513
 42  0.809017 -0.904827     92 -0.809017 -0.904827
 43  0.587785 -0.982287     93 -0.587785 -0.982287
 44  0.309017 -0.998027     94 -0.309017 -0.998027
 45  0.000000 -0.951057     95 -0.000000 -0.951057
 46 -0.309017 -0.844328     96  0.309017 -0.844328
 47 -0.587785 -0.684547     97  0.587785 -0.684547
 48 -0.809017 -0.481754     98  0.809017 -0.481754
 49 -0.951057 -0.248690     99  0.951057 -0.248690
*/
