/*
 *	Simple domonstration program, reading a file
 *	by using AppConfig (FileConfig!) on an input
 *	stream. This does nothing with the registry!
 *
 *	(C) 1997 Karsten Ballder (Ballueder@usa.net)
 *
 *	$Id: demo.cc,v 1.1.1.1 2001/09/04 15:13:18 scofohey Exp $
 */

/// just for this example we don't want to use registry
#define	APPCONF_WIN32_NATIVE    (FALSE)

#include	"appconf.h"
#include	<fstream.h>

int main(void)
{
   cout << "----- parsing  ./demo.conf: ----------" << endl;

   /// For demonstration, we open a file in this directory,
   /// so we don't use the standard constructor, but one which
   /// takes an open istream as argument. This is not the
   /// usual way to use it. Normally you want to do:
   /// FileConfig cnf("demo");
   /// which would load $HOME/.demo
   
   ifstream	i("./demo.conf");
   
   AppConfig	cnf(&i);

   cout << "active group: " << cnf.getCurrentPath() << endl;
   cout << "alpha: " << cnf.readEntry("Alpha", "undef") << endl;
   cout << "beta: " << cnf.readEntry("Beta", "undef") << endl;
   cout << "gamma: " << cnf.readEntry("gamma", "undef") << endl;

   cout << "Integer: " << cnf.readEntry("Integer", 1234L) << endl;
   cout << "Double: " << cnf.readEntry("Double", 567.893e-5) << endl;
   
   cnf.setCurrentPath("newgroup1");
    
   /// suppose that you know that the entris in this group
   /// may contain references to environment variables
   cout << "active group: " << cnf.getCurrentPath() << endl;
   cout << "alpha: " << cnf.readEntry("alpha", "undef") << endl;
   cout << "beta: " << cnf.readEntry("beta", "undef") << endl;

   cout << "gamma (without expansion): " << cnf.readEntry("gamma", "undef") << endl;
   cnf.expandVariables(TRUE);
   cout << "gamma (with expansion): " << cnf.readEntry("gamma", "undef") << endl;
   cnf.expandVariables(FALSE);
   
   cnf.setCurrentPath("newgroup2");
   
   /// you don't have to do it, but it avoids some extra parsing
   cnf.expandVariables(FALSE);

   cout << "active group: " << cnf.getCurrentPath() << endl;
   cout << "alpha: " << cnf.readEntry("alpha", "undef") << endl;
   cout << "beta: " << cnf.readEntry("beta", "undef") << endl;
   cout << "gamma: " << cnf.readEntry("gamma", "undef") << endl;

   cnf.setCurrentPath();	// default group
   
   cout << "active group: " << cnf.getCurrentPath() << endl;
   cout << "alpha: " << cnf.readEntry("alpha", "undef") << endl;
   cout << "beta: " << cnf.readEntry("beta", "undef") << endl;
   cout << "gamma: " << cnf.readEntry("gamma", "undef") << endl;


   //cout << "----- making some changes: ---------" << endl;

   cnf.setCurrentPath("newgroup1");
   cnf.writeEntry("gamma", "changed gamma \" in newgroup1");
   cnf.writeEntry("groupName", cnf.getCurrentPath());
   
   
   cout << "----- writing changed entries: -------" << endl;
   cnf.flush(&cerr);
   cout << "----------> end." << endl;
   return 0;
}
