/*
 * Vadim's test program for reading and writing configurations.
 *
 * (C) 1997 Vadim Zeitlin
 *
 * $Id: console.cc,v 1.1.1.1 2001/09/04 15:13:17 scofohey Exp $
 */

#include  <iostream.h>
#include  <stdlib.h>
#include  <ctype.h>

#include  "appconf.h"

int main()
{
  char ch;
  cout << "Test [R]ead, [W]rite, [D]elete or [E]verything? ";
  cin  >> ch;

  AppConfig conf("AppConfig");

  switch ( toupper(ch) ) {
    case 'R':
      {
        conf.changeCurrentPath("Colors/Defaults/..");
        cout << "value of 'Red' is '" << conf.readEntry("Red", "0xff0000") << "'" << endl;
        cout << "value of 'Blue' is '" << conf.readEntry("Blue", "0x0000ff") << "'" << endl;
        cout << "value of 'Black' is '" << conf.readEntry("Black", "0x000000") << "'" << endl;
        cout << "value of 'Green' is '" << conf.readEntry("green", "0x00ff00") << "'" << endl;

        conf.changeCurrentPath("..");
        BaseConfig::Enumerator *pEnum = conf.enumEntries();
        size_t nEntries = pEnum->Count();
        for ( size_t n = 0; n < nEntries; n++ ) {
          cout << "Entry #" << n << ": (" << (*pEnum)[n] << ", "
               << conf.readEntry((*pEnum)[n], "???") << ")" << endl;
        }

        delete pEnum;

        pEnum = conf.enumSubgroups();
        size_t nGroups = pEnum->Count();
        for ( size_t m = 0; m < nGroups; m++ ) {
          cout << "Subgroup #" << m << " is " << (*pEnum)[m] << endl;
        }

        delete pEnum;
      }
      break;

    case 'W':
      {
        conf.setCurrentPath("/Colors/Defaults");
        conf.writeEntry("Red", "default");

        conf.changeCurrentPath("..");
        conf.writeEntry("Red", "rouge\t&\trouge");

        conf.changeCurrentPath("Defaults");
        conf.writeEntry("Blue", "default");

        conf.setCurrentPath("/Colors");
        conf.writeEntry("Blue", "  bleu  ");
        conf.writeEntry("Black", "noir");

        conf.changeCurrentPath("Defaults");
        conf.writeEntry("Black", "default");

        conf.setCurrentPath("/Options");
        conf.writeEntry("case", "1 (\"true\")");
        conf.writeEntry("global", "0");

        conf.setCurrentPath("/Temp");
        conf.writeEntry("dummy", "???");

        conf.setCurrentPath();
        conf.writeEntry("written_for", "wxWindows");

        conf.flush();
      }
      break;

    case 'D':
      {
        conf.setCurrentPath("/Temp");
        conf.deleteEntry("dummy");

        conf.setCurrentPath("/Colors/Defaults");
        conf.deleteEntry("Blue");
        conf.deleteEntry("Black");
      }
      break;

    case 'E':
      {
        conf.readEntry("day", "soon will be");
        conf.writeEntry("night", "it's late");
      }
      break;
  }

  return 0;
}
