/*
 * scsitag
 * -------
 * Usage:	scsitag device_name
 * Examples:
 *		scsitag /dev/sda
 *		scsitag /dev/sdb
 *
 * This tool is provided with ncrBsd2Linux release 1.5 and above.
 * It allows to enable tagged command queuing in a per device manner after
 * boot-up.
 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/version.h>
#if (LINUX_VERSION_CODE >= (1<<16)+(3<<8))
# if (LINUX_VERSION_CODE >= (1<<16)+(3<<8)+98)
#  include <linux/../scsi/scsi.h>
# else
#  include <linux/scsi.h>
# endif
#else
# include <linux/fs.h>
#endif
#include <errno.h>

main(int argc, char **argv)
{
	char *device;
	int lun;
	int sd;
	long arg = 1;

	if (argc < 2) {
		fprintf(stderr, "usage: %s device_name\n", argv[0]);
		exit(2);
	}

	device	= argv[1];

	if ((sd = open(device, O_RDONLY)) < 0) {
		perror("cannot open device");
		exit(1);
	}
/*
 * linux-1.X.Y X<=3 Y<=68 returns errno=EINVAL on success
 * It is sure that this ioctl command has never been tested
 */
	if (ioctl(sd, SCSI_IOCTL_TAGGED_ENABLE, NULL) < 0) {
		if (errno != EINVAL) {
			perror("iotcl SCSI_IOCTL_TAGGED_ENABLE failure");
			exit(1);
		}
	}

	exit(0);
}
