/*
\funcref{process}{void process (\params)}
    {
        {LEXER\_} {token} {input token to process}
    }
    {}
    {popfile(), finddef()}
    {lexer()}
    {process.c}
    {
        Function {\em process()} is called from {\em main()} with as argument
        the token as read by {\em lexer()}. Depending on the token, several
        actions are performed by {\em process()}:

        \begin{itemize}

            \item Token {\em l\_eof} signals the end of the processed file.
            {\em popfile()} is called to close the file etc..

            \item Token {\em l\_ident} signals an identifer. {\em process()}
            scans the symbol table {\em defined} to check if the identifier was
            redefined; if so, the redefinition string is written to the output
            file. If not, the identifer itself is written to the output file.

            \item All other tokens signal `ordinary' input. The sematic value
            of the tokens, as stored by {\em lexer()} in the buffer {\em
            lexbuf}, is written to the output file.

        \end{itemize}
    }
*/

#include "icm-pp.h"

void process (LEXER_ token)
{
    register int
        i;

    switch (token)
    {
        case l_eof:
            popfile ();
            break;
        case l_space:
            fputc (lexbuf [0], outfile);
            break;
        case l_string:
            fputc ('\"', outfile);
            fputs (lexbuf, outfile);
            fputc ('\"', outfile);
            break;
        case l_single:
            fputc (lexbuf [0], outfile);
            break;
        case l_ident:
            if ( (i = finddef (lexbuf)) != -1 )
                fputs (defined [i].redef, outfile);
            else
                fputs (lexbuf, outfile);
            break;
        case l_other:
            fputs (lexbuf, outfile);
            break;
    }
}
