/*
 * k_compat.h 1.8 1995/12/03 01:26:43 (David Hinds)
 *                1998/07/12 modified by Pavel Pisa pisa@CMP.felk.cvut.cz
 */

#ifndef _LINUX_K_COMPAT_H
#define _LINUX_K_COMPAT_H

#define VERSION(v,p,s) (((v)<<16)+(p<<8)+s)

#ifndef LINUX_VERSION_CODE
  #error LINUX_VERSION_CODE not defined
#endif

#if (LINUX_VERSION_CODE < VERSION(1,3,38))

#ifdef MODULE
#include <linux/module.h>
#if !defined(CONFIG_MODVERSIONS) && !defined(__NO_VERSION__)
char kernel_version[] = UTS_RELEASE;
#endif
#else
#define MOD_DEC_USE_COUNT
#define MOD_INC_USE_COUNT
#endif

#else /* 1.3.38 */

#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS 1
#if (LINUX_VERSION_CODE >= VERSION(1,3,40))
#include <linux/modversions.h>
#endif
#endif
#include <linux/module.h>

#endif /* 1.3.38 */

/*** user memory access ***/

/* I do not know exactly all dates of changes */

#if (LINUX_VERSION_CODE < VERSION(2,1,5))
  #define kc_copy_from_user memcpy_fromfs
  #define kc_copy_to_user   memcpy_tofs
  #define kc_get_user_long  get_fs_long
  #define kc_get_user_word  get_fs_word
  #define kc_get_user_byte  get_fs_byte
  #define kc_put_user_long  put_fs_long
  #define kc_put_user_word  put_fs_word
  #define kc_put_user_byte  put_fs_byte
#elif (LINUX_VERSION_CODE < VERSION(2,1,100)) /* may need correction */
  #include  <asm/uaccess.h>
  #define kc_copy_from_user copy_from_user
  #define kc_copy_to_user   copy_to_user
  #define kc_get_user(ptr) \
    ({ __typeof__(*(ptr)) x; \
       __get_user_check(x,(ptr),sizeof(*(ptr))); x; })
  #define kc_put_user(x,ptr) \
    (__put_user_check((x),ptr,sizeof(*(ptr))))
#else /* >= 2.1.100 */
  #include  <asm/uaccess.h>
  #define kc_copy_from_user copy_from_user
  #define kc_copy_to_user   copy_to_user
  #define kc_get_user(ptr) \
    ({ __typeof__(*(ptr)) x; \
       get_user(x,(ptr)); x; })
  #define kc_put_user(x,ptr) \
    (put_user((x),(ptr)))
#endif /* < 2.1.100 */

#if (LINUX_VERSION_CODE >= VERSION(2,1,5))
  #define kc_get_user_long(ptr)   (kc_get_user((long*)(ptr)))
  #define kc_get_user_word(ptr)   (kc_get_user((unsigned short*)(ptr)))
  #define kc_get_user_byte(ptr)   (kc_get_user((unsigned char*)(ptr)))
  #define kc_put_user_long(x,ptr) (kc_put_user((x),(long *)(ptr)))
  #define kc_put_user_word(x,ptr) (kc_put_user((x),(unsigned short*)(ptr)))
  #define kc_put_user_byte(x,ptr) (kc_put_user((x),(unsigned char*)(ptr)))
#endif /* >= 2.1.5 */

/*** bitops changes ***/

#if (LINUX_VERSION_CODE < VERSION(2,1,36)) /* may need correction */
   #define test_and_set_bit set_bit
#endif

/*** interrupt related stuff ***/

#if (LINUX_VERSION_CODE < VERSION(2,1,36)) /* may need correction */
   #define synchronize_irq() do{cli();sti();}while(0)
#endif

/*** timming related stuff ***/

#if (LINUX_VERSION_CODE < VERSION(2,1,100)) /* needs correction */
   #define schedule_timeout(timeout_jif) ({ \
       current->timeout = jiffies + (timeout_jif); \
       schedule(); \
       current->timeout = 0; \
   })
#endif

#if (LINUX_VERSION_CODE < VERSION(2,1,36)) /* needs correction */
   #define mod_timer(timer,expires) ({\
       del_timer(timer); \
       timer->expires=expires; \
       add_timer(timer); \
   })
#endif

/*** file_operations changes ***/

#if (LINUX_VERSION_CODE < VERSION(2,1,5))
   #define CLOSERET   void
   #define RWRET      int
   #define RWCOUNT_T  int
   #define RWINODE_P  struct inode *inode,
   #define RWPPOS_P
   #define RWINODE    inode
   #define KC_FOPS_FLUSH(ptr)
#elif (LINUX_VERSION_CODE < VERSION(2,1,36))
   #define CLOSERET   void
   #define RWRET      long
   #define RWCOUNT_T  unsigned long
   #define RWINODE_P  struct inode *inode,
   #define RWPPOS_P
   #define RWINODE    inode
   #define KC_FOPS_FLUSH(ptr)
#elif (LINUX_VERSION_CODE < VERSION(2,1,76)) /* may need correction */
   #define CLOSERET   int
   #define RWRET      long
   #define RWCOUNT_T  unsigned long
   #define RWINODE_P  struct inode *inode,
   #define RWPPOS_P
   #define RWINODE    inode
   #define KC_FOPS_FLUSH(ptr)
#elif (LINUX_VERSION_CODE < VERSION(2,1,117)) /* may need correction */
   #define CLOSERET   int
   #define RWRET      ssize_t
   #define RWCOUNT_T  size_t
   #define RWINODE_P
   #define RWPPOS_P   ,loff_t *ppos
   #define RWINODE    file->f_dentry->d_inode
   #define KC_FOPS_FLUSH(ptr)
#else /* >= 2.1.117 */ /* may need correction */
   #define CLOSERET   int
   #define RWRET      ssize_t
   #define RWCOUNT_T  size_t
   #define RWINODE_P
   #define RWPPOS_P   ,loff_t *ppos
   #define RWINODE    file->f_dentry->d_inode
   #define KC_FOPS_FLUSH(ptr)  flush:(ptr),
#endif /* 2.1.36 */

#if (LINUX_VERSION_CODE < VERSION(2,1,50)) /* may need correction */
  #define kc_poll_wait(file,address,wait) poll_wait(address,wait)
#else /* >= 2.1.50 */
  #define kc_poll_wait poll_wait
#endif /* 2.1.50 */

/* definition of standard parameters for read/write file functions */
#define READ_PARAMETERS \
	RWINODE_P struct file *file, char *buf, RWCOUNT_T count RWPPOS_P

#define WRITE_PARAMETERS \
	RWINODE_P struct file *file, const char *buf, RWCOUNT_T count RWPPOS_P

#define LSEEK_PARAMETERS \
	RWINODE_P struct file *file, loff_t pos, int whence

#if (LINUX_VERSION_CODE < VERSION(2,2,0)) /* may need correction */
  #define KC_CHRDEV_FOPS_BEG(fops_var) \
        static struct file_operations fops_var =\
        {
  #define KC_CHRDEV_FOPS_END \
        }
  #define KC_FOPS_LSEEK(ptr)   lseek:(ptr),
  #define KC_FOPS_RELEASE(ptr) close:(ptr),
#elif (LINUX_VERSION_CODE < VERSION(2,4,0)) /* may need correction */
  #define KC_CHRDEV_FOPS_BEG(fops_var) \
        static struct file_operations fops_var =\
        {
  #define KC_CHRDEV_FOPS_END \
        }
  #define KC_FOPS_LSEEK(ptr)   llseek:(ptr),
  #define KC_FOPS_RELEASE(ptr) release:(ptr),
#else /* >= 2.4.0 */
  #define KC_CHRDEV_FOPS_BEG(fops_var) \
        static struct file_operations fops_var = {\
            owner:THIS_MODULE,
  #define KC_CHRDEV_FOPS_END \
        }
  #define KC_FOPS_LSEEK(ptr)   llseek:(ptr),
  #define KC_FOPS_RELEASE(ptr) release:(ptr),
#endif /* 2.4.0 */

/*** wait queues changes ***/

#if (LINUX_VERSION_CODE < VERSION(2,3,3)) /* may need correction */
  #define wait_queue_head_t struct wait_queue *
  #define wait_queue_t      struct wait_queue
  #define init_waitqueue_head(queue_head) (*queue_head=NULL)
  #define init_waitqueue_entry(qentry,qtask) \
			(qentry->next=NULL,qentry->task=qtask) 
  #define DECLARE_WAIT_QUEUE_HEAD(name) \
   	struct wait_queue * name=NULL
  #define DECLARE_WAITQUEUE(wait, current) \
	struct wait_queue wait = { current, NULL }
  #define init_MUTEX(sem) (*sem=MUTEX)
  #define DECLARE_MUTEX(name) struct semaphore name=MUTEX
#endif /* 2.3.3 */

#endif /* _LINUX_K_COMPAT_H */
