/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/*  Extra functions used by unireg library */

#ifndef NO_ALARM_LOOP
#define NO_ALARM_LOOP		/* lib5 and popen can't use alarm */
#endif
#define LANGUAGE	"english/"
#define ERRMSG_FILE	"errmsg.sys"
#define TEMP_PREFIX	"MY"
#define PROGDIR		"bin/"
#ifndef DATADIR
#define DATADIR		"data/"
#endif
#ifndef SHAREDIR
#define SHAREDIR	"share/"
#endif

#define ER(X) errmesg[(X)-1000]
#define ERRMAPP 1				/* Errormap f|r my_error */
#define MAXREGNAME 32				/* Max bokst{ver i regnamn */
#define LIBLEN FN_REFLEN-FN_LEN			/* Max l{ngd p} dev */
#define MAX_FIELD_NAME 34			/* L{ngd p} f{ltnamn */
#define MAX_FIELDNR_LENGTH (MAXREGNAME+MAX_FIELD_NAME+1)
#define MAX_KEY 16				/* Max used keys */
#define MAX_REF_PARTS 15			/* Max parts used as ref */
#define MAX_REFLENGTH 4				/* Max length for record ref */
#define MAX_FIELD_WIDTH 256			/* Max f{ltl{ngd +1 */
#define MAX_REF_REG 15				/* Max reg in formulas */
#define MAX_INPUT_REG 15
#define MAX_FORM_NAME 1
#define MAX_EQV_AOSBUFF 256

#define MAX_SORT_MEMORY (2048*1024-MALLOC_OVERHEAD)
#define MIN_SORT_MEMORY (32*1024-MALLOC_OVERHEAD)
#define EXTRA_RECORDS	10			/* Extra records in sort */
#define SCROLL_EXTRA	5			/* Extra scroll-rows. */
#define FIELD_NAME_USED ((uint) 32768)		/* Bit set if fieldname used */
#define FORM_NAME_USED	((uint) 16384)		/* Bit set if formname used */
#define FIELD_NR_MASK	16383			/* To get fieldnumber */
#define FERR		-1			/* Error from my_functions */
#define CREATE_MODE	0			/* Default mode on new files */
#define NAMES_SEP_CHAR	','			/* Char to sep. names */
#ifdef MSDOS
#define EXTRA_FIELD_CHAR (char) '\234'		/* Interchangebly with '#' */
#else
#define EXTRA_FIELD_CHAR '#'			/* Interchangebly with '#' */
#endif

#define READ_RECORD_BUFFER	(uint) (IO_SIZE*8) /* Pointer_buffer_size */
#define DISK_BUFFER_SIZE	(uint) (IO_SIZE*16) /* Size of diskbuffer */
#define POSTFIX_ERROR		DBL_MAX

#define ME_INFO (ME_HOLDTANG+ME_OLDWIN+ME_NOREFRESH)
#define ME_ERROR (ME_BELL+ME_OLDWIN+ME_NOREFRESH)
#define MYF_RW MYF(MY_WME+MY_NABP)		/* Vid my_read & my_write */

#define SPECIAL_ALLWAYS_HELP	1		/* Give more help */
#define SPECIAL_SKIPP_CNTRL	2		/* Skipp in textfiles */
#define SPECIAL_PART_SEARCH	4		/* How matain finds records */
#define SPECIAL_NO_BEEP		8		/* No beep on delete */
#define SPECIAL_SHELL_ESC	16		/* Allow shell escape */
#define SPECIAL_ABORT		32		/* Allow CTRL+C abort */
#define SPECIAL_INFO		64		/* Give normal info */
#define SPECIAL_CONFIRM		128		/* Confirm update & delete */
#define SPECIAL_AUTO_RET	256		/* Auto return in meny */
#define SPECIAL_EXTEND_COMMANDS 512		/* Allow extend commands */
#define SPECIAL_USE_LOCKS	8192		/* Lock used databases */
#define SPECIAL_NO_NEW_FUNC	16384		/* Skipp new functions */
#define SPECIAL_WAIT_IF_LOCKED	32768		/* Wait if locked database */
#define SPECIAL_CONVERT_TO_NAME 65536L		/* Convert #nr to #name */
#define SPECIAL_NO_TIMESTAMP	131072L		/* Don't update timestamp */
#define SPECIAL_CONFIRM_ALL	262144L		/* Confirm all in input() */
#define SPECIAL_NO_BACKGROUND	524288L		/* Don't allow background */
#define SPECIAL_ERROR_ON_LOG	1048576L	/* Write messages on log */
#define SPECIAL_CONVERT_TO_NR	2097152L	/* Convert #name to #nr */
#define SPECIAL_NO_UNSAFE_OPT	4194304L	/* No unsafe select */
#define SPECIAL_MAIL_ON_EXIT	8388608L	/* Mail user when program end*/
#define SPECIAL_SAME_DB_NAME   16777216L	/* form name = file name */
#define SPECIAL_SQL_MODE       0x2000000L	/* some sql optimizations */
#define SPECIAL_ERROR_IF_NO_RECORDS 0x4000000L	/* for -Do */
#define SPECIAL_COMPACT        0x8000000L	/* for printform */
#define SPECIAL_ENGLISH        0x10000000L	/* English error messages */

	/* Extern defines */

#define store_record(A,B) bmove_allign((A)->record[B],(A)->record[0],(size_t) (A)->reclength)
#define restore_record(A,B) bmove_allign((A)->record[0],(A)->record[B],(size_t) (A)->reclength)
#define cmp_record(A,B) memcmp((A)->record[0],(A)->record[B],(size_t) (A)->reclength)
#define x_free(A) { gptr tmp=(gptr) (A); if (tmp) my_free(tmp,MYF(MY_WME+MY_FAE)); }
#define all_bits_set(A,B) ((A) & (B) != (B))

#if MAX_REFLENGTH == 4
#define TEST_IF_LASTREF(A,B) (*((long*) (A)) == -1L)
#else
#define TEST_IF_LASTREF(A,B) (bcmp(A,last_ref,B) == 0)
#endif

	/* Defines for use with openfrm, openprt and openfrd */

#define READ_ALL		1	/* openfrm: Read all parameters */
#define CHANGE_FRM		2	/* openfrm: open .frm as O_RDWR */
#define READ_KEYINFO		4	/* L{s nyckeldata fr}n filen */
#define EXTRA_RECORD		8	/* Reservera plats f|r extra record */
#define DONT_OPEN_TABLES	8	/* Don't open database-files (frd) */
#define DONT_OPEN_MASTER_REG	16	/* Don't open first reg-file (prt) */
#define EXTRA_LONG_RECORD	16	/* Plats f|r dubbel s|k-record */
#define COMPUTE_TYPES		32	/* Kontrollera type f|r f{ltena */
#define SEARCH_PRG		64	/* S|k efter registret i 'prg_dev' */
#define READ_USED_NAMES		128	/* L{s anv{nda formul{rnamn */
#define DONT_GIVE_ERROR		256	/* Don't do frm_error on openfrm  */
#define READ_SCREENS		1024	/* Read screens, info and helpfile */
#define GET_NAME_OF_INDEXFILE	2048	/* Put indexfilename in reginfo.name */
#define DELAYED_OPEN		4096	/* Open table later */

	/* Include prototypes for unireg */


#include "derror.h"
#include "structs.h"				/* All structs we need */
#include "handler.h"
