/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/*
  Functions to create a unireg form-file from a FIELD and a fieldname-fieldinfo
  struct.
  In the following functions FIELD * is a ordinary field-structure with
  the following exeptions:
    sc_length,typepos,row,kol,dtype,regnr and field nead not to be set.
    str is a (long) to record position where 0 is the first position.
    intervall is a pointer to a intervallstring of type "option1,option2...".
*/

#define USES_TYPES
#include "mysql_priv.h"
#include <m_ctype.h>

#define FCOMP			11		/* Byte per packat f{lt */

static uchar * pack_screens(List<create_field> &create_fields,
			    uint *info_length, uint *screens);
static uint pack_keys(uchar *keybuff,uint key_count, KEY *key_info);
static void pack_header(uchar *forminfo, List<create_field> &create_fields,
			uint info_length, uint screens);
static int pack_fields(File file, List<create_field> &create_fields);
static int make_empty_rec(int file,List<create_field> &create_fields,
			  uint reclength,uint null_fields);
			      

int rea_create_table(string file_name,enum db_type table_type,
		     uint table_options,ulong records,ulong reloc,
		     List<create_field> &create_fields,
		     uint keys, KEY *key_info)
{
  uint reclength,info_length,screens,key_info_length,maxlength,null_fields;
  File file;
  ulong filepos;
  char	name[FN_REFLEN];
  uchar fileinfo[65],forminfo[288],*keybuff;
  TYPELIB formnames;
  uchar *screen_buff;
  uint field_count=create_fields.elements;
  DBUG_ENTER("rea_create_table");

  formnames.type_names=0;
  screen_buff=pack_screens(create_fields,&info_length,&screens);
  pack_header(forminfo,create_fields,info_length,screens);
  reclength=uint2korr(forminfo+266);
  null_fields=uint2korr(forminfo+282);

  if ((file=create_frm(fn_format(name,file_name,"",reg_ext,0),
		       reclength,fileinfo,table_type,table_options,records,
		       reloc,keys)) < 0)
  {
    my_free((gptr) screen_buff,MYF(0));
    DBUG_RETURN(1);
  }

  uint key_buff_length=uint2korr(fileinfo+14);
  keybuff=(uchar*) my_alloca(key_buff_length);
  key_info_length=pack_keys(keybuff,keys,key_info);
  VOID(get_form_pos(file,fileinfo,"",NullS,&formnames));
  if (!(filepos=make_new_entry(file,fileinfo,&formnames,"")))
    goto err;
  maxlength=(uint) next_io_size((ulong) (uint2korr(forminfo)+1000));
  int2store(forminfo+2,maxlength);
  int4store(fileinfo+10,(ulong) (filepos+maxlength));
  fileinfo[26]= (uchar) test((records == 1) && (reloc == 1) && (keys == 0));
  int2store(fileinfo+28,key_info_length);

  VOID(my_seek(file,0L,MY_SEEK_SET,MYF(0)));
  if (my_write(file,(byte*) fileinfo,64,MYF_RW))
    goto err;
  VOID(my_seek(file,(ulong) uint2korr(fileinfo+6),MY_SEEK_SET,MYF(0)));
  if (my_write(file,(byte*) keybuff,key_info_length,MYF_RW))
    goto err;
  VOID(my_seek(file,
	       (ulong) uint2korr(fileinfo+6)+ (ulong) uint2korr(fileinfo+14),
	       MY_SEEK_SET,MYF(0)));
  if (make_empty_rec(file,create_fields,reclength,null_fields))
    goto err;

  VOID(my_seek(file,filepos,MY_SEEK_SET,MYF(0)));
  if (my_write(file,(char*) forminfo,288,MYF_RW))
    goto err;
  if (my_write(file,(char*) screen_buff,info_length,MYF_RW))
    goto err;
  if (pack_fields(file,create_fields))
    goto err;

  free_type(&formnames);
  my_free((gptr) screen_buff,MYF(0));
  my_afree((gptr) keybuff);
  VOID(my_close(file,MYF(MY_WME)));
  DBUG_RETURN(cre_database(file_name));

err:
  free_type(&formnames);
  my_free((gptr) screen_buff,MYF(0));
  my_afree((gptr) keybuff);
  VOID(my_close(file,MYF(MY_WME)));
  DBUG_RETURN(1);
} /* rea_create_table */


	/* Pack screens to a screen for save in a form-file */

static uchar * pack_screens(List<create_field> &create_fields,
			    uint *info_length, uint *screens)
{
  reg1 uint i;
  uint row,start_row,end_row,fields_on_screen;
  uint length,cols;
  uchar *info,*pos,*start_screen;
  uint fields=create_fields.elements;
  List_iterator<create_field> it(create_fields);
  DBUG_ENTER("pack_screens");

  start_row=4; end_row=22; cols=80; fields_on_screen=end_row+1-start_row;

  *screens=(fields-1)/fields_on_screen+1;
  length= (*screens) * (SC_INFO_LENGTH+ (cols>> 1)+4);

  while (create_field *field=it++)
    length+=strlen(field->field_name)+1+TE_INFO_LENGTH+cols/2;

  if (!(info=(uchar*) my_malloc(length,MYF(MY_WME))))
    DBUG_RETURN(0);

  start_screen=0;
  row=end_row;
  pos=info;
  it.rewind();
  for (i=0 ; i < fields ; i++)
  {
    create_field *field=it++;
    if (row++ == end_row)
    {
      if (i)
      {
	length=(uint) (pos-start_screen);
	int2store(start_screen,length);
	start_screen[2]=(uchar) (fields_on_screen+1);
	start_screen[3]=(uchar) (fields_on_screen);
      }
      row=start_row;
      start_screen=pos;
      pos+=4;
      pos[0]= (uchar) start_row-2;	/* Header string */
      pos[1]= (uchar) (cols >> 2);
      pos[2]= (uchar) (cols >> 1) +1;
      strfill((string) pos+3,(uint) (cols >> 1),' ');
      pos+=(cols >> 1)+4;
    }
    length=strlen(field->field_name);
    if (length > cols-3)
      length=cols-3;

    pos[0]=(uchar) row;
    pos[1]=0;
    pos[2]=(uchar) (length+1);
    pos=(uchar*) strmake((char*) pos+3,field->field_name,length)+1;

    field->row=(uint8) row;
    field->col=(uint8) (length+1);
    field->sc_length=(uint8) min(field->length,cols-(length+2));
  }
  length=(uint) (pos-start_screen);
  int2store(start_screen,length);
  start_screen[2]=(uchar) (row-start_row+2);
  start_screen[3]=(uchar) (row-start_row+1);

  *info_length=(uint) (pos-info);
  DBUG_RETURN(info);
} /* pack_screens */


	/* Pack keyinfo and keynames to keybuff for save in form-file. */

static uint pack_keys(uchar *keybuff,uint key_count,KEY *keyinfo)
{
  uint key_parts,length;
  uchar *pos,*keyname_pos;
  KEY *key,*end;
  KEY_PART_INFO *key_part,*key_part_end;
  DBUG_ENTER("pack_keys");

  pos=keybuff+6;
  key_parts=0;
  for (key=keyinfo,end=keyinfo+key_count ; key != end ; key++)
  {
    pos[0]=key->dupp_key;
    int2store(pos+1,key->key_length);
    pos[3]=key->key_parts;
    pos+=4;
    key_parts+=key->key_parts;
    DBUG_PRINT("loop",("dupp: %d  key_parts: %d at %lx",
		       key->dupp_key,key->key_parts,
		       key->key_part));
    for (key_part=key->key_part,key_part_end=key_part+key->key_parts ;
	 key_part != key_part_end ;
	 key_part++)

    {
      DBUG_PRINT("loop",("field: %d  startpos: %ld  length: %ld",
			 key_part->field,key_part->offset,key_part->length));
      int2store(pos,key_part->field+1+FIELD_NAME_USED);
      int2store(pos+2,key_part->offset+1);
      pos[4]=0;
      int2store(pos+5,key_part->key_type);
      int2store(pos+7,key_part->length);
      pos+=9;
    }
  }
	/* Save keynames */
  keyname_pos=pos;
  *pos++=NAMES_SEP_CHAR;
  for (key=keyinfo ; key != end ; key++)
  {
    uchar *tmp=(uchar*) strmov((char*) pos,key->name);
    *tmp++=NAMES_SEP_CHAR;
    *tmp=0;
    pos=tmp;
  }
  *(pos++)=0;

  keybuff[0]=(uchar) key_count;
  keybuff[1]=(uchar) key_parts;
  length=(uint) (keyname_pos-keybuff);
  int2store(keybuff+2,length);
  length=(uint) (pos-keyname_pos);
  int2store(keybuff+4,length);
  DBUG_RETURN((uint) (pos-keybuff));
} /* pack_keys */


	/* Make formheader */

static void pack_header(uchar *forminfo, List<create_field> &create_fields,
			uint info_length, uint screens)
{
  uint j,length,n_length,int_count,int_length,reclength,totlength,no_empty,
      int_parts,time_stamp_pos,null_fields;
  char *str_pos;
  DBUG_ENTER("pack_header");

  totlength=reclength=no_empty=int_count=int_parts=int_length=time_stamp_pos=0,
    null_fields=0;
  n_length=2;

	/* Check fields */

  List_iterator<create_field> it(create_fields);
  while (create_field *field=it++)
  {
    totlength+= field->length;
    if (MTYP_TYPENR(field->unireg_type) == MTYP_NOEMPTY ||
	field->unireg_type & MTYP_NOEMPTY_BIT)
    {
      field->unireg_type|=MTYP_NOEMPTY_BIT;
      no_empty++;
    }
    if (MTYP_TYPENR(field->unireg_type) == MTYP_TIMESTAMP ||
	f_packtype(field->pack_flag) == (int) FIELD_TYPE_TIMESTAMP)
      time_stamp_pos=(int) field->offset+1;
    length=f_packlength(field->length,field->pack_flag);
    if ((int) field->offset+length > reclength)
      reclength=(int) field->offset+length;
    n_length+= strlen(field->field_name)+1;
    if ((str_pos=(string) field->intervall) && str_pos[0])
    {
      int_count++;
      int_length+=strlen(str_pos)+3;		/* two ','+ one '\0' added */
      for (j=2,str_pos-- ; (str_pos=strchr(str_pos+1,NAMES_SEP_CHAR)) ; j++) ;
      int_parts+=j;
    }
    else
      field->intervall=0;
    if (f_maybe_null(field->pack_flag))
      null_fields++;
  }
  reclength+=(null_fields+7)/8;

	/* Save values in forminfo */

  bzero((byte*)forminfo,288);
  length=info_length+create_fields.elements*FCOMP+288+n_length+int_length;
  int2store(forminfo,length);
  forminfo[256] = (uint8) screens;
  int2store(forminfo+258,create_fields.elements);
  int2store(forminfo+260,info_length);
  int2store(forminfo+262,totlength);
  int2store(forminfo+264,no_empty);
  int2store(forminfo+266,reclength);
  int2store(forminfo+268,n_length);
  int2store(forminfo+270,int_count);
  int2store(forminfo+272,int_parts);
  int2store(forminfo+274,int_length);
  int2store(forminfo+276,time_stamp_pos);
  int2store(forminfo+278,80);			/* Columns neaded */
  int2store(forminfo+280,22);			/* Rows neaded */
  int2store(forminfo+282,null_fields);
  DBUG_VOID_RETURN;
} /* pack_header */


	/* Save fields, fieldnames and intervalls */

static int pack_fields(File file,List<create_field> &create_fields)
{
  reg2 uint i;
  uint int_count;
  uchar buff[MAX_FIELD_WIDTH],*pos;
  DBUG_ENTER("pack_fields");

	/* Write field info */

  List_iterator<create_field> it(create_fields);

  int_count=0;
  while (create_field *field=it++)
  {
    buff[0]= (uchar) field->row;
    buff[1]= (uchar) field->col;
    buff[2]= (uchar) field->sc_length;
    buff[3]= (uchar) field->length;
    uint recpos=(uint) field->offset+1;
    int2store(buff+4,recpos);
    int2store(buff+6,field->pack_flag);
    int2store(buff+8,field->unireg_type);
    if (!field->intervall)
      buff[10]=0;
    else
      buff[10]= (uchar) ++int_count;
    if (my_write(file,(byte*) buff,FCOMP,MYF_RW))
      DBUG_RETURN(1);
  }

	/* Write fieldnames */
  buff[0]=NAMES_SEP_CHAR;
  if (my_write(file,(byte*) buff,1,MYF_RW))
    DBUG_RETURN(1);
  i=0;
  it.rewind();
  while (create_field *field=it++)
  {
    pos=(uchar*) strmov((char*) buff,field->field_name);
    *pos++=NAMES_SEP_CHAR;
    if (i == create_fields.elements-1)
      *pos++=0;
    if (my_write(file,(byte*) buff,(uint) (pos-buff),MYF_RW))
      DBUG_RETURN(1);
    i++;
  }

	/* Write intervalls */
  buff[0]=NAMES_SEP_CHAR;
  it.rewind();
  while (create_field *field=it++)
  {
    if (field->intervall)
    {
      pos=(uchar*) strmov((char*) buff+1,(string) field->intervall);
      *pos++=NAMES_SEP_CHAR;
      *pos++=0;
      if (my_write(file,(byte*) buff,(uint) (pos-buff),MYF_RW))
	DBUG_RETURN(1);
    }
  }
  DBUG_RETURN(0);
} /* pack_fields */


	/* save a empty record on start of formfile */

static int make_empty_rec(File file,List<create_field> &create_fields,
			  uint reclength, uint null_fields)
{
  int error,type;
  uint length,firstpos;
  uchar *buff,*pos;
  char *endpos,value[MAX_FIELD_WIDTH];
  DBUG_ENTER("make_empty_rec");

  if (!(buff=(uchar*) my_malloc((uint) reclength,MYF(MY_WME))))
    DBUG_RETURN(1);
  bfill((byte*) buff,reclength,' ');
  firstpos=reclength;

  List_iterator<create_field> it(create_fields);
  while (create_field *field=it++)
  {
    uint pack_flag=field->pack_flag;
    if ((uint) field->offset < firstpos &&
	f_packtype(pack_flag) != (int) FIELD_TYPE_NULL)
      firstpos= field->offset;
    pos=buff+field->offset;
    length= field->length;
    type= MTYP_TYPENR((uint) field->unireg_type);
    if (f_is_packed(pack_flag) || f_is_num(pack_flag))
      f_fieldinit((byte*) pos,pack_flag,length);
    else if (field->intervall)
    {
      endpos=strcend((string) field->intervall,',');
      VOID(strmake(value,(string) field->intervall,
		   (uint) (endpos- (string) field->intervall)));
      f_packfield((byte*) pos,value,0,length,(TYPELIB*) 0);
    }
    else if (type == MTYP_JA)
      f_packfield((byte*) pos,ER(ER_YES),0,length,(TYPELIB*) 0);
    else if (type == MTYP_NEJ)
      f_packfield((byte*) pos,ER(ER_NO),0,length,(TYPELIB*) 0);
    if (field->def && ! f_is_blob(field->pack_flag))
    {
      char buff[MAX_FIELD_WIDTH+1];
      String str(buff,sizeof(buff)),*res;
      res=field->def->str(&str);
      f_packfield((byte*) pos,res->c_ptr(),field->pack_flag,length,
		  (TYPELIB*) 0);
    }
  }
  bfill((byte*) buff,firstpos,254);	/* Fill not used startpos */
  if (null_fields)
  {
    length=(null_fields+7)/8;
    bzero(buff+reclength-length,length);
  }
  error=(int) my_write(file,(byte*) buff,(uint) reclength,MYF_RW);
  my_free((byte*) buff,MYF(MY_FAE));
  DBUG_RETURN(error);
} /* make_empty_rec */


	/* Skipp prespace in a number */

static int skipp_begin_sp(string pos)
{
  reg2 string to;
  int skipp;

  if (*pos != ' ') return (0);
  to=pos;
  while (*++pos == ' ') ;			/* Skip prespace */
  skipp = pos-to;
  if (*pos)
  {
    while (*pos) *to++ = *pos++;		/* Flytta talet */
    while (to != pos) *to++ = ' ';		/* Fyll upp med space */
  }
  return (skipp);				/* Returnera flyttade */
} /* skipp_begin_sp */


	/* skipp end-sign */

static uint skipp_last_sign(char *pos,uint length)
{
  reg3 char sign;
  if ((sign=pos[length-1]) == '-' || sign == '+')
  {
    if (*pos == '+' || *pos == '-')
    {
      if (sign == '-')
	*pos = (char) ((*pos == '+') ? '-' : '+');
      else
	*pos=sign;
      pos[--length] = '\0';			/* Ett tecken mindre */
    }
    else
    {
      bmove_upp(pos+length,pos+length-1,length-1);
      *pos=sign;
    }
  }
  return (length);
}


	/* Format a number with prespace */

int format_number(uint inputflag,uint max_length,string pos,uint length,
		  string *errpos)
{
  int dec;
  char fyll;
  register string decpos,slutpos;
  DBUG_ENTER("format_number");

  if (strchr(pos,wild_many))
  {						/* Beh|ver inte formateras */
    bfill(pos+length,max_length-length,' ');
    DBUG_RETURN(0);
  }
  if (length && (int) (length-= (uint) skipp_begin_sp(pos)) >1)
      length= skipp_last_sign(pos,length);
  *(slutpos=pos+max_length)='\0';

  if ((inputflag & 3) == 3)			/* Decimal-f{lt ? */
  {
    if (*(decpos=pos) == '+' || *decpos == '-') decpos++;
    if ((*errpos=strcont(decpos,"-+")) ||
	((*errpos=strchr(decpos,' ')) != NullS && *errpos < pos+length))
    {
      DBUG_RETURN(3);				/* Felaktigt tecken mitt i */
    }
    if (*decpos == '.' || ! *decpos)
    {
      if (length == max_length)
      {
	*errpos=decpos;
	DBUG_RETURN(2);
      }
      length++;
      bmove_upp(decpos+length,decpos+length-1,length);
      *decpos = '0';
    }
    dec = (inputflag >> 8) & 31;
    if ((decpos=strchr(pos,'.')) == NullS)
    {
      if (length+(uint) dec+test(dec) > max_length)
      {
	if (*(pos+length-dec-1) == wild_one)
	  decpos=pos+length-dec-1;		/* Anta att ? == '.' */
	else
	{
	  *errpos=pos+length;
	  DBUG_RETURN(2);			/* Decimaler rymms inte */
	}
      }
      else
      {
	decpos =pos+length;
	if (dec) *decpos = '.';
      }
    }
    else
    {
      if ((*errpos=strchr(decpos+1,'.')) != NullS)
	DBUG_RETURN(1);				/* 2 '.'-er */
    }
    if (dec)
    {
      register int i;
      decpos++;					/* Skippa '.' */;
      for (i=0 ; i<dec ; i++,decpos++)
	if (! isdigit(*decpos) && *decpos != wild_one) break;
      if (i<dec)
      {
	if (pos+max_length < decpos+dec-i)
	{
	  *errpos=pos;
	  DBUG_RETURN(2);			/* Decimaler rymms inte */
	}
	for ( ; i<dec ; i++,*decpos++ = '0' ) ;
      }
    }
  }
  else
  {						/* Ej decimalf{lt */
    if ((*errpos=strchr(pos,' ')) != NullS && *errpos < pos+length)
    {
      DBUG_RETURN(3);				/* Felaktigt tecken mitt i */
    }
    if (!length)
    {
      length=1;
      *pos = '0';
    }
    decpos = pos+length;
  }

  while (decpos > pos) *--slutpos = *--decpos;
  if (inputflag & 4) fyll = '0';
  else fyll= ' ';
  while (slutpos != pos) *--slutpos = fyll;
  DBUG_RETURN (0);
} /* format_number */
