/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Functions to handle date and time */

#include "mysql_priv.h"
#include <m_ctype.h>

static ulong const days_at_timestart=719528;	/* daynr at 1970.01.01 */
static uchar *days_in_month= (uchar*) "\037\034\037\036\037\036\037\037\036\037\036\037";

static uint calc_days_in_year(uint year);


	/* Init some variabels neaded when using my_local_time */
	/* Currently only my_time_zone is inited */

static long my_time_zone=0;
void init_time(void)
{
  time_t seconds;
  struct tm *l_time;
  TIME my_time;

  seconds= (time_t) time((time_t*) 0);
  l_time=localtime(&seconds);
  my_time_zone=0;
  my_time.year=		(uint) l_time->tm_year;
  my_time.month=	(uint) l_time->tm_mon+1;
  my_time.day=		(uint) l_time->tm_mday;
  my_time.hour=		(uint) l_time->tm_hour;
  my_time.minute=	(uint) l_time->tm_min;
  my_time.sec=		(uint) l_time->tm_sec;
  VOID(my_gmt_sec(&my_time));		/* Init my_time_zone */
}

	/* Convert current time to sec. since 1970.01.01 */

long my_gmt_sec(TIME *t)
{
  time_t tmp;
  struct tm *l_time;
#ifdef _REENTRANT
  struct tm tm_tmp;
#endif
  long diff;

  if (t->hour >= 24)
  {					/* Fix for time-loop */
    t->day+=t->hour/24;
    t->hour%=24;
  }
  tmp=(time_t) ((calc_daynr((uint) t->year,(uint) t->month,(uint) t->day) -
		 (long) days_at_timestart)*86400L + (long) t->hour*3600L + 
		(long) (t->minute*60 + t->sec)) + (time_t) my_time_zone;
#ifdef _REENTRANT
  l_time=localtime_r(&tmp,&tm_tmp);
#else
  l_time=localtime(&tmp);
#endif
  while (t->hour != (uint) l_time->tm_hour)
  {					/* One check should be enough ? */
    diff=3600L*(long) ((((int) (t->hour - l_time->tm_hour)+36) % 24)-12);
    my_time_zone+=diff;
    tmp+=(time_t) diff;
#ifdef _REENTRANT
    l_time=localtime_r(&tmp,&tm_tmp);
#else
    l_time=localtime(&tmp);
#endif
  }
  if ((my_time_zone >=0 ? my_time_zone: -my_time_zone) > 3600L*12)
    my_time_zone=0;			/* Wrong date */
  return tmp;
} /* my_gmt_sec */


	/* Some functions to calculate dates */

	/* Calculate nr of day since year 0 in new date-system (from 1615) */

long calc_daynr(uint year,uint month,uint day)
{
  long delsum;
  int temp;
  DBUG_ENTER("calc_daynr");

  if (year == 0 && month == 0 && day == 0)
    DBUG_RETURN(0);				/* Skipp errors */
  if (year < 200)
  {
    if ((year=year+1900) < 1970)
      year+=100;
  }
  delsum= (long) (365L * year+ 31*(month-1) +day);
  if (month <= 2)
      year--;
  else
    delsum-= (long) (month*4+23)/10;
  temp=(int) ((year/100+1)*3)/4;
  DBUG_PRINT("exit",("year: %d  month: %d  day: %d -> daynr: %ld",
		     year+(month <= 2),month,day,delsum+year/4-temp));
  DBUG_RETURN(delsum+(int) year/4-temp);
} /* calc_daynr */


	/* Calc weekday from daynr */
	/* Returns 0 for monday, 1 for tuesday .... */

int calc_weekday(long daynr)
{
  DBUG_ENTER("calc_weekday");
  DBUG_PRINT("exit",("daynr: %d  weekday: %d",daynr,(daynr + 5L) % 7));
  DBUG_RETURN ((int) ((daynr + 5L) % 7));
}

	/* Calc days in one year. works with 0 <= year <= 99 */

static uint calc_days_in_year(uint year)
{
  return (year & 3) == 0 && (year%100 || (year%400 == 0 && year)) ?
    366 : 365;
}

	/* Change a daynr to year, month and day */
	/* Daynr 0 is returned as date 00.00.00 */

void get_date_from_daynr(long daynr,uint *ret_year,uint *ret_month,
			 uint *ret_day)
{
  uint year,temp,leap_day,day_of_year,days_in_year;
  uchar *month_pos;
  DBUG_ENTER("get_date_from_daynr");

  if (daynr <= 365L)
  {						/* Fix if wrong daynr */
    *ret_year= *ret_month = *ret_day =0;
  }
  else
  {
    year= (uint) (daynr*100 / 36525L);
    temp=(((year-1)/100+1)*3)/4;
    day_of_year=(uint) (daynr - (long) year * 365L) - (year-1)/4 +temp;
    while (day_of_year > (days_in_year= calc_days_in_year(year)))
    {
      day_of_year-=days_in_year;
      (year)++;
    }
    leap_day=0;
    if (days_in_year == 366)
    {
      if (day_of_year > 31+28)
      {
	day_of_year--;
	if (day_of_year == 31+28)
	  leap_day=1;		/* Handle leapyears leapday */
      }
    }
    *ret_month=1;
    for (month_pos= days_in_month ;
	 day_of_year > (uint) *month_pos ;
	 day_of_year-= *(month_pos++), (*ret_month)++)
      ;
    *ret_year=year;
    *ret_day=day_of_year+leap_day;
  }
  DBUG_VOID_RETURN;
}

/*	find date from string and put it in vektor
	Input: pos = "YYMMDD" OR "YYYYMMDD" in any order or
	"xxxxx YYxxxMMxxxDD xxxx" where xxx is anything exept
	a number. Month or day mustn't exeed 2 digits, year may be 4 digits.
*/


void find_date(string pos,uint *vek,uint flag)
{
  uint length,value;
  string start;
  DBUG_ENTER("find_date");
  DBUG_PRINT("enter",("pos: '%s'  flag: %d",pos,flag));

  bzero((byte*) vek,sizeof(int)*4);
  while (*pos && !isdigit (*pos))
    pos++;
  length=strlen(pos);
  for (uint i=0 ; i< 3; i++)
  {
    start=pos; value=0;
    while (isdigit(pos[0]) &&
	   ((pos-start) < 2 || ((pos-start) < 4 && length >= 8 &&
				!(flag & 3))))
    {
      value=value*10 + (uint) (uchar) (*pos - '0');
      pos++;
    }
    vek[flag & 3]=value; flag>>=2;
    while (*pos && ! isdigit (*pos))
      pos++;
  }
  DBUG_PRINT("exit",("year: %d  month: %d  day: %d",vek[0],vek[1],vek[2]));
  DBUG_VOID_RETURN;
} /* find_date */


	/* Calc date after x days.			*/
	/* Date as a date-string. returns a date-string */

void calc_next_date(string date,int days,uint flag,uint *res_length)
{
  uint vek[4],year,length,i;
  char buff[MAX_EQV_AOSBUFF],*pos,*start,*start_date;
  long daynr;

  start_date=date;
  if (! date[0])
  {
    get_date(buff,0,0L);			/* Use current date */
    pos=buff+2;					/* Skipp first part of year */
    find_date(pos,vek,(uint) (1*4+2*16));	/* YY-MM-DD */
  }
  else
  {
    VOID(strmov((pos=buff),date));
    find_date(buff,vek,flag);
  }
  if ((daynr=calc_daynr(vek[0],vek[1],vek[2])))
    get_date_from_daynr(daynr+days,&year,&vek[1],&vek[2]);
  else
  {
    year=vek[1]=vek[2]=0;
  }
  DBUG_PRINT("test",("year: %d  month: %d  day: %d", year, vek[1], vek[2]));
  if (vek[0] > 100)
    vek[0]=year;
  else
    vek[0]=year%100;

  while (*pos && !isdigit (*pos))
    *date++ = *pos++;

  length=strlen(pos);
  for (i=0 ; i< 3; i++)
  {
    start=pos;
    while (isdigit(pos[0]) &&
	   ((pos-start) < 2 || ((pos-start) < 4 && length >= 8 &&
				!(flag & 3))))
      pos++;
    sprintf(date,"%.*d",vek[flag & 3] >= 1000 ? 4 : 2,vek[flag & 3]);
    date=strend(date);
    flag>>=2;
    while (*pos && ! isdigit (*pos))
      *date++ = *pos++;
  }
  *date=0;
  *res_length= (uint) (date-start_date);
  return;
} /* calc_next_date */


#ifdef NOT_YET

	/* Outputs YYMMDD if input year < 100 or YYYYMMDD else */

static long calc_daynr_from_week(uint year,uint week,uint day)
{
  long daynr;
  int weekday;

  daynr=calc_daynr(year,1,1);
  if ((weekday= calc_weekday(daynr)) >= 3)
    daynr+= (7-weekday);
  else
    daynr-=weekday;

  return (daynr+week*7+day-8);
}

void convert_week_to_date(string date,uint flag,uint *res_length)
{
  string format;
  uint year,vek[4];

  find_date(date,vek,(uint) (1*4+2*16));		/* YY-WW-DD */
  year=vek[0];

  get_date_from_daynr(calc_daynr_from_week(vek[0],vek[1],vek[2]),
		      &vek[0],&vek[1],&vek[2]);
  *res_length=8;
  format="%04d%02d%02d";
  if (year < 100)
  {
    vek[0]= vek[0]%100;
    *res_length=6;
    format="%02d%02d%02d";
  }
  sprintf(date,format,vek[flag & 3],vek[(flag >> 2) & 3],
	  vek[(flag >> 4) & 3]);
  return;
}

	/* returns YYWWDD or YYYYWWDD according to input year */
	/* flag only reflects format of input date */

void convert_date_to_week(string date,uint flag,uint *res_length)
{
  uint vek[4],weekday,days,year,week,day;
  long daynr,first_daynr;
  char buff[MAX_EQV_AOSBUFF],*format;

  if (! date[0])
  {
    get_date(buff,0,0L);			/* Use current date */
    find_date(buff+2,vek,(uint) (1*4+2*16));	/* YY-MM-DD */
  }
  else
    find_date(date,vek,flag);

  year= vek[0];
  daynr=      calc_daynr(year,vek[1],vek[2]);
  first_daynr=calc_daynr(year,1,1);

	/* Caculate year and first daynr of year */
  if (vek[1] == 1 && (weekday=calc_weekday(first_daynr)) >= 3 &&
      vek[2] <= 7-weekday)
  {
    if (!year--)
      year=99;
    first_daynr=first_daynr-calc_days_in_year(year);
  }
  else if (vek[1] == 12 &&
	   (weekday=calc_weekday(first_daynr+calc_days_in_year(year))) < 3 &&
	   vek[2] > 31-weekday)
  {
    first_daynr=first_daynr+calc_days_in_year(year);
    if (year++ == 99)
      year=0;
  }

	/* Calulate daynr of first day of week 1 */
  if ((weekday= calc_weekday(first_daynr)) >= 3)
    first_daynr+= (7-weekday);
  else
    first_daynr-=weekday;

  days=(int) (daynr-first_daynr);
  week=days/7+1 ; day=calc_weekday(daynr)+1;

  *res_length=8;
  format="%04d%02d%02d";
  if (year < 100)
  {
    *res_length=6;
    format="%02d%02d%02d";
  }
  sprintf(date,format,year,week,day);
  return;
}

#endif

	/* Functions to handle periods */

ulong convert_period_to_month(ulong period)
{
  ulong a,b;
  if (period == 0)
    return 0L;
  if ((a=period/100) < 70)
    a+=2000;
  else if (a < 100)
    a+=1900;
  b=period%100;
  return a*12+b-1;
}

ulong convert_month_to_period(ulong month)
{
  ulong year;
  if (month == 0L)
    return 0L;
  if ((year=month/12) < 100)
  {
    year+=(year < 70) ? 2000 : 1900;
  }
  return year*100+month%12+1;
}

#ifdef NOT_YET

ulong add_to_period(ulong period,int months)
{
  if (period == 0L)
    return 0L;
  return convert_month_to_period(convert_period_to_month(period)+months);
}
#endif


/*****************************************************************************
** convert a timestamp string to a time_t (long) value.
** At least the following formats are recogniced (based on number of digits)
** YYMMDD, YYYYMMDD, YYMMDDHHMMSS, YYYYMMDDHHMMSS
** YY-MM-DD, YYYY-MM-DD, YY-MM-DD HH.MM.SS
*****************************************************************************/


time_t str_to_timestamp(const char *str,uint length)
{
  TIME l_time;
  uint field_length,year_length,digits,i,date[6];
  bool date_used=0;
  const char *pos;
  const char *end=str+length;
  for (; !isdigit(*str) && str != end ; str++) ; // Skipp garbage
  /*
  ** calculate first number of digits.
  ** If length= 4, 8 or >= 14 then year is of format YYYY
     (YYYY-MM-DD,  YYYYMMDD, YYYYYMMDDHHMMSS)
  */
  for (pos=str; pos != end && isdigit(*pos) ; pos++) ;
  digits= (uint) (pos-str);
  year_length= (digits == 4 || digits == 8 || digits >= 14) ? 4 : 2;
  field_length=year_length-1;
  for (i=0 ; i < 6 && str != end; i++)
  {
    uint tmp_value=(uint) (uchar) (*str++ - '0');
    while (str != end && isdigit(str[0]) && field_length--)
    {
      tmp_value=tmp_value*10 + (uint) (uchar) (*str - '0');
      str++;
    }
    if ((date[i]=tmp_value))
      date_used=1;				// Found something
    while (str != end && !isdigit(*str))
      str++;
    field_length=1;				// Rest fields can only be 2
  }
  if (!date_used)
    return 0;
  while (i < 3)
    date[i++]=1;				// 1 is default for month & day
  while (i < 6)
    date[i++]=0;
  l_time.year=	year_length == 4 ? date[0] :
    (date[0] < 70 ? date[0]+2000 : date[0]+1900);
  l_time.month=	date[1];
  l_time.day=	date[2];
  l_time.hour=	date[3];
  l_time.minute=date[4];
  l_time.sec=	date[5];
  return my_gmt_sec(&l_time);
}

/*****************************************************************************
** convert a date string to a (ulong) value.
** At least following formats are recogniced
** YY-MM-DD, YYYY-MM-DD, YYMMDD
** Returns ulong of format YYYYMMDD
*****************************************************************************/

ulong str_to_date(const char *str,uint length)
{
  TIME l_time;
  uint field_length,year_length,digits,i,date[3];
  const char *pos;
  const char *end=str+length;
  for (; !isdigit(*str) && str != end ; str++) ;
  /*
  ** calculate first number of digits.
  ** If length= 4, 8 or >= 14 then year is of format YYYY
     (YYYY-MM-DD,  YYYYMMDD)
  */
  for (pos=str; pos != end && isdigit(*pos) ; pos++) ;
  digits= (uint) (pos-str);
  year_length= (digits == 4 || digits == 8 || digits >= 14) ? 4 : 2;
  field_length=year_length-1;

  for (i=0 ; i < 3 && str != end; i++)
  {
    uint tmp_value=(uint) (uchar) (*str++ - '0');
    while (str != end && isdigit(str[0]) && field_length--)
    {
      tmp_value=tmp_value*10 + (uint) (uchar) (*str - '0');
      str++;
    }
    date[i]=tmp_value;
    while (str != end && !isdigit(*str))
      str++;
    field_length=1;				// Rest fields can only be 2
  }
  if (date[0] == 0 && i <= 1)
    return 0;					// Only year == 0 given.
  if (year_length == 2)
    date[0]+= (date[0] < 70 ? 2000 : 1900);
  if (date[1] > 12 || date[2] > 31)		/* giovanni */
    return (ulong) -1L;
  while (i < 3)
    date[i++]=1;				// Add default month and day
  return (ulong) date[0]*10000L + (ulong) (date[1]*100+date[2]);
}

/*****************************************************************************
** convert a time string to a (ulong) value.
** At least following formats are recogniced
** HHMMSS HHMM HH HH.MM.SS
** Return: HHMMSS
*****************************************************************************/

ulong str_to_time(const char *str,uint length)
{
  TIME l_time;
  uint i,date[3];
  const char *pos;
  const char *end=str+length;
  for (; !isdigit(*str) && str != end ; str++) ;

  for (i=0 ; i < 3 && str != end; i++)
  {
    uint tmp_value=(uint) (uchar) (*str++ - '0');
    if (str != end && isdigit(str[0]))
    {
      tmp_value=tmp_value*10 + (uint) (uchar) (*str - '0');
      str++;
    }
    date[i]=tmp_value;
    while (str != end && !isdigit(*str))
      str++;
  }
  while (i < 3)
    date[i++]=0;
  return (ulong) date[0]*10000L + (ulong) (date[1]*100+date[2]);
}

/*****************************************************************************
** convert a full time string to a (longlong) value.
** At least following formats are recogniced
** HHMMSS HHMM HH HH.MM.SS
** Return: HHMMSS
*****************************************************************************/

longlong str_to_datetime(const char *str,uint length) /* giovanni */
{
  TIME l_time;
  uint field_length,year_length,digits,i,date[6];
  const char *pos;
  const char *end=str+length;
  for (; !isdigit(*str) && str != end ; str++) ;
  /*
  ** calculate first number of digits.
  ** If length= 4, 8 or >= 14 then year is of format YYYY
     (YYYY-MM-DD,  YYYYMMDD)
  */
  for (pos=str; pos != end && isdigit(*pos) ; pos++) ;
  digits= (uint) (pos-str);
  year_length= (digits == 4 || digits == 8 || digits >= 14) ? 4 : 2;
  field_length=year_length-1;

  for (i=0 ; i < 6 && str != end; i++)
  {
    uint tmp_value=(uint) (uchar) (*str++ - '0');
    while (str != end && isdigit(str[0]) && field_length--)
    {
      tmp_value=tmp_value*10 + (uint) (uchar) (*str - '0');
      str++;
    }
    date[i]=tmp_value;
    while (str != end && !isdigit(*str))
      str++;
    field_length=1;				// Rest fields can only be 2
  }
  if (date[0] == 0 && i <= 1)
    return 0;					// Only year == 0 given.
  if (year_length == 2) /* giovanni */
    date[0]+= (date[0] < 70 ? 2000 : 1900);
  while (i < 3)
    date[i++]=1;				// Add default month and day
  while (i < 6)
    date[i++]=0;				// Add default time
  if(date[1] > 12 || date[2] > 31||date[3] > 23||date[4] > 59 || date[5] > 59)
    return -1LL; 
  return (longlong) date[0]*10000000000LL + (longlong) (date[1]*100000000LL+date[2]*1000000LL+date[3]*10000LL+date[4]*100+date[5]);
}
