/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Mallocs for used in threads */

#include "mysql_priv.h"


gptr sql_alloc(unsigned int Size)
{
  MEM_ROOT *root=(MEM_ROOT*) pthread_getspecific(THR_MALLOC);
  return sql_alloc_root(root,Size);
}


gptr sql_calloc(uint size)
{
  gptr ptr;
  if ((ptr=sql_alloc(size)))
    bzero(ptr,size);
  return ptr;
}


char *sql_strdup(const char *str)
{
  uint len=strlen(str)+1;
  char *pos;
  if ((pos=sql_alloc(len)))
    memcpy(pos,str,len);
  return pos;
}

gptr sql_memdup(const gptr ptr,uint len)
{
  char *pos;
  if ((pos=sql_alloc(len)))
    memcpy(pos,ptr,len);
  return pos;
}

void sql_element_free(void *ptr __attribute__((unused)))
{}
