/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Funktioner som beh|vs medan man testar programmet */

#ifndef DBUG_OFF
#include "mysql_priv.h"
#include "select_q.h"

	/* Write used select on dbug-file */

static string operat[]=
{ "", "=","<>","<","<=",">",">=","~","!~","?","?","?","?","?","?","?",};

void TEST_select(SELECT* select)
{
  uint rownr;
  SELECT_TYPE *type;
  SELECT_ROW *s;
  SELECT_QUICK *quick;
  DBUG_ENTER("TEST_select");

  if (select != NULL)
  {
    VOID(fputs("\nInfo about SELECT\n",DBUG_FILE));
    fprintf(DBUG_FILE,"maxreg: %d  reg used: %x\n",
		       select->maxreg,select->reg_used);
    if (my_b_inited(&select->file))
    {
      fprintf(DBUG_FILE,"Records selected: %ld\n",select->records);
      DBUG_VOID_RETURN;
    }

    for (s=select->row,rownr=0; s->flag ; rownr++,s++)
    {
      if (s->flag & (SELECT_FLAG_NO_FIELDS | SELECT_FLAG_ALWAYS_TRUE |
		     SELECT_FLAG_ALWAYS_FALSE))
	fprintf(DBUG_FILE,"flag: %d",s->flag);
      else
      {
	fprintf(DBUG_FILE,"%2d:  regs: %2x  %s  flag: %4d  jump: %2d  ",
		rownr,
		s->reg_used,
		(s->cmp_type != SEL_CMP_NUM ? "strcmp" : "numcmp"),
		s->flag,
		(uint) (s->jump - select->row));
	VOID(fflush(DBUG_FILE));
	type= &s->field;
	switch (s->field_type) {
	case SEL_FIELD_FIELD:
	  fprintf(DBUG_FILE,"field:  #%d.%d",
			   type->field.regnr,
			   ((uint)((char*) type->field.regfield -
			   (char*) select->forms[type->field.regnr]->field))/
			   sizeof(FIELD)+1);
	   break;
	case SEL_FIELD_CONST_STR:
	  fprintf(DBUG_FILE,"string: '%s'",type->str);
	  break;
	case SEL_FIELD_CONST_NUM:
	  fprintf(DBUG_FILE,"number: '%lg'",type->nr);
	  break;
	case SEL_FIELD_FORMULA:
	case SEL_FIELD_NOT_USED:
	  break;
	default:
	  fprintf(DBUG_FILE,"not allowed: %d",s->field_type);
	}
	fprintf(DBUG_FILE," %s ",operat[s->flag & SELECT_FLAG_OP]);
	VOID(fflush(DBUG_FILE));
	type= &s->diff;
	switch (s->diff_type) {
	case SEL_FIELD_FIELD:
	  fprintf(DBUG_FILE,"field:  #%3d.%3d",
			   type->field.regnr,
			   ((uint)((char*) type->field.regfield -
			   (char*) select->forms[type->field.regnr]->field))/
			   sizeof(FIELD)+1);
	   break;
	case SEL_FIELD_CONST_STR:
	  fprintf(DBUG_FILE,"string: '%s'",type->str);
	  break;
	case SEL_FIELD_CONST_NUM:
	  fprintf(DBUG_FILE,"number: '%lg'",type->nr);
	  break;
	case SEL_FIELD_FORMULA:
	  break;
	default:
	  fprintf(DBUG_FILE,"not allowd: %d",s->diff_type);
	}
      }
      fprintf(DBUG_FILE,"\n");
    }
    if ((quick=select->quick))
    {
      SELECT_QUICK_REGION *region;
      fprintf(DBUG_FILE,"\nQuick-select rows: %d  index: %d  records: %ld\n",
	      (uint) (quick->end-quick->region),quick->index,quick->records);
      for (region=quick->region ; region != quick->end ; region++)
      {
	if (f_is_num(quick->field->pack_flag))
	  fprintf(DBUG_FILE,"min_flag: %d  min_buff: %lg\nmax_flag: %d  max_buff: %lg\n",
		  region->min_flag,region->min_arg.nr,
		  region->max_flag,region->max_arg.nr);
	else
	  fprintf(DBUG_FILE,"min_flag: %d  min_buff: '%s'\nmax_flag: %d  max_buff: '%s'\n",
		  region->min_flag,region->min_arg.str.str,
		  region->max_flag,region->max_arg.str.str);
      }
    }
  }

  DBUG_VOID_RETURN;
} /* TEST_select */


void TEST_filesort(TABLE **table,SORT_FIELD *sortorder,uint s_length,
		   ulong special)
{
  uint i,length,maxreg_used,reg_used;
  string sep;
  DBUG_ENTER("TEST_filesort");

  VOID(fputs("\nInfo about FILESORT\n",DBUG_FILE));
  if (special)
    fprintf(DBUG_FILE,"Records to sort: %ld\n",special);

  fprintf(DBUG_FILE,"Sortorder: ");
  length=0; maxreg_used=1; reg_used=1;
  for (sep=""; s_length-- ; sortorder++, sep="/")
  {
    fprintf(DBUG_FILE,"#%s%s%d.%d",sep,
	    (sortorder->reverse ? "-" : ""),
	    sortorder->regnr,sortorder->fieldnr+1);
    length+=packlength(table[sortorder->regnr]->field+sortorder->fieldnr);
    if (sortorder->regnr)
    {
      reg_used|= (1 << sortorder->regnr);
      if (sortorder->regnr >= (int7) maxreg_used)
	maxreg_used=(int) sortorder->regnr+1;
    }
  }
  fprintf(DBUG_FILE,"\nSortlength: %d  maxreg_used: %d  reg_used: %u\n",
	  length,maxreg_used,get_ref_regs(table,reg_used));
  for (i=1 ; i < maxreg_used ; i++)
    if (reg_used & (1 << i))
      fprintf(DBUG_FILE,"regnr: %d  key_nr: %d  keylength: %d\n",
	      i,table[i]->form.reginfo.ref_key,
	      table[i]->form.reginfo.ref_length);
  DBUG_VOID_RETURN;
} /* TEST_filesort */

#endif
