/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* sql_yacc.y */

%{
#define YYPURE
#define MYSQL_YACC
#define Lex current_lex
#include "mysql_priv.h"
#include "sql_lex.h"

extern void yyerror(char*);
int yylex(void *yylval);
%}
%union {
  int  num;
  ulong ulong_num;
  char *str;
  Item *item;
  List<Item> *item_list;
  enum Key::Keytype key_type;
  COND *cond;
  String *string;
  key_part_spec *key_part;
}

%token	END_OF_INPUT

%token	EQ
%token	GE
%token	GT_SYMBOL
%token	LE
%token	LT
%token	NE
%token	IS

%token	AVG_SUM
%token	COUNT_SUM
%token	MAX_SUM
%token	MIN_SUM
%token	SUM_SUM

%token	ADD
%token	ALTER
%token	CHANGE
%token	CREATE
%token	CREATE_TABLE
%token	CREATE_INDEX
%token	DELETE
%token	DROP
%token	DROP_TABLE
%token	DROP_INDEX
%token	INSERT
%token	INSERT_SELECT
%token	SELECT_SYMBOL
%token	SHOW
%token	UPDATE_SYMBOL
%token  LOAD

%token	ALL
%token	AS
%token	DISTINCT
%token  STRAIGHT_JOIN

%token	AND
%token	ASC
%token	BY
%token  CASCADE
%token	DATA_SYMBOL
%token	DATABASES
%token	DEFAULT
%token	DESC
%token	DESCRIBE
%token	COLUMN_SYMBOL
%token	COLUMNS
%token	ESCAPED
%token	ENCLOSED
%token  FOREIGN
%token	KEYS
%token	FROM
%token	GROUP
%token	IGNORE
%token  INDEX
%token	INFILE
%token	INTO
%token	IN_SYMBOL
%token	LIKE
%token	LINES
%token	REGEXP
%token  RESTRICT
%token  REFERENCES
%token	NOT
%token	NULL_SYMBOL
%token  ON
%token	OPTIONALLY
%token	OR
%token	ORDER_SYMBOL
%token	OUTFILE
%token  HAVING
%token	SET
%token	TABLES
%token	TABLE_SYMBOL
%token	TERMINATED
%token	VALUES
%token	WHERE

%token	KEY_SYMBOL
%token	PRIMARY_SYMBOL
%token	UNIQUE_SYMBOL
%token  AUTO_INC

%token	IDENT
%token	NUM
%token	REAL_NUM
%token	TEXT

%token	CHAR
%token	VARYING
%token	INT
%token	REAL
%token	SMALLINT
%token	BIGINT
%token	VARCHAR
%token	BLOB
%token	TINYBLOB
%token	MEDIUMBLOB
%token	LONGBLOB
%token	TIMESTAMP
%token	DATE_SYMBOL
%token	TIME_SYMBOL
%token	TINYINT
%token	MEDIUMINT
%token	FLOAT
%token	DOUBLE
%token	DECIMAL
%token	NUMERIC
%token	ZEROFILL
%token	UNSIGNED
%token  PRECISION
%token	LIMIT

%token	ABS
%token	ASCII
%token	BETWEEN
%token	BIT_COUNT
%token  CEILING
%token	CONCAT
%token	CURDATE
%token  DATABASE
%token  EXP
%token	ELT_FUNC
%token	FLOOR
%token  FORMAT
%token	FROM_DAYS
%token	GROUP_UNIQUE_USERS
%token	INTERVAL
%token	IF
%token	IFNULL
%token	ISNULL
%token	LCASE
%token	LEFT
%token	LENGTH
%token	LOCATE
%token  LOG
%token  LOG10
%token	LTRIM
%token	NOW_SYMBOL
%token	MOD_SYMBOL
%token	PASSWORD
%token	PERIOD_ADD
%token	PERIOD_DIFF
%token  POW
%token	PROCEDURE
%token	RAND
%token	REPEAT
%token	REPLACE
%token	RIGHT
%token  ROUND
%token	RTRIM
%token	SIGN
%token  SQRT
%token	STRCMP
%token	SUBSTRING
%token	TO_DAYS
%token	UCASE
%token	UNIQUE_USERS
%token  USER
%token	WEEKDAY

%left AND OR
%left EQ GE GT_SYMBOL LE LT NE IS LIKE REGEXP
%left '-' '+'
%left '*' '/' '%'
%left NEG

%type <str>
	IDENT TEXT REAL_NUM NUM remember_name remember_end SIDENT select_alias
	opt_len opt_sident

%type <string>
	text_string

%type <num>
	type int_type real_type opt_nullspec opt_keyspec opt_field_type
	order_dir opt_field_spec opt_unique

%type <ulong_num>
	ULONG_NUM

%type <item>
	literal text_literal insert_ident group_ident order_ident
	procedure_item2 simple_ident select_item2 expr sum_ident table_ident
	cond_literal opt_default  having_and_list having_or_list

%type <cond>
	cond_or_list cond_and_list cond_statement

%type <item_list>
	expr_list

%type <key_type>
	key_type

%type <key_part>
	key_part

%type <NONE>
	query verb_clause create select drop insert insert_values update delete
	show describe load alter field_list field_list_item field_spec
	select_item_list select_item table_list limit_clause END_OF_INPUT
	fields values procedure_list procedure_item expr_list2
	opt_unsigned opt_zero opt_precision opt_ignore opt_column opt_restrict

%type <NONE>
	'-' '+' '*' '/' '%' '=' '<' '>' '[' ']' '(' ')'
	',' '!' ':' ';' '{' '}' '&' '|'
%%


query:
	END_OF_INPUT { send_error(&current_thd->net,ER(ER_EMPTY_QUERY)); }
	| verb_clause END_OF_INPUT { mysql_execute_command(); }

verb_clause:
	  create
	| select
	| drop
	| insert
	| update
	| delete
	| show
	| describe
	| load
	| alter

/* create a table */

create:
	CREATE TABLE_SYMBOL SIDENT
	  {
	    Lex->sql_command = CREATE_TABLE;
	    add_table_to_list($3,NULL);
	    Lex->col_list.empty();
	    Lex->change=NullS;
	  }
	  '(' field_list ')'
	| CREATE opt_unique INDEX SIDENT ON SIDENT
	  {
	    Lex->sql_command= CREATE_INDEX;
	    Lex->unique_flag= (bool) $2;
	    Lex->col_list.empty();
	    add_table_to_list($6,NULL);
	    Lex->change=NullS;
	  }
	  '(' key_list ')'

field_list:
	  field_list_item
	| field_list ',' field_list_item


field_list_item:
	  field_spec
	| key_type opt_sident '(' key_list ')'
	  { 
	    current_thd->key_list.push_back(new Key($1,$2,Lex->col_list));
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| FOREIGN KEY_SYMBOL SIDENT '(' key_list ')' REFERENCES SIDENT opt_on_delete
	  { 
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }

field_spec:
	IDENT { Lex->length=Lex->dec=0; Lex->type=0;}
	type opt_nullspec opt_default opt_field_type opt_keyspec
	{
	    if (add_field_to_list($1,
				  (enum enum_field_types) $3,
				  Lex->length,Lex->dec,Lex->type, $4, $6, $7,
				  $5,Lex->change))
	      return 0;
	}
	

type:
	int_type opt_len opt_unsigned opt_zero	{ Lex->length=$2; $$=$1; }
	| real_type opt_precision opt_unsigned opt_zero { $$=$1; }
	| FLOAT	float_options opt_unsigned opt_zero	{ $$=FIELD_TYPE_FLOAT; }
	| CHAR '(' NUM ')'		{ Lex->length=$3; 
					  $$=FIELD_TYPE_STRING; }
	| VARCHAR '(' NUM ')'		{ Lex->length=$3;
					  $$=FIELD_TYPE_VAR_STRING; }
	| CHAR VARYING '(' NUM ')'	{ Lex->length=$4;
					  $$=FIELD_TYPE_VAR_STRING; }
	| DATE_SYMBOL			{ $$=FIELD_TYPE_DATE; }
	| TIME_SYMBOL			{ $$=FIELD_TYPE_TIME; }
	| TINYBLOB			{ $$=FIELD_TYPE_TINY_BLOB; }
	| BLOB				{ $$=FIELD_TYPE_BLOB; }
	| MEDIUMBLOB			{ $$=FIELD_TYPE_MEDIUM_BLOB; }
	| LONGBLOB			{ $$=FIELD_TYPE_LONG_BLOB; }
	| TIMESTAMP	 		{ $$=FIELD_TYPE_TIMESTAMP; }
	| TIMESTAMP '(' NUM ')'		{ Lex->length=$3;
					  $$=FIELD_TYPE_TIMESTAMP; }
	| DECIMAL '(' NUM ',' NUM ')' opt_unsigned opt_zero
					{ Lex->length=$3; Lex->dec=$5;
					  $$=FIELD_TYPE_DECIMAL;}
	| NUMERIC '(' NUM ',' NUM ')' opt_unsigned opt_zero
					{ Lex->length=$3; Lex->dec=$5;
					  $$=FIELD_TYPE_DECIMAL;}

int_type:
	INT		{ $$=FIELD_TYPE_LONG; }
	| TINYINT	{ $$=FIELD_TYPE_CHAR; }
	| SMALLINT	{ $$=FIELD_TYPE_SHORT; }
	| MEDIUMINT	{ $$=FIELD_TYPE_INT24; }
	| BIGINT	{ $$=FIELD_TYPE_LONGLONG; }

real_type:
	REAL		{ $$=FIELD_TYPE_DOUBLE; }
	| DOUBLE	{ $$=FIELD_TYPE_DOUBLE; }
	| DOUBLE PRECISION { $$=FIELD_TYPE_DOUBLE; }


float_options:
	/* empty */		{}
	| '(' NUM ')'		{ Lex->length=$2; }
	| '(' NUM ',' NUM ')'	{ Lex->length=$2; Lex->dec=$4; }

opt_unsigned:
	/* empty */	{}
	| UNSIGNED	{ Lex->type|= UNSIGNED_FLAG;}

opt_zero:
	/* empty */	{}
	| ZEROFILL	{ Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }

opt_len:
	/* empty */	{ $$=(char*) 0; }	/* Defaultlength */
	| '(' NUM ')'	{ $$=$2; }

opt_precision:
	/* empty */	{}
	| '(' NUM ',' NUM ')'	{ Lex->length=$2; Lex->dec=$4; }

opt_nullspec:
	/* empty */	  { $$ = 0; }		/* Default is NULL */
	| NULL_SYMBOL	  { $$ = 0; }
	| NOT NULL_SYMBOL { $$ = 1; }


opt_default:
	/* empty */	  { $$ = 0; }
	| DEFAULT literal { $$ = $2;}

opt_keyspec:					/* This is to emualate mysql */
	/* empty */	{ $$= 0; }
	| PRIMARY_SYMBOL KEY_SYMBOL { $$= PRI_KEY_FLAG; }

opt_on_delete:
	/* empty */
	| ON DELETE delete_option

delete_option:
	RESTRICT
	| CASCADE
	| SET NULL_SYMBOL

key_type:
	PRIMARY_SYMBOL KEY_SYMBOL { $$=Key::PRIMARY; }
	| key_or_index	   { $$=Key::MULTIPLE; }
	| UNIQUE_SYMBOL	   { $$=Key::UNIQUE; }

key_or_index:
	KEY_SYMBOL {}
	| INDEX {}
	
opt_field_type:	
	/* empty */	{ $$= 0; }
	| AUTO_INC	{ $$= MTYP_NEXT_NUMBER; }

opt_unique:	
	/* empty */	{ $$= 0; }
	| UNIQUE_SYMBOL	{ $$= 1; }

key_list:
	key_list ',' key_part order_dir { Lex->col_list.push_back($3); }
	| key_part order_dir		{ Lex->col_list.push_back($1); }

key_part:
	IDENT 			{ $$=new key_part_spec($1); }
	| IDENT '(' NUM ')'	{ $$=new key_part_spec($1,(uint) atoi($3)); }

opt_sident:
	/* empty */	{ $$=(char*) 0; }	/* Defaultlength */
	| SIDENT	{ $$=$1; }

/*
** Alter table
*/

alter:
	ALTER opt_ignore TABLE_SYMBOL SIDENT
	{
	   Lex->sql_command = ALTER;
	   add_table_to_list($4,NULL);
	   Lex->drop_primary=0;
	   Lex->col_list.empty();
	   Lex->drop_list.empty();
	   Lex->alter_list.empty();
	   Lex->duplicates=DUP_ERROR;
	}
	alter_list

alter_list:
	  alter_list_item
	| alter_list ',' alter_list_item


alter_list_item:
	ADD opt_column { Lex->change=0;} field_list_item
	| CHANGE opt_column SIDENT { Lex->change= $3; } field_spec
	| DROP opt_column SIDENT opt_restrict
	  { Lex->drop_list.push_back(new Alter_drop(Alter_drop::COLUMN,
						    $3)); }
	| DROP PRIMARY_SYMBOL KEY_SYMBOL { Lex->drop_primary=1; }
	| DROP FOREIGN KEY_SYMBOL SIDENT {}
	| DROP key_or_index SIDENT
	  { Lex->drop_list.push_back(new Alter_drop(Alter_drop::KEY,
						    $3)); }
	| ALTER opt_column SIDENT SET literal
	  { Lex->alter_list.push_back(new Alter_column($3,$5)); }
	| ALTER opt_column SIDENT DROP DEFAULT
	  { Lex->alter_list.push_back(new Alter_column($3,(Item*) 0)); }

opt_column:
	/* empty */	{}
	| COLUMN_SYMBOL	{}

opt_ignore:
	/* empty */	{}
	| IGNORE	{ Lex->duplicates=DUP_IGNORE; }

opt_restrict:
	/* empty */	{}
	| RESTRICT	{}
	| CASCADE	{}

/*
** Select : retrieve data from table
*/


select:
	SELECT_SYMBOL
	{
	  LEX *lex=Lex;
	  lex->where=lex->having=0;
	  lex->select_limit=lex->offset_limit=0L;
	  lex->select_options=0;
	  lex->sql_command = SELECT_SYMBOL;
	}
	select_options select_item_list select_from opt_into

select_from:
	/* empty */
	| FROM table_list where_clause group_clause order_clause having_clause limit_clause procedure_clause


select_options:
	  opt_straight_join opt_distinct 

opt_straight_join:
	/* empty */
	| STRAIGHT_JOIN { Lex->select_options|= SELECT_STRAIGHT_JOIN; }

opt_distinct:
	/* empty */
	| ALL
	| DISTINCT	{ Lex->select_options|= SELECT_DISTINCT; }

select_item_list:
	  select_item_list ',' select_item
	| select_item
	| '*'
	  {
	    add_item_to_list(new Item_field(NULL,"*"));
	  }


select_item:
	  remember_name select_item2 remember_end select_alias
	  {
	    add_item_to_list($2);
	    if ($4)
	      $2->set_name($4);
	    else if (!$2->name)
	      $2->set_name($1,(uint) ($3 - $1));
	  }

remember_name:
	{ $$=(char*) Lex->tok_start; }

remember_end:
	{ $$=(char*) Lex->tok_end; }

select_item2:
	sum_ident	{ $$=$1; Lex->tok_end++; }
	| table_ident	{ $$=$1; } /* table.* */
	| expr		{ $$=$1; }

select_alias:
	{ $$=0;}
	| AS IDENT { $$=$2; }
	| AS TEXT  { $$=$2; }

expr:
	simple_ident		{ $$=$1; }
	| literal		{ $$=$1; }
	| expr OR expr		{ $$= new Item_func_or($1,$3); }
	| expr AND expr		{ $$= new Item_func_and($1,$3); }
	| expr LIKE expr	{ $$= new Item_func_like($1,$3); }
	| expr NOT LIKE expr	{ $$= new Item_func_nlike($1,$4); }
	| expr REGEXP text_literal { $$= new Item_func_regex($1,$3); }
	| expr NOT REGEXP text_literal { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| expr IS NULL_SYMBOL	{ $$= new Item_func_isnull($1); }
	| expr IS NOT NULL_SYMBOL { $$= new Item_func_isnotnull($1); }
	| expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| expr GT_SYMBOL expr	{ $$= new Item_func_gt($1,$3); }
	| expr LE expr		{ $$= new Item_func_le($1,$3); }
	| expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| expr '%' expr		{ $$= new Item_func_mod($1,$3); }
	| '-' expr %prec NEG	{ $$= new Item_func_neg($2); }
	| NOT expr %prec NEG	{ $$= new Item_func_not($2); }
	| '!' expr %prec NEG	{ $$= new Item_func_not($2); }
	| '(' expr ')' 		{ $$= $2; }
	| ABS '(' expr ')'	{ $$= new Item_func_abs($3); }
	| CEILING '(' expr ')'	{ $$= new Item_func_ceiling($3); }
	| FLOOR '(' expr ')'	{ $$= new Item_func_floor($3); }
	| ROUND '(' expr ')'	{ $$= new Item_func_round($3); }
	| RAND '(' expr ')'	{ $$= new Item_func_rand($3); }
	| RAND '(' ')'		{ $$= new Item_func_rand(); }
	| EXP '(' expr ')'	{ $$= new Item_func_exp($3); }
	| LOG '(' expr ')'	{ $$= new Item_func_log($3); }
	| LOG10 '(' expr ')'	{ $$= new Item_func_log10($3); }
	| SQRT '(' expr ')'	{ $$= new Item_func_sqrt($3); }
	| POW '(' expr ',' expr ')'
	  { $$= new Item_func_pow($3,$5); }
	| SIGN '(' expr ')'	{ $$= new Item_func_sign($3); }
	| BIT_COUNT '(' expr ')' { $$=new Item_func_bit_count($3); }
	| MOD_SYMBOL '(' expr ',' expr ')'
	  { $$= new Item_func_mod($3,$5); }
	| MIN_SUM '(' expr ',' expr_list ')'
	  { $5->push_front($3); $$= new Item_func_min(*$5); }
	| MAX_SUM '(' expr ',' expr_list ')'
	  { $5->push_front($3); $$= new Item_func_max(*$5); }
	| CONCAT '(' expr_list ')'
	  { $$= new Item_func_concat(* $3); }
	| REPLACE '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_replace($3,$5,$7); }
	| INSERT '(' expr ',' expr ',' expr ',' expr ')'
	  { $$= new Item_func_insert($3,$5,$7,$9); }
	| LCASE '(' expr ')'	  { $$= new Item_func_lcase($3); }
	| UCASE '(' expr ')'	  { $$= new Item_func_ucase($3); }
	| LENGTH '(' expr ')' 	  { $$= new Item_func_length($3); }
	| STRCMP '(' expr ',' expr ')'
	  { $$= new Item_func_strcmp($3,$5); }
	| LOCATE '(' expr ',' expr ')'
	  { $$= new Item_func_locate($3,$5); }
	| LOCATE '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_locate($3,$5,$7); }
	| LEFT '(' expr ',' expr ')'
	  { $$= new Item_func_left($3,$5); }
	| RIGHT '(' expr ',' expr ')'
	  { $$= new Item_func_right($3,$5); }
	| LTRIM '(' expr ')'
	  { $$= new Item_func_ltrim($3); }
	| RTRIM '(' expr ')'
	  { $$= new Item_func_rtrim($3); }
	| SUBSTRING '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_substr($3,$5,$7); }
	| PASSWORD '(' expr ')'   { $$= new Item_func_password($3); }
	| INTERVAL '(' expr ',' expr_list ')'
	{ $$= new Item_func_intervall($3,* $5); }
	| ELT_FUNC '(' expr ',' expr_list ')'
	  { $$= new Item_func_elt($3, *$5); }
	| BETWEEN '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_between($3,$5,$7); }
	| PERIOD_ADD '(' expr ',' expr ')'
	  { $$= new Item_func_period_add($3,$5); }
	| PERIOD_DIFF '(' expr ',' expr ')'
	  { $$= new Item_func_period_diff($3,$5); }
	| TO_DAYS '(' expr ')'
	  { $$= new Item_func_to_days($3); }
	| FROM_DAYS '(' expr ')'
	  { $$= new Item_func_from_days($3); }
	| WEEKDAY '(' expr ')'
	  { $$= new Item_func_weekday($3); }
	| CURDATE '(' ')'
	  { $$= new Item_func_curdate(); }
	| NOW_SYMBOL '(' ')'
	  { $$= new Item_func_now(); }
	| USER '(' ')'
	  { $$= new Item_func_user(); }
	| DATABASE '(' ')'
	  { $$= new Item_func_database(); }
	| UNIQUE_USERS '(' text_literal ',' NUM ',' NUM ',' expr_list ')'
	  { $$= new Item_func_unique_users($3,atoi($5),atoi($7), * $9); }
	| ISNULL '(' expr ')'
	  { $$= new Item_func_isnull($3); }
	| IFNULL '(' expr ',' expr ')'
	  { $$= new Item_func_ifnull($3,$5); }
	| IF '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_if($3,$5,$7); }
	| FORMAT '(' expr ',' NUM ')'
	  { $$= new Item_func_format($3,atoi($5)); }

expr_list:
	{ Lex->expr_list.push_front(new List<Item>); }
	expr_list2
	{ $$= Lex->expr_list.pop(); }

expr_list2:
	expr { Lex->expr_list.head()->push_back($1); }
	| expr_list2 ',' expr { Lex->expr_list.head()->push_back($3); }

table_list:
	SIDENT		  { add_table_to_list($1,NULL); }
	| SIDENT table_alias IDENT { add_table_to_list($1, $3); }
	| table_list ',' SIDENT   { add_table_to_list($3,NULL); }
	| table_list ',' SIDENT table_alias IDENT { add_table_to_list($3, $5); }

table_alias:
	/* empty */
	| AS
	| EQ

where_clause:
	/* empty */	     { Lex->where= 0; } 
	| WHERE cond_or_list { Lex->where= $2; }

cond_or_list:
	cond_and_list
	| cond_or_list OR cond_and_list    { $$=add_or_conds($1,$3); }

cond_and_list:
	cond_statement
	| cond_and_list AND cond_statement { $$=add_and_conds($1,$3); }

cond_statement:
	simple_ident EQ cond_literal   { $$= new Item_func_eq($1,$3); }
	| cond_literal EQ simple_ident { $$= new Item_func_eq($3,$1); }
	| simple_ident NE cond_literal { $$= new Item_func_ne($1,$3); }
	| cond_literal NE simple_ident { $$= new Item_func_ne($3,$1); }
	| simple_ident LT cond_literal { $$= new Item_func_lt($1,$3); }
	| cond_literal LT simple_ident { $$= new Item_func_ge($3,$1); }
	| simple_ident LE cond_literal { $$= new Item_func_le($1,$3); }
	| cond_literal LE simple_ident { $$= new Item_func_gt($3,$1); }
	| simple_ident GT_SYMBOL cond_literal { $$= new Item_func_gt($1,$3); }
	| cond_literal GT_SYMBOL simple_ident { $$= new Item_func_le($3,$1); }
	| simple_ident GE cond_literal { $$= new Item_func_ge($1,$3); }
	| cond_literal GE simple_ident { $$= new Item_func_lt($3,$1); }
	| simple_ident LIKE cond_literal { $$= new Item_func_like($1,$3); }
	| simple_ident NOT LIKE cond_literal { $$= new Item_func_nlike($1,$4); }
	| simple_ident IS NULL_SYMBOL  { $$= new Item_func_isnull($1); }
	| simple_ident IS NOT NULL_SYMBOL { $$= new Item_func_isnotnull($1); }
	| '(' cond_or_list ')' { $$=$2; }

having_clause:
	/* empty */
	| HAVING { Lex->create_refs=1; } having_or_list
	{ Lex->having= $3; Lex->create_refs=0; }

having_or_list:
	having_and_list
	| having_or_list OR having_and_list    { $$=add_or_conds($1,$3); }

having_and_list:
	expr
	| having_and_list AND expr { $$=add_and_conds($1,$3); }
	| '(' having_or_list ')'   { $$=$2; }
	
/*
** group by statement in select
*/

group_clause:
	/* empty */
	| GROUP BY group_list

group_list:
	group_list ',' group_ident order_dir
		{ add_group_to_list($3,(bool) $4); }
	| group_ident order_dir
		{ add_group_to_list($1,(bool) $2); }

/*
** Order by statement in select
*/

order_clause:
	/* empty */
	| ORDER_SYMBOL BY order_list

order_list:
	order_list ',' order_ident order_dir
	  { add_order_to_list($3,(bool) $4); }
	| order_ident order_dir
	  { add_order_to_list($1,(bool) $2); }

order_dir:
	/* empty */ { $$ =  1; }
	| ASC  { $$ =  1; }
	| DESC { $$ =  0; }


limit_clause:
	/* empty */ { Lex->select_limit=Lex->offset_limit=0L; }
	| LIMIT ULONG_NUM
	  { Lex->select_limit= $2; Lex->offset_limit=0L; }
	| LIMIT ULONG_NUM ',' ULONG_NUM
	  { Lex->select_limit= $4; Lex->offset_limit=$2; }

ULONG_NUM:
	NUM { $$=(ulong) atoi($1); }
	| REAL_NUM { $$= (ulong) atof($1); }

procedure_clause:
	/* empty */
	| PROCEDURE IDENT			/* Procedure name */
	  {
	    add_proc_to_list(new Item_field(NULL,$2));
	  }
	  '(' procedure_list ')'


procedure_list:
	procedure_list ',' procedure_item
	| procedure_item

procedure_item:
	  remember_name procedure_item2
	  {
	    add_proc_to_list($2);
	    if (!$2->name)
	      $2->set_name($1,(uint) ((char*) Lex->tok_end - $1));
	  }

procedure_item2:
	sum_ident	{ $$=$1; Lex->tok_end++; }
	| expr		{ $$=$1; }

opt_into:
	/* empty */ { Lex->exchange = 0; }
	| INTO OUTFILE TEXT 
	  {
	    Lex->exchange= new sql_exchange($3);
	  }
	  opt_field_term opt_line_term

/*
** Drop : delete tables or index
*/

drop:
	DROP TABLE_SYMBOL table_list
	{
	  Lex->sql_command = DROP_TABLE;
	}
	| DROP INDEX SIDENT {}
	  { Lex->sql_command = DROP_INDEX; }

/*
** Insert : add new data to table
*/

insert:
	INSERT INTO SIDENT
	{
	  add_table_to_list($3,NULL);
	  current_thd->field_list.empty();
	}
	opt_field_spec insert_values

insert_values:
	VALUES '(' values ')'
	{ Lex->sql_command = INSERT; }
	| SELECT_SYMBOL
	  {
	    LEX *lex=Lex;
	    lex->where=lex->having=0;
	    lex->select_limit=lex->offset_limit=0L;
	    lex->select_options=0;
	    lex->sql_command = INSERT_SELECT;
	  }
	  select_options select_item_list select_from

opt_field_spec:
	/* empty */	  { }
	| '(' fields ')'  { }

fields:
	fields ',' insert_ident	{ current_thd->field_list.push_back($3); }
	| insert_ident		{ current_thd->field_list.push_back($1); }


values:
	values ','  expr	{ add_value_to_list($3); }
	| expr			{ add_value_to_list($1); }


/* Update rows in a table */

update:
	UPDATE_SYMBOL SIDENT SET update_list where_clause
	{
	   Lex->sql_command = UPDATE_SYMBOL;
	   add_table_to_list($2,NULL);
	}

update_list:
	 update_list ',' simple_ident EQ expr
	  { add_item_to_list($3); add_value_to_list($5); }
	| simple_ident EQ expr
	  { add_item_to_list($1); add_value_to_list($3); }


/* Delete rows from a table */

delete:
	DELETE FROM SIDENT where_clause
	{ Lex->sql_command = DELETE; add_table_to_list($3,NULL); }


/* Show things */

show:	SHOW { Lex->wild=0;} show_param

show_param:
	DATABASES wild
	  { Lex->sql_command= DATABASES; }
	| TABLES opt_db wild
	  { Lex->sql_command= TABLES; }
	| COLUMNS FROM IDENT opt_db wild
	  {
	    Lex->sql_command= COLUMNS;
	    add_table_to_list($3,NULL);
	  }
	| KEYS FROM IDENT opt_db
	  {
	    Lex->sql_command= KEYS;
	    add_table_to_list($3,NULL);
	  }
	| INDEX FROM IDENT opt_db
	  {
	    Lex->sql_command= KEYS;
	    add_table_to_list($3,NULL);
	  }

opt_db:
	/*NULL */    { Lex->db = current_thd->db; }
	| FROM SIDENT { Lex->db = $2; }

wild:
	/* empty */
	| LIKE text_string { Lex->wild= $2; }

/* A Oracle compatible synonym for show */
describe:
	describe_command SIDENT
	{
	  Lex->wild=0;
	  Lex->sql_command=COLUMNS;
	  Lex->db=current_thd->db;
	  add_table_to_list($2,NULL);
	}
	opt_describe_column

describe_command:
	DESC
	| DESCRIBE

opt_describe_column:
	/* empty */	{}
	| text_string	{ Lex->wild= $1; }
	| IDENT		{ Lex->wild= &String($1); }

/* import, export of files */

load:	LOAD DATA_SYMBOL INFILE TEXT 
	{
	  Lex->sql_command=LOAD;
	  Lex->exchange= new sql_exchange($4);
	  Lex->duplicates=DUP_ERROR;
	  current_thd->field_list.empty();
	}
	opt_duplicate INTO TABLE_SYMBOL IDENT opt_field_term opt_line_term opt_field_spec
	{
	  add_table_to_list($9,NULL);
	}
	  
opt_duplicate:
	/* empty */
	| REPLACE { Lex->duplicates=DUP_REPLACE; }
	| IGNORE  { Lex->duplicates=DUP_IGNORE; }

opt_field_term:
	/* empty */
	| COLUMNS field_term_list

field_term_list:
	field_term_list field_term
	| field_term

field_term:
	TERMINATED BY text_string { Lex->exchange->field_term= $3;}
	| OPTIONALLY ENCLOSED BY text_string
	  { Lex->exchange->enclosed= $4; Lex->exchange->opt_enclosed=1;}
	| ENCLOSED BY text_string { Lex->exchange->enclosed= $3;}
	| ESCAPED BY text_string  { Lex->exchange->escaped= $3;}

opt_line_term:
	/* empty */
	| LINES TERMINATED BY text_string { Lex->exchange->line_term= $4;}

/* Common definitions */

text_literal:
	TEXT { $$ =  new Item_string((char*) $1,Lex->yytoklen); }

text_string:
	TEXT { $$=new String($1,Lex->yytoklen); }

literal:
	text_literal	{ $$ =	$1; }
	| NUM		{ $$ =	new Item_int($1); }
	| REAL_NUM	{ $$ =	new Item_real($1); }
	| NULL_SYMBOL	{ $$ =	new Item_null(); }

cond_literal:
	literal		{ $$ = $1; }
	| simple_ident	{ $$ = $1; }


/**********************************************************************
** Createing different items.
**********************************************************************/

sum_ident:
	AVG_SUM '(' expr ')'
	  { $$=new Item_sum_avg($3); }
	| SUM_SUM '(' expr ')'
	  { $$=new Item_sum_sum($3); }
	| COUNT_SUM '(' '*' ')'
	  { $$=new Item_sum_count(new Item_int(0,1)); }
	| COUNT_SUM '(' expr ')'
	  { $$=new Item_sum_count($3); }
	| MIN_SUM '(' expr ')'
	  { $$=new Item_sum_min($3); }
	| MAX_SUM '(' expr ')'
	  { $$=new Item_sum_max($3); }
	| GROUP_UNIQUE_USERS '(' text_literal ',' NUM ',' NUM ',' expr ')'
	  { $$= new Item_sum_unique_users($3,atoi($5),atoi($7),$9); }

insert_ident:
	simple_ident	 { $$=$1; }
	| table_ident	 { $$=$1; }

table_ident:
	SIDENT '.' '*'  { $$ = new Item_field($1,"*"); }

group_ident:
	simple_ident   { $$=$1; }
	| NUM	       { $$ = new Item_int($1); }
	| text_literal { $$=$1; }

order_ident:
	simple_ident { $$=$1; }
	| NUM	     { $$ = new Item_int($1); }
	| text_literal { $$=$1; }

simple_ident:
	SIDENT
	{ $$ = !Lex->create_refs ? (Item*) new Item_field(NULL,$1) : (Item*) new Item_ref(NULL,$1); }
	| SIDENT '.' IDENT
	{ $$ = !Lex->create_refs ? (Item*) new Item_field($1,$3) : (Item*) new Item_ref($1,$3); }

SIDENT:
	IDENT	    { $$=$1;}
	| '.' IDENT { $$=$2;}			/* FOR DELPHI ODBC */
