/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Calculating functions */

#include "mysql_priv.h"
#include <hash.h>

static char *op_names[]= {"unkown","=","<>","<","<=",">=",">","like","not like",
			  "is null", "is not null"}; /* Used by sql_test */

static void print_cond_part(COND *cond);

void
print_where(COND *cond)
{
  if (cond)
  {
    VOID(fputs("\nWHERE: ",DBUG_FILE));
    print_cond_part(cond);
    (void) fputc('\n',DBUG_FILE);
  }
}

static void
print_cond_part(COND *cond)
{
  if (cond->type() == Item::COND_ITEM)
  {
    List_iterator<Item> li(*((Item_cond*) cond)->argument_list());
    uint count=0;
    VOID(fputs("(",DBUG_FILE));
    Item *item;
    while ((item=li++))
    {
      if (count++)
      {
	if (((Item_cond*) cond)->functype() == Item_func::COND_AND_FUNC)
	  (void) fputs(" AND ",DBUG_FILE);	
	else
	  (void) fputs(" OR ",DBUG_FILE);
      }
      print_cond_part(item);
    }
    VOID(fputs(")",DBUG_FILE));
  }
  else
  {
    enum Item_func::Functype functype=  ((Item_func*) cond)->functype();
    Item *left_item=(((Item_func*) cond)->arguments()[0]);
    if (functype == Item_func::ISNULL_FUNC)
    {
      printf("%s IS NULL",left_item->name);
    }
    else if (functype == Item_func::ISNOTNULL_FUNC)
    {
      printf("%s IS NOT NULL",left_item->name);
    }
    else if (functype != Item_func::UNKNOWN_FUNC)
      fprintf(DBUG_FILE,"%s %s %s",left_item->full_name(),
	      op_names[(uint) functype],
	      ((Item_func*) cond)->arguments()[1]->full_name());
  }
}


	/* This is for debugging purposes */

extern HASH open_cache;
extern TABLE *unused_tables;

void print_cached_tables(void)
{
  uint index,count,unused;
  TABLE *start_link,*link;

  for (index=unused=0 ; index < open_cache.records ; index++)
  {
    TABLE *entry=(TABLE*) hash_element(&open_cache,index);
    printf("DB: %-10s  Table: %-32s  In_use: %d  Version: %ld\n",
	   entry->key,entry->table_name,entry->in_use,entry->version);
    if (!entry->in_use)
      unused++;
  }
  count=0;
  if ((start_link=link=unused_tables))
  {
    do
    {
      if (link != link->next->prev || link != link->prev->next)
      {
	printf("unused_links isn't linked properly\n");
	return;
      }
    } while (count++ < open_cache.records && (link=link->next) != start_link);
    if (link != start_link)
    {
      printf("Unused_links aren't connected\n");
    }
  }
  if (count != unused)
    printf("Unused_links (%d) dosen't match open_cache: %d\n", count,unused);
  puts("");
  return;
}
