/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* classes to use when handling where clause */


typedef struct st_select_quick_region { /* save a key-region */
  uint min_flag,max_flag;
  STR_OR_DOUBLE min_arg,max_arg;
} SQL_SELECT_QUICK_REGION;


typedef struct _st_select_quick {
  FIELD		*field;			/* Field used by quick-select */
  int		index;			/* Quick-index (for quick_field) */
  int		next;			/* If in active quick */
  ulong		records;
  SELECT_QUICK_REGION *region,*pos,*end;
} SQL_SELECT_QUICK;


typedef struct st_select {
  SQL_SELECT_QUICK *quick;		// If quick-select used
  COND		   *cond;		// where condition
  TABLE *table;
  IO_CACHE file;				// Position till valda poster
  ulong records;			// Records in use if read from file
  ulong quick_keys;			// Possible quick keys
  ulong needed_reg;			/* Possible quick keys after prev
					   tables are read */
} SQL_SELECT;
