/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* YACC and LEX Definitions */

// The following hack is neaded because mysql_yacc.cc does not define
// YYSTYPE before including this file

#ifdef MYSQL_YACC
#define LEX_YYSTYPE void *
#else
#include "y.tab.h"
#define LEX_YYSTYPE YYSTYPE *
#endif

typedef List<Item> List_item;

typedef struct st_lex {
  uint	 yylineno,yytoklen;			/* Simulate lex */
  LEX_YYSTYPE yylval;
  uchar *yytext;
  uchar *ptr,*tok_start,*tok_end,*end_of_query;
  ulong  select_limit,offset_limit;
  bool	 create_refs,drop_primary;
  uint	 sql_command,next_state,type,select_options;
  char	 *length,*db,*dec,*change;
  String *wild;
  sql_exchange *exchange;
  List<List_item> expr_list;
  List<key_part_spec> col_list;
  List<Alter_drop>    drop_list;
  List<Alter_column>  alter_list;
  Item *where,*having;
  bool unique_flag;
  enum enum_duplicates duplicates;
  uchar dummyBuf[2];
} LEX;

void lex_init(void);
void lex_free(void);
LEX *lex_start(uchar *buf,uint length);
void lex_end(LEX *lex);

LEX *_current_lex(void) __attribute__ ((const));
#define current_lex _current_lex()
