/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Classes in mysql */

#pragma interface

enum enum_duplicates { DUP_ERROR, DUP_REPLACE, DUP_IGNORE };

class MYSQL_LOG
{
  FILE *file;
public:
  MYSQL_LOG() :file(0) {}
  void open(const string log_name);
  void write(enum enum_server_command command,const string format,...);
  void flush();
  void close();
};

/* Order clause list element */

typedef struct st_order {
  struct st_order *next;
  Item	 **item;			/* Point at item in select fields */
  bool	 asc;				/* true if ascending */
  bool	 free_me;			/* true if item isn't shared  */
} ORDER;


class key_part_spec :public Sql_alloc {
public:
  char *field_name;
  uint length;
  key_part_spec(char *name) :field_name(name), length(0) {}
  key_part_spec(char *name,uint len) :field_name(name), length(len) {}
};


class Alter_drop :public Sql_alloc {
public:
  enum drop_type {KEY, COLUMN };
  char *name;
  enum drop_type type;
  Alter_drop(enum drop_type par_type,char *par_name)
    :name(par_name), type(par_type) {}
};


class Alter_column :public Sql_alloc {
public:
  char *name;
  Item *def;
  Alter_column(char *par_name,Item *literal)
    :name(par_name), def(literal) {}
};


class Key :public Sql_alloc {
public:
  enum Keytype { PRIMARY, UNIQUE, MULTIPLE };
  enum Keytype type;
  List<key_part_spec> columns;
  char *Name;

  Key(enum Keytype type_par,char *name,List<key_part_spec> &cols)
    :type(type_par), Name(name), columns(cols) {}
  ~Key() {}
  char *name() { return Name; }
};


typedef struct st_copy_field {
  char *from,*to;
  uchar *from_bytepos,*to_bytepos;
  uint length;
  uchar from_bit,to_bit;
} COPY_FIELD;


/* Table cache entry struct */

typedef struct st_table {
  FORM		form;
  FIELD		*field,*field_end;
  char		*key,*table_name;		/* Used by key_cache */
  uint		key_length;			/* Length of key above */
  uint		tablenr,used_fields;
  ulong		version;
  bool		distinct,tmp_table;
  THD		*in_use;			/* Which thread uses this */
  uchar		*null_flags;
  IO_CACHE	*io_cache;			/* If sorted */
  ORDER		*group;
  struct st_table *next,*prev;
} TABLE;


typedef struct tlist_s {
  struct	tlist_s *next;
  char		*name,*real_name;
  TABLE		*table;
} tname_t;

typedef struct st_mysql_lock
{
  TABLE **table;
  uint table_count,lock_count;
  THR_LOCK_DATA **locks;
} MYSQL_LOCK;


	/* every connection is handle by a thread */
class THD :public ilink {
public:
  NET net;
  char	  *host,*user,*db,*ip;
  struct  sockaddr_in local,remote;
  uint	  client_capabilities,max_packet_length;
  uint	  master_access,db_access;
  TABLE *open_tables;
  MYSQL_LOCK *lock;
  sigset_t signals,block_signals;
  MEM_ROOT alloc;
  enum enum_server_command command;
  char	   *query;

  uint	current_tablenr,select_distinct,tmp_table,cond_count;
  ulong thread_id,query_id,version,select_limit,offset_limit,cuted_fields;
  List<Item> item_list,field_list,value_list;
  List<Key>  key_list;
  List<create_field> create_list;
  SQL_LIST   order_list,table_list,group_list,proc_list;
  FIELD	     *dupp_field;
  char packet[PKT_LEN];				/* Room for 1 record */
  bool set_query_id,locked,count_cuted_fields,some_tables_deleted,big_temporaries;
  struct rand_struct rand;

  THD()
  {
    host=user=db=query=ip=0;
    locked=count_cuted_fields=some_tables_deleted=big_temporaries=0;
    command=SLEEP;
    set_query_id=1;
    open_tables=0;
    lock=0;
    cuted_fields=0L;
  }
  ~THD() { safeFree(host); safeFree(user); safeFree(db); safeFree(ip); }
};


class sql_exchange :public Sql_alloc
{
public:
  char *file_name;
  String *field_term,*enclosed,*line_term,*escaped;
  bool opt_enclosed;
  sql_exchange(char *name);
  ~sql_exchange() {}
};

/*
** This is used to get result from a select
*/

class select_result :public Sql_alloc {
protected:
  THD *thd;
public:
  select_result();
  virtual ~select_result() {};
  virtual int prepare(List<Item> &list) { return 0; }
  virtual void send_fields(List<Item> &list,uint flag)=0;
  virtual int send_data(List<Item> &items)=0;
  virtual void send_error(char *err)=0;
  virtual void send_eof()=0;
};


class select_send :public select_result {
public:
  select_send() {}
  void send_fields(List<Item> &list,uint flag);
  int send_data(List<Item> &items);
  void send_error(char *err);
  void send_eof();
};


class select_export :public select_result {
  sql_exchange *exchange;
  File file;
  IO_CACHE cache;
  ulong row_count;
  uint field_term_length;
  int field_sep_char,escape_char,line_sep_char;
  bool fixed_row_size;
public:
  select_export(sql_exchange *ex) :exchange(ex),file(-1),row_count(0L) {}
  ~select_export();
  int prepare(List<Item> &list);
  void send_fields(List<Item> &list,uint flag) { }
  int send_data(List<Item> &items);
  void send_error(char *err);
  void send_eof();
};


class select_insert :public select_result {
  TABLE *table;
  List<Item> *fields;
  uint save_time_stamp;
  ulong records,duplicates;
public:
  select_insert(TABLE *table_par,List<Item> *fields_par)
    :table(table_par),fields(fields_par),records(0),duplicates(0),
    save_time_stamp(table_par->form.time_stamp)
    {}
  ~select_insert();
  int prepare(List<Item> &list);
  void send_fields(List<Item> &list,uint flag) {}
  int send_data(List<Item> &items);
  void send_error(char *err);
  void send_eof();
};
