/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/*****************************************************************************
**
** This file implements classes defined in sql_class.h
** Especially the classes to handle a result from a select
**
*****************************************************************************/

#pragma implementation				// gcc: implement sql_class.h

#include "mysql_priv.h"

/*****************************************************************************
** Instansiate templates
*****************************************************************************/

#ifdef __GNUC__
/* Used templates */
template class List<Key>;
template class List_iterator<Key>;
template class List<key_part_spec>;
template class List_iterator<key_part_spec>;
template class List<Alter_drop>;
template class List_iterator<Alter_drop>;
template class List<Alter_column>;
template class List_iterator<Alter_column>;
#endif

/*****************************************************************************
** Functions to provide a interface to select results
*****************************************************************************/

select_result::select_result()
{
  thd=current_thd;
}

static String default_line_term("\n"),default_escaped("\\"),
	      default_field_term("\t");

sql_exchange::sql_exchange(char *name) :file_name(name),opt_enclosed(0)
{
  field_term= &default_field_term;
  enclosed=   &empty_string;
  line_term=  &default_line_term;
  escaped=    &default_escaped;
}

void select_send::send_fields(List<Item> &list,uint flag)
{
  ::send_fields(thd,list,flag);
}


/* Send data to client. Returns 0 if ok */

int select_send::send_data(List<Item> &items)
{
  byte *pos;
  List_iterator<Item> li(items);
  DBUG_ENTER("send_data");

  if (thd->offset_limit)
  {						// using limit offset,count
    thd->offset_limit--;
    DBUG_RETURN(0);
  }
  pos=thd->packet;
  Item *item;
  while ((item=li++))
    pos=item->send(pos);
  DBUG_RETURN(net_write(&thd->net,thd->packet,(uint) (pos- thd->packet)));
}

void select_send::send_error(char *err)
{
  ::send_error(&thd->net,err);
}

void select_send::send_eof()
{
  ::send_eof(&thd->net);
}


/***************************************************************************
** Export of select to textfile
***************************************************************************/


select_export::~select_export()
{
  if (file >= 0)
  {					// This only happens in case of error
    (void) end_io_cache(&cache);
    (void) my_close(file,MYF(0));
    file= -1;
  }
}

int
select_export::prepare(List<Item> &list)
{
  char path[FN_REFLEN];
  if (!access(exchange->file_name,F_OK))
  {
    my_error(ER_FILE_EXISTS_ERROR,MYF(0),exchange->file_name);
    return 1;
  }
  if ((file=my_create(fn_format(path,exchange->file_name,
				current_thd->db ? current_thd->db : "",
				"",4),
		      0666,O_WRONLY,MYF(MY_WME))) < 0)
  {
    return 1;
  }
  if (init_io_cache(&cache,file,0L,WRITE_CACHE,0L,1,MYF(MY_WME)))
  {
    my_close(file,MYF(0));
    file= -1;
    return 1;
  }
  field_term_length=exchange->field_term->length();
  if (!exchange->line_term->length())
    exchange->line_term=exchange->field_term;	// Use this if it exists
  field_sep_char= (exchange->enclosed->length() ? (*exchange->enclosed)[0] :
		   field_term_length ? (*exchange->field_term)[0] : INT_MAX);
  escape_char=	(exchange->escaped->length() ? (*exchange->escaped)[0] : -1);
  line_sep_char= (exchange->line_term->length() ?
		  (*exchange->line_term)[0] : INT_MAX);
  if (!field_term_length)
    exchange->opt_enclosed=0;
  fixed_row_size= (field_term_length == 0 && !exchange->enclosed->length());
  return 0;
}


int select_export::send_data(List<Item> &items)
{
  byte *pos;
  List_iterator<Item> li(items);
  DBUG_ENTER("send_data");
  char buff[MAX_FIELD_WIDTH];
  String tmp(buff,sizeof(buff)),*res;
  tmp.length(0);

  if (thd->offset_limit)
  {						// using limit offset,count
    thd->offset_limit--;
    DBUG_RETURN(0);
  }
  row_count++;
  pos=thd->packet;
  Item *item;
  char *buff_ptr=buff;
  uint used_length=0;

  while ((item=li++))
  {
    enum Item::Item_result result_type=item->result_type();
    res=item->str(&tmp);
    if (res && (!exchange->opt_enclosed || result_type == Item::STRING_RESULT))
    {
      memcpy(buff_ptr,exchange->enclosed->ptr(),exchange->enclosed->length());
      buff_ptr+=exchange->enclosed->length();
    }
    if (buff_ptr != buff && my_b_write(&cache,buff,(uint) (buff_ptr-buff)))
      goto err;
    if (!res)
    {						// NULL
      if (!fixed_row_size)
      {
	if (escape_char != -1)			// Use \N syntax
	{
	  buff[0]=escape_char;
	  buff[1]='N';
	  if (my_b_write(&cache,buff,2))
	    goto err;
	}
	else if (my_b_write(&cache,"NULL",4))
	  goto err;
      }
      else
      {
	used_length=0;				// Fill with space
      }
    }
    else
    {
      used_length=res->length();
      if (result_type == Item::STRING_RESULT && escape_char != -1)
      {
	char *pos,*start,*end;

	for (start=pos=(char*) res->ptr(),end=pos+used_length ;
	     pos != end ;
	     pos++)
	{
	  if ((int) *pos == escape_char || (int) *pos == field_sep_char ||
	      (int) *pos == line_sep_char || !*pos)
	  {
	    char tmp_buff[2];
	    tmp_buff[0]= escape_char;
	    tmp_buff[1]= *pos ? *pos : '0';
	    if (my_b_write(&cache,start,(uint) (pos-start)) ||
		my_b_write(&cache,tmp_buff,2))
	      goto err;
	    start=pos+1;
	  }
	}
	if (my_b_write(&cache,start,(uint) (pos-start)))
	  goto err;
      }
      else if (my_b_write(&cache,res->ptr(),used_length))
	goto err;
    }
    if (fixed_row_size)
    {						// Fixed length, fill with space
      if (item->max_length > used_length)
      {						// This is actually an error
	tmp.fill(item->max_length-used_length,' ');
	if (my_b_write(&cache,tmp.ptr(),tmp.length()))
	  goto err;
      }
    }
    buff_ptr=buff;				// Place separators here
    if (res && (!exchange->opt_enclosed || result_type == Item::STRING_RESULT))
    {
      memcpy(buff_ptr,exchange->enclosed->ptr(),exchange->enclosed->length());
      buff_ptr+=exchange->enclosed->length();
    }
    memcpy(buff_ptr,exchange->field_term->ptr(),field_term_length);
    buff_ptr+=field_term_length;
  }
  if (exchange->line_term->length())
  {
    buff_ptr-=field_term_length;		// Remove last separator
    memcpy(buff_ptr,exchange->line_term->ptr(),exchange->line_term->length());
    buff_ptr+=exchange->line_term->length();
    if (buff_ptr != buff && my_b_write(&cache,buff,(uint) (buff_ptr-buff)))
      goto err;
  }
  DBUG_RETURN(0);
err:
  DBUG_RETURN(1);
}


void select_export::send_error(char *err)
{
    ::send_error(&thd->net,err);
    (void) end_io_cache(&cache);
    (void) my_close(file,MYF(0));
    file= -1;
}


void select_export::send_eof()
{
  if (end_io_cache(&cache) | my_close(file,MYF(MY_WME)))
    ::send_error(&thd->net,NullS);
  else
    ::send_ok(&thd->net,row_count);
  file= -1;
}
