/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Funktioner som har med selekteringen att g|ra */

#include "mysql_priv.h"
#include "select_q.h"
#include <m_ctype.h>

	/* functions defined in this file */

static int get_field(SELECT *select,
		     enum select_field_type field_type,
		     enum select_cmp_type cmp_type,
		     union un_select_type *type,
		     char * *str_pek,double *nr_pek);
static int gq_cmp(SELECT_QUICK_REGION *quick,FIELD *field);
static void select_fix_one_jump(SELECT_ROW *row);


	/* set upp jump-table and reg_used for select */
	/* Don't check quick_select if read_index == ~0 */

int fix_select(SELECT *select, uint read_index)
{
  uint i;
  reg1 SELECT_ROW *row;
  uint old_reg_used;
  DBUG_ENTER("fix_select");

  if (select)
  {
    if (!(specialflag & (SPECIAL_NO_NEW_FUNC | SPECIAL_NO_UNSAFE_OPT)) &&
	select->maxreg > 1)
      substitute_keys(select);			/* Change keys to ref_fields */
    if (read_index != (uint) ~0)
    {
      if (test_quick_select(select,read_index ? (1L << (read_index-1)) : ~0L)
	  < 0)
      {
	DBUG_RETURN(1);
      }
    }
    old_reg_used=select->head->form.reginfo.reg_used;
    select->head->form.reginfo.reg_used&= ~1;	/* head form not neaded */
    for (i=0 ;select->forms[i] != select->head ; i++) ;
    select->reg_used= (1 << i);
    for (row=select->row ; row && row->flag ; row++)
    {
      if (row->reg_used)
      {
	row->reg_used=get_ref_regs(select->forms,row->reg_used);
	select->reg_used|=row->reg_used;
      }
      select_fix_one_jump(row);
    }
    select->head->form.reginfo.reg_used=old_reg_used; /* Restore original */
    DBUG_EXECUTE("info",TEST_select(select););
  }
  DBUG_RETURN(0);
} /* fix_select */


static void select_fix_one_jump(register SELECT_ROW *row)
{
  reg2 uint flag;
  uint level,result;
  SELECT_ROW *start_row;

  start_row=row;

  result= (row->flag & SELECT_FLAG_AND);
  while ((flag=row->flag))
  {
    if (flag & SELECT_FLAG_RIGHT_BRACE && row != start_row)
    {
      start_row->jump=row;
      start_row->jump_found_brace=1;
      return;
    }
loop:
    if (result && !(flag & SELECT_FLAG_AND))
    {						/* OR separates ANDS */
      start_row->jump=row;
      start_row->jump_found_brace=0;
      return;
    }
    if (flag & SELECT_FLAG_LEFT_BRACE)
    {
     level=0;
     while ((flag= (++row)->flag))
     {
       if (flag & SELECT_FLAG_RIGHT_BRACE)
	 if (!level--)
	   goto loop;				/* Continue testing */
       if (flag & SELECT_FLAG_LEFT_BRACE)
	 level++;
     }
     start_row->jump=row;			/* No last ')'; to last row */
     start_row->jump_found_brace=0;
     return;
    }
    row++;
  }
  start_row->jump=row;
  start_row->jump_found_brace=0;		/* To end */
  return;
} /* select_fix_one_jump */


	/* Testar om ett records skall skippas -> 1 om skippas */

int skipp_record(register SELECT *select)
{
  reg2 uint flag;
  reg3 int res;
  int level,optflag,allow_brace,used_reg_skipped;
  char buff[MAX_FIELD_WIDTH],buff2[MAX_FIELD_WIDTH],*f_pos,*d_pos;
  double f_nr,d_nr;
  reg3 SELECT_ROW *row;
  DBUG_ENTER("skipp_record");

  if (!select || my_b_inited(&select->file)) DBUG_RETURN(0);
  row=select->row;
  allow_brace= 1; used_reg_skipped=level=0;
  select->reg_read= select->reg_init_read;
  select->stack[0].result=1;
  select->stack[0].flag=0;

  while ((flag=row->flag))
  {
    if (flag & SELECT_FLAG_RIGHT_BRACE && allow_brace)
    {
      if (select->stack[level].flag == SELECT_FLAG_OR)
      {
	level--;
	select->stack[level].result|=select->stack[level+1].result;
      }
      if (level)
      {						/* if not lonely ')' */
	if (select->stack[level].flag & SELECT_FLAG_AND)
	{
	  level--;
	  select->stack[level].result&=select->stack[level+1].result;
	}
	else
	  select->stack[level].flag=SELECT_FLAG_OR;
      }
    }
    if (flag & SELECT_FLAG_OR && select->stack[level].flag == SELECT_FLAG_OR)
    {
      select->stack[level-1].result|=select->stack[level].result;
      level--;
    }

    DBUG_PRINT("loop",("flag: %d  level:%d  result: %d",flag,level,
		       select->stack[level].result));
    if ((test(flag & SELECT_FLAG_AND)) ==
	select->stack[level].result) /* Must we test select ? */
    {
      allow_brace=1;
      if (flag & SELECT_FLAG_LEFT_BRACE)
      {						/* '(' found */
	select->stack[++level].flag= flag;
	select->stack[level].result= 1;
      }
      if (!(flag & (SELECT_FLAG_NO_FIELDS | SELECT_FLAG_ALWAYS_FALSE |
		    SELECT_FLAG_ALWAYS_TRUE)))
      {						/* Not Empty level */
	if ((~select->reg_read) & row->reg_used)
	{
	  if (select->reg_skipped & row->reg_used)
	  {
	    res=1;
	    used_reg_skipped=1;
	    goto skipp;				/* Select row is true */
	  }
	  select->reg_read|= row->reg_used;
	}
	optflag= flag & SELECT_FLAG_OP;
	f_pos=buff; d_pos=buff2;
	f_nr=d_nr= (double) 0;			/* For easyer debugging */
	if (get_field(select,row->field_type,row->cmp_type,&row->field,
		      &f_pos,&f_nr) ||
	    get_field(select,row->diff_type,row->cmp_type,&row->diff,
		      &d_pos,&d_nr))
	{
	  res=0;				/* Didn't find field */
	  goto skipp;				/* select is FALSE ! */
	}
	DBUG_PRINT("test",("f_pos: '%s'   d_pos: '%s'    f_nr: %g  d_nr: %g",
		   f_pos,d_pos,f_nr,d_nr));
	if (row->cmp_type != SEL_CMP_NUM)
	{					/* Stringcompare */
	  if (flag & SELECT_FLAG_WILD_COMPARE)
	  {
	    res= (wild_compare(f_pos,d_pos) != 0);
	  }
	  else
	  {
	    if (optflag >= 7)
	    {					/* Soundex string */
	      soundex(buff,f_pos,1); f_pos=buff; /* Fix field */
	      if (row->diff_type != SEL_FIELD_CONST_STR)
	      {					/* Fix arg if not fixed */
		soundex(buff2,d_pos,1);
		d_pos=buff2;
	      }
	      optflag-=6;			/* Change to 1 or 2 */
	    }
	    if (row->cmp_type == SEL_CMP_BINARY_STR)
	      res= strcmp(f_pos,d_pos);
	    else
	      res= my_strsortcmp(f_pos,d_pos);
	  }
	}
	else
	{					/* Test numbers */
	  if (f_nr == d_nr) res=0;
	  else if (f_nr > d_nr) res =1;
	  else res= -1;
	}
	if (optflag > 4)
	{					/* > och >= */
	  res= -res; optflag-=2;
	}
	switch (optflag) {
	case 1: res= res == 0; break;
	case 2: res= res != 0; break;
	case 3: res= res <  0; break;
	case 4: res= res <= 0; break;
	default: break;
	}
      }
      else
      {
	res=1;					/* ALWAYS_TRUE OR NO_FIELDS */
	if (flag & SELECT_FLAG_ALWAYS_FALSE)
	  res=0;
      }
skipp:						/* Here when wrong fieldref */
      if (flag & (SELECT_FLAG_AND | SELECT_FLAG_LEFT_BRACE))
	select->stack[level].result&=res;
      else
      {
	select->stack[++level].flag= SELECT_FLAG_OR;
	select->stack[level].result= test(res);
      }
    }
    else
    {						/* When skipping compare */
      allow_brace=row->jump_found_brace;
      row=row->jump;
      continue;
    }
    row++;
  }

  while (level-- > 0)				/* Test last levels */
  {						/* Some ')' is not written */
    if (select->stack[level+1].flag & SELECT_FLAG_AND)
      select->stack[level].result&= select->stack[level+1].result;
    else
      select->stack[level].result|= select->stack[level+1].result;
  }
  DBUG_PRINT("exit",("result: %d",select->stack[0].result));
  if (select->stack[0].result && used_reg_skipped)
    select->used_reg_skipped=1;			/* Mark for sort */
  DBUG_RETURN(select->stack[0].result == 0);	/* 1 if should be skipped */
} /* skipp_record */


	/* Unpack of select-arg */
	/* Returns != 0 if wrong reg used */

static int get_field(SELECT *select, enum select_field_type field_type, enum select_cmp_type cmp_type, SELECT_TYPE *type, string *str_pek, double *nr_pek)
{
  FIELD *field;
  DBUG_ENTER("get_field");

  switch (field_type) {
  case SEL_FIELD_FIELD:
    if (select->forms[type->field.regnr]->form.status & STATUS_NO_RECORD)
      DBUG_RETURN(1);
    field=type->field.regfield;
    if (cmp_type !=  SEL_CMP_NUM)
    {
      VOID(r_unpackf_stripp(field,*str_pek));
      if (cmp_type !=  SEL_CMP_BINARY_STR)
	caseup_str(*str_pek);
    }
    else
      *nr_pek = valfield(field);
    break;
  case SEL_FIELD_CONST_STR:
    *str_pek= type->str;			/* Const string */
    break;
  case SEL_FIELD_CONST_NUM:
    *nr_pek= type->nr;				/* Const num */
    break;
  case SEL_FIELD_FORMULA:
    *nr_pek=0;					// Impossible
    break;
  case SEL_FIELD_NOT_USED:
    DBUG_RETURN(1);				/* Hit skall vi aldrig komma */
  }
  DBUG_RETURN(0);
} /* get_field */


	/* End of select */

void end_select(SELECT *select)
{
  if (select)
  {
    close_cacheed_file(&select->file);
    x_free((gptr) select->quick);		/* if quick-select */
    my_free((gptr) select,MYF(0));
  }
} /* end_select */


	/* get next possibly record using quick-struct */

int get_quick_record(SELECT *select)
{
  uint length;
  FORM *form;
  SELECT_QUICK *quick;
  SELECT_QUICK_REGION *region;
  char buff[MAX_FIELD_WIDTH],*key;
  DBUG_ENTER("get_quick_record");

  form= &select->head->form;
  quick=select->quick;
  region=quick->pos;
  for (;;)
  {
    if (quick->next == 1)
    {
      if (ha_rnext(form,form->record[0],quick->index) == 0 &&
	  gq_cmp(region,quick->field) == 0)
	DBUG_RETURN(0);
      region++;
    }
    if (quick->next && ++quick->pos == quick->end)
      DBUG_RETURN(HA_ERR_END_OF_FILE);		/* Ready */
    quick->next=1;
    if (region->min_flag == NO_MIN_RANGE)	/* Read first */
    {
      int error;
      if ((error=ha_rfirst(form,form->record[0],quick->index)))
	DBUG_RETURN(error);
      if (gq_cmp(region,quick->field) == 0)
	DBUG_RETURN(0);
      quick->next=2;				/* To next range */
      continue;
    }
    key=(char*) &region->min_arg;
    if ((length=packlength(quick->field)) >
	form->key_info[quick->index].key_length)
      length=form->key_info[quick->index].key_length;
    if (f_is_num(quick->field->pack_flag))
    {
      packnrf(region->min_arg.nr,quick->field);
      memcpy(key=buff,quick->field->str,(size_t) length);
    }
    else
    {
      packf(key,quick->field);			/* Fill upp key */
      key=quick->field->str;
    }
    if (ha_rkey(form,form->record[0],quick->index,key,
		length,(region->min_flag == IDENTICAL_KEY ?
			HA_READ_KEY_OR_NEXT : HA_READ_AFTER_KEY)))
      continue;
    if (gq_cmp(region++,quick->field) == 0)
      DBUG_RETURN(0);
    quick->next=2;				/* To next range */
  }
} /* get_quick_record */


	/* compare if found field is over max-value */
	/* Returns 0 if field <= quick->max */

static int gq_cmp(SELECT_QUICK_REGION *quick, FIELD *field)
{
  int cmp;
  char buff[MAX_FIELD_WIDTH],*a_pos,*b_pos;
  double d_cmp;

  if (quick->max_flag == NO_MAX_RANGE)
    return (0);					/* field can't be to large */
  if (f_is_num(field->pack_flag))
  {
    if ((d_cmp= valfield(field)-quick->max_arg.nr) < 0.0 ||
	(d_cmp == 0.0 && quick->max_flag == IDENTICAL_KEY))
      return 0;
    return 1;
  }
  r_unpackf(field,buff);			// Change to r_unpack_stripp
  a_pos= &quick->max_arg.str.str[0]; b_pos= buff;
  if (f_is_binary(field->pack_flag))
  {
    while ((cmp= (int) (uchar) *a_pos - (int) (uchar) *b_pos) == 0)
    {
      if (*a_pos++ == 0)
	return test(quick->max_flag);
      b_pos++;
    }
  }
  else
  {
    while ((cmp= (int) my_sort_order[(uchar) *a_pos] -
	    (int) my_sort_order[(uchar) *b_pos]) == 0)
    {
      if (*a_pos++ == 0)
	return test(quick->max_flag);
      b_pos++;
    }
  }
  if (*a_pos == 0 || *b_pos == 0)
    return test(quick->max_flag);
#ifndef DBUG_OFF
  if (cmp < 0)
    DBUG_PRINT("last-key",("record: '%s'  range: '%s'",buff,quick->max_arg.str.str));
#endif
  return cmp < 0;
} /* gq_cmp */
