/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Structs used by quick-select */

#define IDENTICAL_KEY		0	/* Key may be == range */
#define NO_MIN_RANGE		1	/* Key dosn't have lower range */
#define NO_MAX_RANGE		1	/* Key dosn't have upper range */
#define NEAR_KEY		2	/* Key may not be == range */
#define IMPOSSIBLE_RANGE	4	/* Range is impossible */
#define ERROR_RANGE		8	/* Some part of range is wrong */

#define SELECT_FLAG_OP		 15
#define SELECT_FLAG_LEFT_BRACE	 32
#define SELECT_FLAG_RIGHT_BRACE  64
#define SELECT_FLAG_AND		 128
#define SELECT_FLAG_NO_FIELDS	 256
#define SELECT_FLAG_WILD_COMPARE 512
#define SELECT_FLAG_OR		 1024
#define SELECT_FLAG_ALWAYS_TRUE  2048
#define SELECT_FLAG_ALWAYS_FALSE 4096


typedef struct st_qsel_arg {		/* save a key-region */
  struct st_qsel_arg *next,*prev;
  uint min_flag,max_flag;
  STR_OR_DOUBLE min_arg,max_arg;
} S_ARG;

typedef struct st_qsel_param {		/* used when testing for quick_sel */
  S_ARG *use,*free;
  S_ARG **pos_level;
  S_ARG root;					/* Empty root block */
  uint type;					/* type of field */
  uint keylength,baseflag;
  ulong pre_reg_read;
} PARAM;
