/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include "unireg.h"
#include "version.h"
#include <signal.h>
#include <thr_lock.h>

extern "C" {					/* Bug in libc 2.0 */
#ifdef MSDOS
#include <winsock.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef HAVE_SYNCH_H
#include <synch.h>
#endif
#endif
}

#include "mysql_com.h"

gptr sql_alloc(unsigned size);
gptr sql_calloc(unsigned size);
char *sql_strdup(const char *str);
gptr sql_memdup(const gptr ptr,unsigned size);
void sql_element_free(void *ptr);

#define safeFree(x)  { if(x){ my_free((gptr) x,MYF(0)); x = NULL; } }

/***************************************************************************
  Configuration parameters
****************************************************************************/

#define CONNECT_PRIOR 9
#define WAIT_PRIOR 8
#define QUERY_PRIOR 6

struct st_table;
class THD;

#define SELECT_ACL	1
#define INSERT_ACL	2
#define UPDATE_ACL	4
#define DELETE_ACL	8
#define CREATE_ACL	16
#define DROP_ACL	32
#define RELOAD_ACL	64
#define SHUTDOWN_ACL	128
#define PROCESS_ACL	256
#define FILE_ACL	512
#define DB_ACL		(UPDATE_ACL | SELECT_ACL | INSERT_ACL | \
			 DELETE_ACL | CREATE_ACL | DROP_ACL)
#define NO_ACCESS	16384

#define TEST_PRINT_CACHED_TABLES 1
#define TEST_NO_KEY_GROUP	 2

#define SELECT_DISTINCT		1
#define SELECT_STRAIGHT_JOIN	2

/* Struct to handle simple linked lists */

typedef struct st_sql_list {
  uint elements;
  byte *first;
  byte **next;
} SQL_LIST;


uint nr_of_decimals(char *str);			/* Neaded by sql_string.h */

#include "sql_string.h"
#include "sql_list.h"
#include "sql_map.h"
#include "field.h"				/* Field definitions */
#include "item.h"
#include "sql_class.h"

void mysql_createDB(THD *thd, char *db);
int mysql_rm_table(THD *thd, tname_t *tables);
int mysql_init_db(char *DB);
void mysql_parse(THD *thd,char *inBuf,uint length);
void mysql_execute_command(void);
bool do_command(THD *thd);
void reload_acl_and_cache(void);
void mysql_rm_db(THD *thd,char *db);
void table_cache_init(void);
void table_cache_free(void);
uint cached_tables(void);
void close_connection(NET *net,char *error=0,bool lock=1);

/* net_pkg.c */
void send_error(NET *net,char *err);
void net_printf(NET *net,const string format, ...);
void send_ok(NET *net,ulong affected_rows=0L,ulong id=0L,char *info=0);
void send_eof(NET *net);
byte *net_store_length(byte *packet,ulong length);
byte *net_store_data(byte *to,const byte *from);
byte *net_store_data(byte *to,const byte *from,uint length);

int mysql_select(THD *thd,tname_t *tables,List<Item> &list,COND *conds,
		 ORDER *order, ORDER *group,Item *having,ORDER *proc_param,
		 uint select_type,select_result *result);
int mysql_create_table(THD *thd,const char *table_name,
		       List<create_field> &fields, List<Key> &keys,
		       bool tmp_table);
int mysql_alter_table(THD *thd,const char *table_name,
		      List<create_field> &fields,
		      List<Key> &keys,List<Alter_drop> &drop_list,
		      List<Alter_column> &alter_list,
		      bool drop_primary,enum enum_duplicates handle_duplicates);
int mysql_create_index(THD *thd,const char *table_name,List<key_part_spec> &key,
		       bool unique);
int mysql_update(THD *thd,const char *table_name,List<Item> &fields,
		 List<Item> &values,COND *conds);
int mysql_insert(THD *thd,tname_t *table,List<Item> &fields,
		 List<Item> &values);
int mysql_delete(THD *thd,const char *table,COND *conds);
TABLE *open_ltable(THD *thd,const char *table,tname_t *table_list);
TABLE *open_table(THD *thd,const char *db,const char *table,const char *alias);
int reopen_table(THD *thd,TABLE *table);
FIELD *find_field_in_tables(THD *thd,Item_field *item,tname_t *tables,
			      const string where);

/* sql_list.c */
int mysqld_show_dbs(THD *thd,const char *wild);
int mysqld_show_tables(THD *thd,const char *db,const char *wild);
int mysqld_show_fields(THD *thd,const char *db,const char *table,
		       const char *wild);
int mysqld_show_keys(THD *thd,const char *db,const char *table);
void mysqld_list_fields(THD *thd,const char *table,const char *wild);
void mysqld_list_processes(THD *thd);

/* sql_acl.c */
int  acl_init(void);
void acl_reload(void);
void acl_free(void);
uint acl_get(const char *host, const char *ip, const char *user,
	     const char *db);
uint acl_getroot(const char *host, const char *ip, const char *user,
		 const char *password,const char *scramble);

/* sql_base.cc */
void set_item_name(Item *item,char *pos,uint length);
int add_field_to_list(char *field_name, enum enum_field_types type,
		      char *length, char *decimal,
		      uint type_modifier,int notNull,int unireg_type,
		      int keyinfo,Item *item,char *change);
void add_item_to_list(Item *value);
void add_value_to_list(Item *value);
void add_to_list(SQL_LIST &list,Item *group,bool asc=0);
void add_order_to_list(Item *ident,bool asc);
void add_group_to_list(Item *group,bool asc);
tname_t *add_table_to_list(char *name,char *alias);
void add_proc_to_list(Item *item);

ulong get_quick_record_count(SELECT *select,uint table,uint keys);
SELECT *make_unireg_select(TABLE **table,uint table_count,uint head,
			   uint const_tables, COND *conds, int *error);
Item ** find_item_in_list(Item *item,List<Item> &items,string where);
int setup_fields(THD *thd,tname_t *tables,List<Item> &item,bool set_query_id);
int setup_conds(THD *thd,tname_t *tables,COND *conds);
int open_tables(THD *thd,tname_t *tables);
int open_and_lock_tables(THD *thd,tname_t *tables);
int lock_tables(THD *thd,tname_t *tables);
void send_fields(THD *thd,List<Item> &item,uint send_field_count);
void free_io_cache(TABLE *entry);
THD *_current_thd(void) __attribute__ ((const));
#define current_thd _current_thd()
void intern_close_table(TABLE *entry);
void close_thread_tables(THD *thd);
void remove_db_from_cache(const string db);
void remove_table_from_cache(const char *db,const char *table);
void close_cached_tables(void);
void mark_as_null(FIELD *field);
void mark_as_not_null(FIELD *field);
void copy_field_from_tmp_record(FIELD *field,int offset);
int fill_record(List<Item> &fields,List<Item> &values);
int fill_record(TABLE *table,List<Item> &values);
bool test_if_null_offset(FIELD *field,int offset);
bool test_safe_null(FIELD *field);
void store_string(String &str,FIELD *field);

/* sql_calc.cc */
bool eval_const_cond(COND *cond);
bool const_item(Item *item);

/* sql_load.cc */
int mysql_load(THD *thd,sql_exchange *ex, tname_t *table_list,
	       List<Item> &fields, enum enum_duplicates handle_duplicates,
	       ulong rows_to_skipp);
/* sql_test.cc */
void print_where(COND *cond);
#ifndef DBUG_OFF
void print_cached_tables(void);
#endif
/* key.cc */
uint find_keyfield(FORM *form,uint keynr);
uint find_field(FORM *form,uint start,uint length);
int find_ref_key(FORM *form,FIELD *field,pbool find_keystart,uint *key_length);
void key_copy(byte *key,FORM *form,uint index,uint key_length);
void key_restore(FORM *form,byte *key,uint index,uint key_length);
int key_cmp(FORM *form,byte *key,uint index,uint key_length);
uint key_unpack(char *to,FORM *form,uint index,uint key_length);
void init_errmessage(void);

extern char mysql_data_home[FN_REFLEN],*mysql_unix_port;
extern ulong reload_version;
extern uint test_flags,thread_count,select_errors,mysql_port,table_cache_size;
extern pthread_t signal_thread;
extern time_t start_time;
extern char *command_name[];
extern I_List<THD> threads;
extern MYSQL_LOG mysql_log;
extern pthread_key_t THR_MALLOC;
extern pthread_mutex_t LOCK_mysql_createDB,LOCK_Acl,LOCK_open,
       LOCK_thread_count;
extern bool opt_endinfo;

extern char f_fyllchar;
extern DATE_FORMAT dayord;
extern double log_10[32];			/* 10 potences */
extern uint keybuff_size,sortbuff_size,current_pid;
extern ulong specialflag;
extern bool volatile abort_loop;
extern char language[LIBLEN],reg_ext[FN_EXTLEN],blob_newline;
extern char **errmesg;				/* Error messages */
extern byte last_ref[MAX_REFLENGTH];		/* Index ref of keys */
extern String empty_string;

MYSQL_LOCK *mysql_lock_tables(THD *thd,TABLE **table,uint count);
void mysql_unlock_tables(MYSQL_LOCK *sql_lock,bool no_free=0);
void mysql_unlock_some_tables(TABLE **table,uint count);

/* old unireg functions */

void unireg_init(ulong options);
void unireg_end(int signal);
int rea_create_table(string file_name,enum db_type database_type,
		     uint table_options, ulong records, ulong reloc,
		     List<create_field> &create_field,
		     uint key_count,KEY *key_info);
int format_number(uint inputflag,uint max_length,string pos,uint length,
		  string *errpos);
int cre_database(char *name);
int openfrm(char *name,char *formname,uint filestat,uint prgflag,
		FORM *outparam);
int closefrm(FORM *frmfile);
void frm_error(int error,FORM *form,int errortype);
void form_error(int error,char *name,char *formname,char *form_ext,
		    int errortype);
int set_zone(int nr,int min_zone,int max_zone);
ulong convert_period_to_month(ulong period);
ulong convert_month_to_period(ulong month);
long calc_daynr(uint year,uint month,uint day);
void calc_next_date(char *date,int days,uint flag, uint *length);
void get_date_from_daynr(long daynr,uint *year, uint *month,
			 uint *day);
void init_time(void);
long my_gmt_sec(TIME *);
time_t str_to_timestamp(const char *str,uint length);
ulong str_to_date(const char *str,uint length);
ulong str_to_time(const char *str,uint length);
longlong str_to_datetime(const char *str,uint length);
void f_fieldinit(char *pos,uint inputflag,uint length);
double valfield(FIELD *field);
long valfield_l(FIELD *field);
uint r_unpackf_stripp(FIELD *field,char *pos);
void r_unpackf(FIELD *field,char *pos);
void f_packfield(char *to,const char *from,uint inputflag,
		     uint length,TYPELIB *intervall);
void packnrf(double nr,FIELD *field);
uint f_packlength(uint length, uint flag);
uint packlength(const FIELD *field);
void copystrn(char *pos,const char *pos2,uint length);
void conv_blob(FIELD *to,FIELD *from);
int pack_blob(FIELD *field, byte *blob, uint length);
void (*get_field_conv(FIELD *to,FIELD *from))(FIELD *,FIELD *);
void free_blobs(FORM *form);
void free_type(TYPELIB *typelib);
void make_bit_type(char *to,ulonglong nr,TYPELIB *bit_lib,
		       uint length);
ulonglong find_bit_type(const string x,TYPELIB *bit_lib);
int test_if_number(char *str,int *res,bool allow_wildcards);
void change_byte(byte *,uint,char,char);
void unireg_abort(int exit_code);
void end_select(SELECT *select);
int test_quick_select(SELECT *select,ulong keys_to_use);
int fix_select(SELECT *select,uint read_index);
void init_read_record(READ_RECORD *info, FORM *reg_form, int key,
			  IO_CACHE *tempfile, SELECT *select);
void end_read_record(READ_RECORD *info);
int skipp_record(SELECT *select);
void packf(const char *str,FIELD *field);
void substitute_keys(SELECT *select);
ulong get_ref_regs(TABLE **form,ulong reg_used);
void TEST_select(SELECT* select);
void field_name_or_number(string to,FORM *form,uint fieldnr);
ulong filesort(TABLE **form,struct st_sort_field *sortorder,
		   uint s_length,IO_CACHE *outfile,SELECT *select,
		   int no_info,ulong special,ulong max_records);
void f_konv(FIELD *to,FIELD *from);
void store_ptr_in_blob(FIELD *field,const byte *blob,uint length);
byte *get_blob_ptr(FIELD *field);
uint f_unpackfield_stripp(char *to,char *from,uint inputflag,
			      uint length, TYPELIB *intervall);
int get_quick_record(SELECT *select);
int calc_weekday(long daynr);
void find_date(char *pos,uint *vek,uint flag);
TYPELIB *convert_strings_to_array_type(string *typelibs, string *end);
void clean_up(void );
void TEST_filesort(TABLE **form,SORT_FIELD *sortorder,uint s_length,
		       ulong special);
char * *make_char_array(uint fields,uint length,myf my_flag);
void f_unpackfield(char *to,char *from,uint inputflag,uint length,
		       TYPELIB *intervall);
ulong get_form_pos(File file, uchar *head, string formname,
		   string outname, TYPELIB *save_names);
ulong make_new_entry(File file,uchar *fileinfo,TYPELIB *formnames,
			 char *newname);
ulong next_io_size(ulong pos);
int test_field(struct st_test_field *param,char *text);
int create_frm(char *name,uint reclength,uchar *fileinfo,
		   enum db_type database,uint options,
		   ulong records,ulong reloc,uint keys);
int rename_file_ext(const char * from,const char * to,const char * ext);
int fix_frm_ref(const char * name);
