/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* logging of commands */

#include "mysql_priv.h"
#include <stdarg.h>

MYSQL_LOG mysql_log;
static pthread_mutex_t LOCK_log=PTHREAD_MUTEX_INITIALIZER;


void MYSQL_LOG::open(const string log_name)
{
  char log_file_name[FN_REFLEN];
  file=my_fopen(fn_format(log_file_name,log_name,mysql_data_home,".log",4),
		O_APPEND | O_WRONLY,MYF(MY_WME | ME_WAITTANG));
  if (file)
  {
    fprintf(file,"%s started with:\nTcp port: %d  Unix socket: %s\n",
	    my_progname,mysql_port,mysql_unix_port);
    fprintf(file,"Time                Id Command    Argument\n");
    VOID(fflush(file));
  }
  return;
}



void MYSQL_LOG::write(enum enum_server_command command,
		      const string format,...)
{
  va_list args;
  va_start(args,format);
  if (file)
  {
    static char time_buff[20];
    static time_t last_time=0;
    time_t skr;
    THD *thd=current_thd;
    VOID(pthread_mutex_lock(&LOCK_log));

    if ((skr=time((time_t*) 0)) != last_time)
    {
      last_time=skr;
      struct tm tm_tmp;
      struct tm *start_time=localtime_r(&skr,&tm_tmp);
      sprintf(time_buff,"%02d%02d%02d %2d:%02d:%02d",
	      start_time->tm_year,
	      start_time->tm_mon+1,
	      start_time->tm_mday,
	      start_time->tm_hour,
	      start_time->tm_min,
	      start_time->tm_sec);
    }
    else
      time_buff[0]=0;				// Don't write same time twice
    fprintf(file,"%15.15s%7ld %-10.10s",
	    time_buff,thd->thread_id,command_name[(uint) command]);
    if (format)
    {
      VOID(fputc(' ',file));
      (void) vfprintf(file,format,args);
    }
    VOID(fputc('\n',file));
    flush();
    VOID(pthread_mutex_unlock(&LOCK_log));
  }
  va_end(args);
}


void MYSQL_LOG::flush()
{
  if (file)
    VOID(fflush(file));
}


void MYSQL_LOG::close()
{
  if (file)
  {
    VOID(my_fclose(file,MYF(0)));
    file=0;
  }
}
