/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Functions to handle keys and fields in forms */

#include "mysql_priv.h"

	/* Search after field with correspond to key */

uint find_keyfield(FORM *form,uint keynr)
{
  if (keynr >= form->keys)		/* If keynumber from handler*/
    return 0;
  return (find_field(form,(uint) form->key_info[keynr].key_part[0].offset,
		    (uint) form->key_info[keynr].key_part[0].length));
} /* find_keyfield */


	/*
	** Search after a field with given start & length
	** If an exact field isn't found, return longest field with starts
	** at right position.
	** Return 0 on error, else field number+1
	*/

uint find_field(FORM *form,uint start,uint length)
{
  FIELD *field;
  uint i;
  uint pos;

  pos=0;
  for (field=form->field, i=1 ; i<= form->fields ; i++,field++)
  {
    if (f_packtype(field->pack_flag) != (int) FIELD_TYPE_NULL &&
	(uint) (field->str - form->record[0]) == start)
    {
      if ((uint) field->length == length)
	return (i);
      if (!pos || form->field[pos-1].length < field->length)
	pos=i;
    }
  }
  return (pos);
} /* find_field */


	/* Search after with key field is. If no key starts with field test
	   if field is part of some key. */
	/* returns number of key. keylength is set to length of key up to and
	   including field */
	/* Used when calculating key for MTYP_NEXT_NUMBER */

int find_ref_key(FORM *form,FIELD *field,pbool find_keystart,uint *key_length)
{
  reg2 int i;
  reg3 KEY *key_info;
  reg4 KEY_PART_INFO *key_part;
  uint j,fieldpos,length,fieldlength;

  fieldpos= (uint) (field->str - form->record[0]);
  fieldlength=(uint) packlength(field);

	/* Test if some key starts as fieldpos */

  for (i=0, key_info=form->key_info ; i < (int) form->keys ; i++, key_info++)
  {
    if (key_info->key_part[0].offset == fieldpos)
    {						/* Found key. Calc keylength */
      *key_length=0;
      for (j=0 ;
	   (int7) j < key_info->key_parts &&
	   key_info->key_part[j].offset == fieldpos ;
	   j++)
      {
	if ((length=(int) key_info->key_part[j].length) >= fieldlength)
	{
	  (*key_length)+=fieldlength;	/* This field is enough */
	  break;
	}
	(*key_length)+=length;		/* We can at least use this part */
	fieldpos+=length;		/* Test if field is over more parts */
	fieldlength-=length;
      }
      return(i);			/* Use this key */
    }
  }
	/* Test if some key contains fieldpos */

  if (! find_keystart)
    for (i=0, key_info=form->key_info ; i < (int) form->keys ; i++, key_info++)
      for (j=0, key_part=key_info->key_part ;
	   j < key_info->key_parts ;
	   j++, key_part++)
      {
	if (key_part->offset <= fieldpos &&
	    (uint) (key_part->offset+key_part->length) > fieldpos)
	{
	  length= (uint) (key_part->offset+key_part->length-fieldpos);
	  *key_length= (uint) (fieldpos - key_part->offset)+
	    min(length,fieldlength);
	  for (key_part-- ; j-- ; key_part--)
	    *key_length+=key_part->length;
	  return(i);
	}
      }
  return(-1);					/* No key is ok */
} /* find_ref_key */


	/* Copy a key from record to some buffer */
	/* if length == 0 then copy hole key */

void key_copy(byte *key,FORM *form,uint index,uint key_length)
{
  uint length;
  KEY_PART_INFO *key_part;

  if (key_length == 0)
    key_length=form->key_info[index].key_length;
  for (key_part=form->key_info[index].key_part; key_length ; key_part++)
  {
    length=min(key_length,key_part->length);
    memcpy(key,form->record[0]+key_part->offset,(size_t) length);
    key+=length;
    key_length-=length;
  }
} /* key_copy */


	/* restore a key from some buffer to record */

void key_restore(FORM *form,byte *key,uint index,uint key_length)
{
  uint length;
  KEY_PART_INFO *key_part;

  if (key_length == 0)
  {
    if (index == (uint) -1)
      return;
    key_length=form->key_info[index].key_length;
  }
  for (key_part=form->key_info[index].key_part; key_length ; key_part++)
  {
    length=min(key_length,key_part->length);
    memcpy(form->record[0]+key_part->offset,key,(size_t) length);
    key+=length;
    key_length-=length;
  }
} /* key_restore */


	/* Compare if a key has changed */

int key_cmp(FORM *form,byte *key,uint index,uint key_length)
{
  uint length;
  KEY_PART_INFO *key_part;

  for (key_part=form->key_info[index].key_part; key_length ; key_part++)
  {
    length=min(key_length,key_part->length);
    if (!(key_part->key_type & (FIELDFLAG_NUMBER+FIELDFLAG_BINARY+
				FIELDFLAG_PACK)))
    {
      if (my_casecmp(key,form->record[0]+key_part->offset,length))
	return 1;
    }
    else if (memcmp(key,form->record[0]+key_part->offset,length))
      return 1;
    key+=length;
    key_length-=length;
  }
  return 0;
}

	/* unpack key-fields from record to some buffer */
	/* This is used to get a good error message */

uint key_unpack(char *to,FORM *form,uint index,uint key_length)
{
  uint flag,length;
  char *start_to;
  KEY_PART_INFO *key_part;
  FIELD *field;
  DBUG_ENTER("key_unpack");

  if (key_length == 0)
  {
    if (index == (uint) -1)
    {
      *to=0;
      DBUG_RETURN(0);
    }
    key_length=form->key_info[index].key_length;
  }
  start_to=to;
  for (key_part=form->key_info[index].key_part; ; key_part++)
  {
    if ((field=key_part->field))
    {
      length=r_unpackf_stripp(field,to);
      if (key_length >= packlength(field))
	to+=length;
      else
	to+=key_length;
    }
    else
    {						/* Try to unpack field */
      flag=(uint) key_part->key_type;
      length=(uint) key_part->length;
      if (f_is_packed(flag))
	flag|=FIELDFLAG_NUMBER;			/* Can't fix intervall */
      if (f_is_num(flag) && f_is_packed(flag))
	length=0;				/* Give hole length */
      to+=f_unpackfield_stripp(to,form->record[0]+key_part->offset,
			       flag, length, (TYPELIB *) 0);
    }
    if (key_length > key_part->length)
    {
      *to++='-';
      key_length-=key_part->length;
    }
    else
      break;
  }
  *to='\0';
  DBUG_RETURN((uint) (to-start_to));
} /* key_unpack */

