/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Function items used by mysql */
#pragma interface

class Item_func :public Item_result_field
{
protected:
  Item **args;
  uint arg_count;
public:
  enum Functype { UNKNOWN_FUNC,EQ_FUNC,NE_FUNC,LT_FUNC,LE_FUNC,GE_FUNC,GT_FUNC,
		  LIKE_FUNC,NOTLIKE_FUNC,ISNULL_FUNC,ISNOTNULL_FUNC,
		  COND_AND_FUNC,COND_OR_FUNC};
  enum Type type() const { return FUNC_ITEM; }
  virtual enum Functype functype() const   { return UNKNOWN_FUNC; }
  Item_func(void)
  {
    arg_count=0;
  }
  Item_func(Item *a)
  {
    arg_count=1;
    args=(Item**) sql_alloc(sizeof(Item*));
    args[0]=a;
  }
  Item_func(Item *a,Item *b)
  {
    arg_count=2;
    args=(Item**) sql_alloc(sizeof(Item*)*2);
    args[0]=a; args[1]=b;
  }
  Item_func(Item *a,Item *b,Item *c)
  {
    arg_count=3;
    args=(Item**) sql_alloc(sizeof(Item*)*3);
    args[0]=a; args[1]=b; args[2]=c;
  }
  Item_func(Item *a,Item *b,Item *c,Item *d)
  {
    arg_count=4;
    args=(Item**) sql_alloc(sizeof(Item*)*4);
    args[0]=a; args[1]=b; args[2]=c; args[3]=d;
  }
  Item_func(List<Item> &list);
  ~Item_func();
  bool fix_fields(THD *,struct tlist_s *,const string);
  FIELD *make_field(FIELD *field);
  ulong used_tables();
  virtual void fix_length_and_dec()=0;
  virtual bool select_optimize() { return 0; }
  inline Item **arguments() { return args; }
  inline uint argument_count() const { return arg_count; }
  inline void remove_arguments() { arg_count=0; }
};


class Item_num_func :public Item_func
{
public:
  Item_num_func() :Item_func() {}
  Item_num_func(Item *a) :Item_func(a) {}
  Item_num_func(Item *a,Item *b) :Item_func(a,b) {}
  Item_num_func(Item *a,Item *b,Item *c) :Item_func(a,b,c) {}
  Item_num_func(List<Item> &list) :Item_func(list) {}
  String *str(String*str);
  enum Item_result result_type () const { return Item::REAL_RESULT; }
  void fix_length_and_dec();
};


class Item_bool_func :public Item_num_func
{
public:
  Item_bool_func(Item *a) :Item_num_func(a) {}
  Item_bool_func(Item *a,Item *b) :Item_num_func(a,b) {}
  void fix_length_and_dec() { decimals=0; max_length=2; }
};

class Item_bool_func2 :public Item_num_func
{						/* Bool with 2 string args */
protected:
  String tmp_value1,tmp_value2;
public:
  Item_bool_func2(Item *a,Item *b) :Item_num_func(a,b) {}
  void fix_length_and_dec() { decimals=0; max_length=2; }
  int compare();				/* compare arg[0] & arg[1] */
  bool select_optimize() { return 1; }
  virtual enum Functype rev_functype() const { return UNKNOWN_FUNC; }
};


class Item_str_func :public Item_func
{
public:
  Item_str_func() :Item_func() {}
  Item_str_func(Item *a) :Item_func(a) {}
  Item_str_func(Item *a,Item *b) :Item_func(a,b) {}
  Item_str_func(Item *a,Item *b,Item *c) :Item_func(a,b,c) {}
  Item_str_func(Item *a,Item *b,Item *c,Item *d) :Item_func(a,b,c,d) {}
  Item_str_func(List<Item> &list) :Item_func(list) {}
  double val();
  enum Item_result result_type () const { return Item::STRING_RESULT; }
  void left_right_max_length();
};


class Item_func_plus :public Item_num_func
{
public:
  Item_func_plus(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
};

class Item_func_minus :public Item_num_func
{
public:
  Item_func_minus(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
};

class Item_func_mul :public Item_num_func
{
public:
  Item_func_mul(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
};


class Item_func_div :public Item_num_func
{
public:
  Item_func_div(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec();
};


class Item_func_mod :public Item_num_func
{
public:
  Item_func_mod(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec();
};


class Item_func_neg :public Item_num_func
{
public:
  Item_func_neg(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec();
};

class Item_func_abs :public Item_num_func
{
public:
  Item_func_abs(Item *a) :Item_num_func(a) {}
  double val();
};

class Item_func_exp :public Item_num_func
{
public:
  Item_func_exp(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec()
  {
    decimals=args[0]->decimals+2; max_length=float_length(decimals);
  }
};

class Item_func_log :public Item_num_func
{
public:
  Item_func_log(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec()
  {
    decimals=args[0]->decimals+2; max_length=float_length(decimals);
    maybe_null=1;
  }
};

class Item_func_log10 :public Item_num_func
{
public:
  Item_func_log10(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec()
  {
    decimals=args[0]->decimals+2; max_length=float_length(decimals);
    maybe_null=1;
  }
};

class Item_func_sqrt :public Item_num_func
{
public:
  Item_func_sqrt(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec()
  { decimals=args[0]->decimals+2; max_length=float_length(decimals); }
};


class Item_func_pow :public Item_num_func
{
public:
  Item_func_pow(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec()
  {
    Item_num_func::fix_length_and_dec();
    maybe_null=1;
  }
};

class Item_func_integer :public Item_num_func
{
public:
  Item_func_integer(Item *a) :Item_num_func(a) {}
  void fix_length_and_dec();
};


class Item_func_ceiling :public Item_func_integer
{
public:
  Item_func_ceiling(Item *a) :Item_func_integer(a) {}
  double val();
};

class Item_func_floor :public Item_func_integer
{
public:
  Item_func_floor(Item *a) :Item_func_integer(a) {}
  double val();
};

class Item_func_round :public Item_func_integer
{
public:
  Item_func_round(Item *a) :Item_func_integer(a) {}
  double val();
};

class Item_func_rand :public Item_num_func
{
public:
  Item_func_rand(Item *a) :Item_num_func(a) {}
  Item_func_rand()	  :Item_num_func()  {}
  double val();
  void fix_length_and_dec() { max_length=6; decimals=4; }
};


class Item_func_sign :public Item_num_func
{
public:
  Item_func_sign(Item *a) :Item_num_func(a) {}
  double val();
};


class Item_func_not :public Item_bool_func
{
public:
  Item_func_not(Item *a) :Item_bool_func(a) {}
  double val();
};

class Item_func_or :public Item_bool_func
{
public:
  Item_func_or(Item *a,Item *b) :Item_bool_func(a,b) { };
  double val();
  void fix_length_and_dec() { maybe_null=0; max_length=1; }
};

class Item_func_and :public Item_bool_func
{
public:
  Item_func_and(Item *a,Item *b) :Item_bool_func(a,b) { };
  double val();
  void fix_length_and_dec() { maybe_null=0; max_length=1; }
};


class Item_func_eq :public Item_bool_func2
{
public:
  Item_func_eq(Item *a,Item *b) :Item_bool_func2(a,b) { };
  double val();
  enum Functype functype() const { return EQ_FUNC; }
  enum Functype rev_functype() const { return EQ_FUNC; }
};


class Item_func_ge :public Item_bool_func2
{
public:
  Item_func_ge(Item *a,Item *b) :Item_bool_func2(a,b) { };
  double val();
  enum Functype functype() const { return GE_FUNC; }
  enum Functype rev_functype() const { return LT_FUNC; }
};


class Item_func_gt :public Item_bool_func2
{
public:
  Item_func_gt(Item *a,Item *b) :Item_bool_func2(a,b) { };
  double val();
  enum Functype functype() const { return GT_FUNC; }
  enum Functype rev_functype() const { return LE_FUNC; }
};


class Item_func_le :public Item_bool_func2
{
public:
  Item_func_le(Item *a,Item *b) :Item_bool_func2(a,b) { };
  double val();
  enum Functype functype() const { return LE_FUNC; }
  enum Functype rev_functype() const { return GT_FUNC; }
};


class Item_func_lt :public Item_bool_func2
{
public:
  Item_func_lt(Item *a,Item *b) :Item_bool_func2(a,b) { }
  double val();
  enum Functype functype() const { return LT_FUNC; }
  enum Functype rev_functype() const { return GE_FUNC; }
};


class Item_func_ne :public Item_bool_func2
{
public:
  Item_func_ne(Item *a,Item *b) :Item_bool_func2(a,b) { }
  double val();
  enum Functype functype() const { return NE_FUNC; }
  bool select_optimize() { return 0; }
};

class Item_func_min_max :public Item_num_func
{
public:
  Item_func_min_max(List<Item> &list) :Item_num_func(list) {}
  void fix_length_and_dec();
};

class Item_func_min :public Item_func_min_max
{
public:
  Item_func_min(List<Item> &list) :Item_func_min_max(list) {}
  double val();
};

class Item_func_max :public Item_func_min_max
{
public:
  Item_func_max(List<Item> &list) :Item_func_min_max(list) {}
  double val();
};


class Item_func_concat :public Item_str_func
{
  String tmp_value;
public:
  Item_func_concat(List<Item> &list) :Item_str_func(list) {}
  String *str(String *);
  void fix_length_and_dec();
};


class Item_func_replace :public Item_str_func
{
  String tmp_value,tmp_value2;
public:
  Item_func_replace(Item *org,Item *find,Item *replace)
    :Item_str_func(org,find,replace) {}
  String *str(String *);
  void fix_length_and_dec();
};


class Item_func_insert :public Item_str_func
{
  String tmp_value;
public:
  Item_func_insert(Item *org,Item *start,Item *length,Item *new_str)
    :Item_str_func(org,start,length,new_str) {}
  String *str(String *);
  void fix_length_and_dec();
};


class Item_str_conv :public Item_str_func
{
public:
  Item_str_conv(Item *item) :Item_str_func(item) {}
  void fix_length_and_dec() { max_length = args[0]->max_length; }
};


class Item_func_lcase :public Item_str_conv
{
public:
  Item_func_lcase(Item *item) :Item_str_conv(item) {}
  String *str(String *);
};

class Item_func_ucase :public Item_str_conv
{
public:
  Item_func_ucase(Item *item) :Item_str_conv(item) {}
  String *str(String *);
};


class Item_func_length :public Item_num_func
{
  String value;
public:
  Item_func_length(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec();
};


class Item_func_strcmp :public Item_bool_func2
{
public:
  Item_func_strcmp(Item *a,Item *b) :Item_bool_func2(a,b) {}
  double val();
  void fix_length_and_dec();
  bool select_optimize() { return 0; }
};


class Item_func_locate :public Item_num_func
{
  String value1,value2;
public:
  Item_func_locate(Item *a,Item *b) :Item_num_func(a,b) {}
  Item_func_locate(Item *a,Item *b,Item *c) :Item_num_func(a,b,c) {}
  double val();
  void fix_length_and_dec();
};


class Item_func_left :public Item_str_func
{
public:
  Item_func_left(Item *a,Item *b) :Item_str_func(a,b) {}
  String *str(String *);
  void fix_length_and_dec();
};


class Item_func_right :public Item_str_func
{
  String tmp_value;
public:
  Item_func_right(Item *a,Item *b) :Item_str_func(a,b) {}
  String *str(String *);
  void fix_length_and_dec();
};


class Item_func_substr :public Item_str_func
{
  String tmp_value;
public:
  Item_func_substr(Item *a,Item *b,Item *c) :Item_str_func(a,b,c) {}
  String *str(String *);
  void fix_length_and_dec();
};

class Item_func_ltrim :public Item_str_func
{
  String tmp_value;
public:
  Item_func_ltrim(Item *a) :Item_str_func(a) {}
  String *str(String *);
  void fix_length_and_dec() { max_length= args[0]->max_length; }
};


class Item_func_rtrim :public Item_str_func
{
  String tmp_value;
public:
  Item_func_rtrim(Item *a) :Item_str_func(a) {}
  String *str(String *);
  void fix_length_and_dec() { max_length= args[0]->max_length; }
};


class Item_func_password :public Item_str_func
{
  char tmp_value[9];
public:
  Item_func_password(Item *a) :Item_str_func(a) {}
  String *str(String *);
  void fix_length_and_dec() { max_length = 8; }
};


class Item_func_database :public Item_str_func
{
public:
  Item_func_database() {}
  String *str(String *);
  void fix_length_and_dec() { max_length= MAX_FIELD_NAME; }
};

class Item_func_user :public Item_str_func
{
public:
  Item_func_user() {}
  String *str(String *);
  void fix_length_and_dec() { max_length= MAX_FIELD_NAME; }
};


class Item_func_intervall :public Item_num_func
{
  Item *item;
  double *intervalls;
public:
  Item_func_intervall(Item *a,List<Item> &list)
    :Item_num_func(list),item(a),intervalls(0) {}
  double val();
  bool fix_fields(THD *thd,struct tlist_s *tlist,const string where)
  {
    return (item->fix_fields(thd,tlist,where) ||
	    Item_func::fix_fields(thd,tlist,where));
  }
  void fix_length_and_dec();
  ~Item_func_intervall() { delete item; }
};


class Item_func_between :public Item_num_func
{
public:
  String value0,value1,value2;
  Item_func_between(Item *a,Item *b,Item *c) :Item_num_func(a,b,c) {}
  double val();
  void fix_length_and_dec() { max_length=1; }
  virtual bool select_optimize() { return 1; }
};

class Item_func_elt :public Item_num_func
{
  Item *item;
  String value,tmp;
public:
  Item_func_elt(Item *a,List<Item> &list) :Item_num_func(list),item(a) {}
  ~Item_func_elt() { delete item; }
  double val();
  bool fix_fields(THD *thd,struct tlist_s *tlist,const string where)
  {
    return (item->fix_fields(thd,tlist,where) ||
	    Item_func::fix_fields(thd,tlist,where));
  }
  void fix_length_and_dec() { maybe_null=0; max_length=2; }
};


class Item_func_period_add :public Item_num_func
{
public:
  Item_func_period_add(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=6; }
};


class Item_func_period_diff :public Item_num_func
{
public:
  Item_func_period_diff(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=6; }
};


class Item_func_to_days :public Item_num_func
{
  String value;
public:
  Item_func_to_days(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=6; }
};


class Item_func_weekday :public Item_num_func
{
  String value;
public:
  Item_func_weekday(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=1; }
};


class Item_date :public Item_func
{
public:
  Item_date() :Item_func() {}
  Item_date(Item *a) :Item_func(a) {}
  enum Item_result result_type () const { return Item::STRING_RESULT; }
  String *str(String *str);
  void fix_length_and_dec() { decimals=0; max_length=10; }
};


class Item_func_from_days :public Item_date
{
public:
  Item_func_from_days(Item *a) :Item_date(a) {}
  double val();
};


class Item_func_curdate :public Item_date
{
  double value;
public:
  Item_func_curdate() :Item_date() {}
  double val();
  void fix_length_and_dec();
};


class Item_func_now :public Item_func
{
  double value;
  char buff[20];
public:
  Item_func_now() :Item_func() {}
  enum Item_result result_type () const { return Item::STRING_RESULT; }
  double val();
  String *str(String *str);
  void fix_length_and_dec();
};


class Item_func_bit_or :public Item_num_func
{
public:
  Item_func_bit_or(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=10; }
};

class Item_func_bit_and :public Item_num_func
{
public:
  Item_func_bit_and(Item *a,Item *b) :Item_num_func(a,b) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=10; }
};

class Item_func_bit_count :public Item_num_func
{
public:
  Item_func_bit_count(Item *a) :Item_num_func(a) {}
  double val();
  void fix_length_and_dec() { decimals=0; max_length=2; }
};


class Item_func_ifnull :public Item_func
{
  enum Item_result cached_result_type;
public:
  Item_func_ifnull(Item *a,Item *b) :Item_func(a,b) { }
  double val();
  String *str(String *str);
  enum Item_result result_type () const { return cached_result_type; }
  void fix_length_and_dec();
};


class Item_func_if :public Item_func
{
  enum Item_result cached_result_type;
public:
  Item_func_if(Item *a,Item *b,Item *c) :Item_func(a,b,c) { }
  double val();
  String *str(String *str);
  enum Item_result result_type () const { return cached_result_type; }
  void fix_length_and_dec();
};


/* Functions used by where clause */

class Item_func_isnull :public Item_bool_func
{
public:
  Item_func_isnull(Item *a) :Item_bool_func(a) {}
  double val();
  enum Functype functype() const { return ISNULL_FUNC; }
  void fix_length_and_dec() { decimals=0; max_length=1; maybe_null=0; }
};

class Item_func_isnotnull :public Item_bool_func
{
public:
  Item_func_isnotnull(Item *a) :Item_bool_func(a) {}
  double val();
  enum Functype functype() const { return ISNOTNULL_FUNC; }
  void fix_length_and_dec() { decimals=0; max_length=1; maybe_null=0; }
};

class Item_func_like :public Item_bool_func2
{
public:
  Item_func_like(Item *a,Item *b) :Item_bool_func2(a,b) {}
  double val();
  enum Functype functype() const { return LIKE_FUNC; }
  bool select_optimize();
};

class Item_func_nlike :public Item_bool_func2
{
public:
  Item_func_nlike(Item *a,Item *b) :Item_bool_func2(a,b) {}
  double val();
  enum Functype functype() const { return NOTLIKE_FUNC; }
  virtual bool select_optimize() { return 0; }
};


class Item_func_format :public Item_str_func
{
  String tmp_str;
public:
  Item_func_format(Item *org,int dec);
  String *str(String *);
  void fix_length_and_dec()
  {
    max_length=args[0]->max_length+(args[0]->max_length-args[0]->decimals)/3;
  }
};


#ifdef USE_REGEX

#include <regex.h>

class Item_func_regex :public Item_bool_func
{
  regex_t preg;
  bool regex_compiled;
public:
  Item_func_regex(Item *a,Item *b) :Item_bool_func(a,b),regex_compiled(0) {}
  ~Item_func_regex();
  double val();
  bool fix_fields(THD *thd,struct tlist_s *tlist,const string where);
};

#else

class Item_func_regex :public Item_bool_func
{
public:
  Item_func_regex(Item *a,Item *b) :Item_bool_func(a,b) {}
  double val() { return 0.0;}
};

#endif /* USE_REGEX */


typedef class Item COND;

class Item_cond :public Item_func
{
protected:
  List<Item> list;
  ulong *used_table;
public:
  Item_cond(Item *i1,Item *i2) :Item_func()
    { list.push_back(i1); list.push_back(i2); }
  ~Item_cond() { list.delete_elements(); }
  bool fix_fields(THD *,struct tlist_s *,const string);
  void fix_length_and_dec() { decimals=0; max_length=1; }
  enum Type type() const { return COND_ITEM; }
  List<Item>* argument_list() { return &list; }
  ulong used_tables();
  String *str(String *str);
  friend Item *add_or_conds(Item *i1,Item *i2);
  friend Item *add_and_conds(Item *i1,Item *i2);
  friend uint count_select_levels(COND *cond,uint *deep);
};


class Item_cond_and :public Item_cond
{
public:
  Item_cond_and(Item *i1,Item *i2) :Item_cond(i1,i2) {}
  enum Functype functype() const { return COND_AND_FUNC; }
  double val();
};

class Item_cond_or :public Item_cond
{
public:
  Item_cond_or(Item *i1,Item *i2) :Item_cond(i1,i2) {}
  enum Functype functype() const { return COND_OR_FUNC; }
  double val();
};
