/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

#pragma interface

class Item :public Sql_alloc {
public:
  enum Type {FIELD_ITEM,FUNC_ITEM,SUM_FUNC_ITEM,STRING_ITEM,
	     INT_ITEM,REAL_ITEM,NULL_ITEM,COPY_STR_ITEM,FIELD_AVG_ITEM,
	     PROC_ITEM,COND_ITEM,REF_ITEM};
  enum Item_result {STRING_RESULT,REAL_RESULT};
  string name;				/* Name from select */
  String str_value;			/* used to store value */
  bool maybe_null;			/* If item may be null */
  bool null_value;			/* if item is null */
  bool marker;				/* Used by group */
  uint	decimals,max_length;

  // alloc & destruct is done as start of select using sql_alloc
  Item() { maybe_null=null_value=0; name=0; decimals=max_length=0; }
  void set_name(char* str,uint length=0);
  FIELD *init_make_field(FIELD *tmp_field,enum enum_field_types type);
  virtual ~Item() { name=0; } /*lint -e1509 */
  virtual bool fix_fields(THD *,struct tlist_s *,const string);
  virtual bool save_in_field(FIELD *field);
  virtual char *send(char *);
  virtual bool eq(const Item *) const;
  virtual enum Item_result result_type () const { return REAL_RESULT; }
  virtual enum Type type() const =0;
  virtual double val()=0;
  virtual String *str(String*)=0;
  virtual FIELD *make_field(FIELD *field)=0;
  virtual FIELD *tmp_table_field() { return 0; }
  virtual char *full_name() { return name; }
  virtual double val_result() { return val(); }
  virtual String *str_result(String* tmp) { return str(tmp); }
  virtual ulong used_tables() { return (ulong) ~0L; }
  inline uint float_length(uint decimals_par) const {return (13+decimals_par);}
};


class Item_ident :public Item
{
public:
  char *table_name,*field_name;
  Item_ident(char *table_name_par,char *field_name_par)
    :table_name(table_name_par),field_name(field_name_par) { name = field_name_par; }
  char *full_name();
};

class Item_field :public Item_ident
{
  void set_field(FIELD *field);
public:
  FIELD *field,*result_field;
  // Item_field() {}

  Item_field(char *table_name_par,char *field_name_par)
    :field(0),result_field(0),Item_ident(table_name_par,field_name_par) {}
  Item_field(FIELD *field);
  enum Type type() const { return FIELD_ITEM; }
  bool eq(const Item *item) const;
  double val();
  String *str(String*);
  double val_result();
  String *str_result(String* tmp);
  char *send(char *);
  FIELD *make_field(FIELD *field);
  bool fix_fields(THD *,struct tlist_s *,const string);
  bool save_in_field(FIELD *field);
  ulong used_tables();
  enum Item_result result_type () const
  {
    return (f_is_num(field->pack_flag)) ? REAL_RESULT : STRING_RESULT;
  }
  FIELD *tmp_table_field();
};


class Item_null :public Item
{
public:
  Item_null() { maybe_null=null_value=TRUE; name="NULL";}
  enum Type type() const { return NULL_ITEM; }
  bool eq(const Item *item) const;
  double val();
  String *str(String *str);
  FIELD *make_field(FIELD *field);
  bool save_in_field(FIELD *field);
  enum Item_result result_type () const
  { return Item::STRING_RESULT; }
  char *send(char *);
};


class Item_int :public Item
{
public:
  const long value;
  Item_int(long i,uint length=11) :value(i) { max_length=length;}
  Item_int(char *str,long i,uint length) :value(i) { max_length=length; name=str;}
  Item_int(char *str) :value(atol(str)) { max_length=strlen(str); name=str;}
  enum Type type() const { return INT_ITEM; }
  double val() { return (double) value; }
  String *str(String*);
  FIELD *make_field(FIELD *field);
};


class Item_real :public Item
{
public:
  const double value;
  // Item_real() :value(0) {}
  Item_real(char *str) :value(atof(str))
  {
    name=str;
    this->decimals=nr_of_decimals(str);
    max_length=strlen(str);
  }
  enum Type type() const { return REAL_ITEM; }
  double val() { return value; }
  String *str(String*);
  FIELD *make_field(FIELD *field);
};


class Item_string :public Item
{
public:
  Item_string(const char *str,uint length)
  {
    str_value.set(str,length);
    max_length=length;
    name=(char*) str_value.ptr();
  }
  ~Item_string() {}
  enum Type type() const { return STRING_ITEM; }
  double val() { return atof(str_value.ptr()); }
  String *str(String*) { return (String*) &str_value; }
  FIELD *make_field(FIELD *field);
  enum Item_result result_type () const { return STRING_RESULT; }
};


class Item_empty_string :public Item_string
{
public:
  Item_empty_string(char *header,uint length) :Item_string("",0)
    { name=header; max_length=length;}
};

class Item_result_field :public Item	/* Item with result field */
{
public:
  FIELD *result_field;		/* Save result of function here */
  Item_result_field() :result_field(0) {}
  FIELD *tmp_table_field() { return result_field; }
};


#include "item_sum.h"
#include "item_func.h"
#include "item_uniq.h"

class Item_copy_string :public Item
{
public:
  Item *item;
  Item_copy_string(Item *i) :item(i)
  {
    maybe_null=item->maybe_null;
    decimals=item->decimals;
    max_length=item->max_length;
    name=item->name;
  }
  ~Item_copy_string() { delete item; }
  enum Type type() const { return COPY_STR_ITEM; }
  enum Item_result result_type () const { return Item::STRING_RESULT; }
  double val();
  String *str(String*);
  FIELD *make_field(FIELD *field) { return item->make_field(field); }
  void copy();
};


class Item_avg_field :public Item_result_field
{
public:
  FIELD *field;
  Item_avg_field(Item_sum_avg *item);
  enum Type type() const { return FIELD_AVG_ITEM; }
  double val();
  String *str(String*);
  FIELD *make_field(FIELD *field);
  FIELD *tmp_table_field() { return result_field; }
};


class Item_buff :public Sql_alloc {
public:
  bool null_value;
  Item_buff() :null_value(0) {}
  virtual bool cmp(void)=0;
  virtual ~Item_buff(); /*line -e1509 */
};

class Item_str_buff :public Item_buff
{
  Item *item;
  String value,tmp_value;
public:
  Item_str_buff(Item *arg) :item(arg),value(arg->max_length) {}
  bool cmp(void);
  ~Item_str_buff();				// Deallocate String:s
};


class Item_num_buff :public Item_buff
{
  Item *item;
  double value;
public:
  Item_num_buff(Item *item_par) :item(item_par),value(0.0) {}
  bool cmp(void);
};


class Item_field_buff :public Item_buff
{
  char *buff;
  FIELD *field;
  uint length;
  int (*item_cmp)(const char *a,const char *b,uint length);

public:
  Item_field_buff(Item_field *item)
  {
    length=item->field->packlength;
    buff= (char*) sql_calloc(length);
    field=item->field;
    item_cmp=((item->field->pack_flag &
	       (FIELDFLAG_BINARY+FIELDFLAG_NUMBER+FIELDFLAG_PACK)) ?
	      (int  (*)(const char *str,const char *cmp,uint length)) memcmp :
	      my_sortcmp);
  }
  bool cmp(void);
};

extern Item_buff *new_Item_buff(Item *item);


class Item_ref :public Item_ident
{
  Item **ref;
public:
  Item_ref(char *table_name_par,char *field_name_par)
    :ref(0),Item_ident(table_name_par,field_name_par) {}
  enum Type type() const		{ return REF_ITEM; }
  bool eq(const Item *item) const	{ return (*ref)->eq(item); }
  double val()
  {
    double tmp=(*ref)->val_result();
    null_value=(*ref)->null_value;
    return tmp;
  }
  String *str(String* tmp)
  {
    tmp=(*ref)->str_result(tmp);
    null_value=(*ref)->null_value;
    return tmp;
  }
  char *send(char *tmp)			{ return (*ref)->send(tmp); }
  FIELD *make_field(FIELD *field)	{ return (*ref)->make_field(field); }
  bool fix_fields(THD *,struct tlist_s *,const string);
  bool save_in_field(FIELD *field)	{ return (*ref)->save_in_field(field); }
  enum Item_result result_type () const { return (*ref)->result_type(); }
};


/*
** Some function prototypes
*/

String *field_to_string(String &str,FIELD *field);
