#!/bin/sh
# Copyright (C) 1997  TCX DataKonsult AB & Monty Program KB & Detron HB
# For a more info consult the file COPYRIGHT distributed with this file

# This scripts creates the privilige tables db, host, user in mysql
# It should be run from the top level installation directory

if test -f @localstatedir@/mysql/db.ISM
then
  echo "mysql privilege databases already installed. If you want to recreate all"
  echo "privilige tables, execute 'rm -i @localstatedir@/mysql/*.IS?'"
  echo "and run this script again"
  exit 1;
fi
if test ! -x @bindir@/mysqladmin
then
  echo "Can't execute @bindir@/mysqladmin"
  if test "@localstatedir@" = "./data"
  then
    echo "You should be in the distribution directory when executing this script"
  else
    echo "You should do a 'make install' before executing this script"
  fi
  exit 1;
fi

hostname=`hostname`		# Install this too in the user table

# create database mysql & test
#
mkdir @localstatedir@
mkdir @localstatedir@/mysql
mkdir @localstatedir@/test

@bindir@/mysqladmin ver > /dev/null 2>&1
if test $? -eq 0
then
  echo "mysql demon is running. Stop it and try again"
  exit 1;
else 
  echo "Starting mysql server"
  @scriptdir@/safe_mysqld -Sg -l &
  while true
  do
    sleep 1			# This should be enough
    @bindir@/mysqladmin ver > /dev/null 2>&1
    if test $? -eq 0 ; then break; fi
    sleep 5;			# This must be enough
    @bindir@/mysqladmin ver > /dev/null 2>&1
    if test $? -eq 0 ; then break; fi
    echo "mysql demon is not responding. Please try to start it manually with -Sg"
    exit 1;
  done
fi

# copy the definition files
#
if test "@localstatedir@" != "./data"
then
  cp -p ./data/mysql/*.frm @localstatedir@/mysql
fi

@bindir@/mysql mysql <<END_OF_DATA
# Create tables from the .frm files
#
delete from db ;
delete from host;
delete from user; 

#
# Dumping data for table 'db'
#

INSERT INTO db VALUES ('%','test','','Y','Y','Y','Y','Y','Y');
INSERT INTO db VALUES ('%','test\_%','','Y','Y','Y','Y','Y','Y');

#
# Dumping data for table 'host'
#

INSERT INTO host VALUES ('localhost','%','Y','Y','Y','Y','Y','Y');
INSERT INTO host VALUES ('$hostname','%','Y','Y','Y','Y','Y','Y');

#
# Dumping data for table 'user'
#

INSERT INTO user VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
INSERT INTO user VALUES ('localhost','','','N','N','N','N','N','N','N','N','N','N');
INSERT INTO user VALUES ('$hostname','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
INSERT INTO user VALUES ('$hostname','','','N','N','N','N','N','N','N','N','N','N');
END_OF_DATA

@bindir@/mysqladmin reload
echo "mysql grant tables installed"
