/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#define USES_TYPES
#include "mysys_priv.h"
#include <my_dir.h>
#include "mysys_err.h"
#include <errno.h>
#ifdef MSDOS
#include <share.h>
#include <io.h>
#endif

extern int	my_file_opened;

	/* Create a new file */

File my_create(FileName, CreateFlags, AccsesFlags, MyFlags)
const char *FileName;		/* Path-name of file */
int CreateFlags;		/* Read | write on file (umask value) */
int AccsesFlags;		/* Read & Write on open file */
myf MyFlags;			/* Special flags */
{
  int fd;
  DBUG_ENTER("my_create");
  DBUG_PRINT("my",("Name: '%s' CreateFlags: %d  AccsesFlags: %d  MyFlags: %d",
		   FileName, CreateFlags, AccsesFlags, MyFlags));

#if !defined(NO_OPEN_3)
  fd = open((string) FileName, AccsesFlags | O_CREAT,
	    CreateFlags ? CreateFlags : my_umask);
#elif defined(VMS)
  fd = open((string) FileName, AccsesFlags | O_CREAT, 0,
	    "ctx=stm","ctx=bin");
#elif defined(MSDOS)
  if (AccsesFlags & O_SHARE)
    fd = sopen((string) FileName, AccsesFlags | O_CREAT | O_BINARY,
	       SH_DENYNO, MY_S_IREAD | MY_S_IWRITE);
  else
    fd =  open((string) FileName, AccsesFlags | O_CREAT | O_BINARY,
	       MY_S_IREAD | MY_S_IWRITE);
#else
  fd = open(FileName, AccsesFlags);
#endif

  if (fd >= 0)
  {
    if ((my_file_info[fd].name = (char*) my_strdup(FileName,MyFlags)))
    {
      my_file_opened++;
      my_file_info[fd].type = FILE_BY_CREATE;
      DBUG_RETURN(fd);
    }
    VOID(my_close(fd,MyFlags));
    my_errno=ENOMEM;
  }
  else
    my_errno=errno;
  if (MyFlags & (MY_FFNF | MY_FAE | MY_WME))
    my_error(EE_CANTCREATEFILE, MYF(ME_BELL+ME_WAITTANG), FileName,my_errno);
  DBUG_RETURN(-1);
} /* my_create */
