/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** Common definition between mysql server & client
*/

#ifndef _mysql_com_h
#define _mysql_com_h
#ifdef	__cplusplus
extern "C" {
#endif

#define NAME_LEN	32		/* Field/table name length */
#define LOCAL_HOST	"localhost"

#define MYSQL_PORT	3333
#define MYSQL_UNIX_ADDR "/tmp/mysql.sock"

enum enum_server_command {SLEEP,QUIT,INIT_DB,QUERY,FIELD_LIST,
			  CREATE_DB,DROP_DB,RELOAD,SHUTDOWN,STATISTICS,
			  PROCESS_INFO,CONNECT};

#define NOT_NULL_FLAG	1
#define PRI_KEY_FLAG	2
#define UNIQUE_KEY_FLAG 4
#define MULTIPLE_KEY_FLAG 8
#define BLOB_FLAG	16
#define UNSIGNED_FLAG	32
#define ZEROFILL_FLAG	64
#define PART_KEY_FLAG	128		/* Intern; Part of some key */

#define PKT_LEN		(32*IO_SIZE)	/* Max size of client/server packet */
#ifndef ROOT
#define ROOT "root"
#endif

typedef struct st_used_mem {			/* struct for once_alloc */
  struct st_used_mem *next;			/* Next block in use */
  unsigned int	left;				/* memory left in block  */
  unsigned int	size;				/* size of block */
} USED_MEM;

typedef struct st_mem_root {
  USED_MEM *free;
  USED_MEM *used;
  unsigned int	min_malloc;
} MEM_ROOT;

typedef struct st_net {
  int fd,fcntl;
  uchar *buff,*buff_end,*write_pos;
  char last_error[160];
  unsigned int max_packet,timeout,pkt_nr;
  my_bool error;
} NET;

#define packet_error ((unsigned int) -1)

enum enum_field_types { FIELD_TYPE_DECIMAL, FIELD_TYPE_CHAR,
			FIELD_TYPE_SHORT,  FIELD_TYPE_LONG,
			FIELD_TYPE_FLOAT,  FIELD_TYPE_DOUBLE,
			FIELD_TYPE_NULL,   FIELD_TYPE_TIMESTAMP,
			FIELD_TYPE_LONGLONG,FIELD_TYPE_INT24,
			FIELD_TYPE_DATE,   FIELD_TYPE_TIME,
			FIELD_TYPE_TINY_BLOB=249,
			FIELD_TYPE_MEDIUM_BLOB=250,
			FIELD_TYPE_LONG_BLOB=251,
			FIELD_TYPE_BLOB=252,
			FIELD_TYPE_VAR_STRING=253,
			FIELD_TYPE_STRING=254
};

void	sql_free(MEM_ROOT *root);
void	init_sql_alloc(MEM_ROOT *root);
gptr	sql_alloc_root(MEM_ROOT *mem_root,unsigned int len);
char	*sql_strdup_root(MEM_ROOT *root,char *str);
char	*sql_memdup_root(MEM_ROOT *root,char *str,unsigned int len);

extern unsigned int max_allowed_packet;
extern unsigned int net_buffer_length;

#define net_new_transaction(net) ((net)->pkt_nr=0)
int	net_init(NET *net,int fd);
void	net_end(NET *net);
void	net_clear(NET *net);
int	net_flush(NET *net);
int	net_write(NET *net,const byte *packet,unsigned int len);
int	net_write_command(NET *net,uchar command,const byte *packet,
			  unsigned int len);
int	net_real_write(NET *net,const byte *packet,unsigned int len);
unsigned int	net_read(NET *net);

struct rand_struct {
  unsigned long seed,seed2,max_value;
};

void randominit(struct rand_struct *rand,unsigned long nr);
double rnd(struct rand_struct *rand);
void make_scrambled_password(char *to,const char *password);
unsigned long get_salt_from_password(const char *password);
char *scramble(char *to,const char *message,const char *password);
bool check_scramble(const char *scramble,const char *message,
		    unsigned long salt);

#define NULL_LENGTH ((unsigned long) ~0) /* For net_store_length */

#ifdef	__cplusplus
}
#endif
#endif
