/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* defines for libmysql */

#ifndef _mysql_h
#define _mysql_h
#ifdef	__cplusplus
extern "C" {
#endif

#ifndef _global_h				/* If not standard header */
#include <sys/types.h>
typedef unsigned char uchar;
typedef char my_bool;
#if !defined(__cplusplus) && !defined(bool)
typedef char bool;
#endif
typedef char byte;
typedef char * gptr;
typedef char * string;
#endif
#include "mysql_com.h"

extern unsigned int mysql_port;
extern string mysql_unix_port;

#define IS_PRI_KEY(n)	(n & PRI_KEY_FLAG)
#define IS_NOT_NULL(n)	(n & NOT_NULL_FLAG)
#define IS_BLOB(n)	(n & BLOB_FLAG)

typedef struct st_mysql_field {
  char *name,*table,*def;
  enum enum_field_types type;
  unsigned int length,max_length,flags,decimals;
} MYSQL_FIELD;

typedef byte **MYSQL_ROW;		/* return data as array of strings */

typedef struct st_mysql_rows {
  struct st_mysql_rows *next;		/* list of rows */
  MYSQL_ROW data;
} MYSQL_ROWS;


typedef struct st_mysql_data {
  unsigned int rows;
  unsigned int fields;
  MYSQL_ROWS *data;
  MEM_ROOT alloc;
} MYSQL_DATA;


typedef struct st_mysql {
  NET		net;			/* Communication parameters */
  char		server_version[40],host_info[80],scramble[9],*info;
  unsigned int	protocol_version;
  unsigned int	field_count;
  unsigned long	thread_id;		/* Id for connection in server */
  unsigned long	affected_rows;
  unsigned long	insert_id;		/* id if insert on table with NEXTNR */
  unsigned long	extra_info;		/* Used by mysqlshow */
  MYSQL_FIELD	*fields;
  MEM_ROOT	field_alloc;
  my_bool	free_me;		/* If free in mysql_close */
} MYSQL;


typedef struct st_mysql_res {
  unsigned long	row_count;
  unsigned int	field_count, current_field;
  MYSQL_FIELD	*fields;
  MYSQL_DATA	*data;
  MYSQL_ROWS	*data_cursor;
  MEM_ROOT	field_alloc;
  MYSQL_ROW	row;			/* If unbuffered read */
  MYSQL_ROW	current_row;		/* buffer to current row */
  unsigned int	*lengths;		/* column lengths of current row */
  MYSQL		*handle;		/* for unbuffered reads */
  my_bool	eof;			/* Used my mysql_fetch_row */
} MYSQL_RES;


#define mysql_num_rows(res) (res)->row_count
#define mysql_num_fields(res) (res)->field_count
#define mysql_affected_rows(res) (res)->affected_rows
#define mysql_insert_id(res) (res)->insert_id
#define mysql_field_seek(res,fieldnr) ((res)->current_field=fieldnr)
#define mysql_error(mysql) (mysql)->net.last_error
#define mysql_info(mysql) (mysql)->info
#define mysql_eof(res) (res)->eof
#define mysql_fetch_field_direct(res,fieldnr) ((res)->fields[fieldnr])
#define mysql_fetch_fields(res) (res)->fields

MYSQL		*mysql_connect(MYSQL *mysql,const char *host,
			       const char *user, const char *passwd);
void		mysql_close(MYSQL *sock);
int		mysql_select_db(MYSQL *mysql, const char *db);
int		mysql_query(MYSQL *mysql, const char *q);
int		mysql_real_query(MYSQL *mysql, const char *q,
				 unsigned int length);
int		mysql_create_db(MYSQL *mysql, const char *DB);
int		mysql_drop_db(MYSQL *mysql, const char *DB);
int		mysql_shutdown(MYSQL *mysql);
int		mysql_reload(MYSQL *mysql);
char		*mysql_stat(MYSQL *mysql);
char		*mysql_get_server_info(MYSQL *mysql);
char		*mysql_get_client_info(void);
char		*mysql_get_host_info(MYSQL *mysql);
unsigned int		mysql_get_proto_info(MYSQL *mysql);
MYSQL_RES	*mysql_list_dbs(MYSQL *mysql,const char *wild);
MYSQL_RES	*mysql_list_tables(MYSQL *mysql,const char *wild);
MYSQL_RES	*mysql_list_fields(MYSQL *mysql, const char *table,
				   const char *wild);
MYSQL_RES	*mysql_list_processes(MYSQL *mysql);
MYSQL_RES	*mysql_store_result(MYSQL *mysql);
MYSQL_RES	*mysql_use_result(MYSQL *mysql);
void		mysql_free_result(MYSQL_RES *result);
void		mysql_data_seek(MYSQL_RES *mysql, unsigned int offset);
MYSQL_ROW	mysql_fetch_row(MYSQL_RES *mysql);
unsigned int	*mysql_fetch_lengths(MYSQL_RES *mysql);
MYSQL_FIELD	*mysql_fetch_field(MYSQL_RES *handle);

#ifdef	__cplusplus
}
#endif
#endif
