/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* Write and read of logical packets to/from socket
** Writes are cached into net_buffer_length big packets.
** Read packets are reallocated dynamicly when reading big packets.
** Each logical packet has the following pre-info:
** 3 byte length & 1 byte package-number.
*/

#ifdef _WIN32
#include <winsock.h>
#endif
#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include "mysql.h"
#include <signal.h>
#include <errno.h>
#ifndef MSDOS
#include <netinet/in.h>
#endif
#ifdef MYSQL_SERVER
#include "thr_alarm.h"
#endif

#ifdef MSDOS
#define raw_net_read(A,B,C) recv((A),(B),(C),0)
#define raw_net_write(A,B,C) send((A),(B),(C),0)
#else
#define raw_net_read(A,B,C) read((A),(B),(C))
#define raw_net_write(A,B,C) write((A),(B),(C))
#endif

uint max_allowed_packet=65536;
#ifdef MYSQL_SERVER
uint net_buffer_length=16384;
#else
uint net_buffer_length=16384;
#endif
static int net_write_buff(NET *net,const byte *packet,uint len);


	/* Init with packet info */

int net_init(NET *net,int fd)
{
  if (!(net->buff=(uchar*) my_malloc(net_buffer_length,MYF(MY_WME))))
    return 1;

  if (net_buffer_length > max_allowed_packet)
    max_allowed_packet=net_buffer_length;
  net->buff_end=net->buff+(net->max_packet=net_buffer_length);
  net->fd=fd;
  net->error=0;
  net->timeout=30;				/* Timeout for read */
  net->pkt_nr=0;
  net->write_pos=net->buff;
  net->last_error[0]=0;
#ifdef MYSQL_SERVER
  if (fd)
  {
    net->fcntl=fcntl(net->fd, F_GETFL) | O_NONBLOCK;
    VOID(fcntl(net->fd, F_SETFL, net->fcntl));
  }
#endif
  return 0;
}

void net_end(NET *net)
{
  if (net->buff)
  {
    my_free((gptr) net->buff,MYF(0));
    net->buff=0;
  }
}

	/* Remove unwanted characters from connection */

#ifndef MYSQL_SERVER
void net_clear(NET *net)
{
#ifndef MSDOS
  int old_fcntl=fcntl(net->fd, F_GETFL);

  if (!(old_fcntl & O_NONBLOCK))
    VOID(fcntl(net->fd, F_SETFL, old_fcntl | O_NONBLOCK));
  while ((int) raw_net_read(net->fd,net->buff,net->max_packet) > 0) ;
  if (!(old_fcntl & O_NONBLOCK))
    VOID(fcntl(net->fd, F_SETFL, old_fcntl));
#else
  ulong arg;

  arg=1; ioctlsocket(net->fd,FIONBIO,&arg);
  while ((int) raw_net_read(net->fd,net->buff,net->max_packet) > 0) ;
  arg=0; ioctlsocket(net->fd,FIONBIO,&arg);
#endif
  net->pkt_nr=0;				/* Ready for new command */
  net->write_pos=net->buff;
}
#endif

	/* Flush write_buffer if not empty. */

int net_flush(NET *net)
{
  int error=0;
  if (net->buff != net->write_pos)
  {
    error=net_real_write(net,(byte*) net->buff,
			 (uint) (net->write_pos - net->buff));
    net->write_pos=net->buff;
  }
  return error;
}


/*****************************************************************************
** Write something to server/clinet buffer
*****************************************************************************/


/*
** Write a logical packet with packet header
** Format: Packet length (3 bytes), packet number(1 byte)
*/

int
net_write(NET *net,const byte *packet,uint len)
{
  uchar buff[4];
  int3store(buff,len);
  buff[3]=(uchar) (net->pkt_nr++);
  if (net_write_buff(net,(char*) buff,4))
    return 1;
  return net_write_buff(net,packet,len);
}

int
net_write_command(NET *net,uchar command,const byte *packet,uint len)
{
  uchar buff[5];
  uint length=len+1;

  int3store(buff,length);
  buff[3]=(uchar) (net->pkt_nr++);
  buff[4]=command;
  if (!net->buff)
  {						/* If net not initiated */
    return test(net_real_write(net,(byte*) buff,5) ||
		net_real_write(net,packet,len));
  }
  if (net_write_buff(net,(char*) buff,5))
    return 1;
  return test(net_write_buff(net,packet,len) || net_flush(net));
}


static int
net_write_buff(NET *net,const byte *packet,uint len)
{
  uint left_length=(uint) (net->buff_end - net->write_pos);

  while (len > left_length)
  {
    memcpy((byte*) net->write_pos,packet,left_length);
    if (net_real_write(net,(byte*) net->buff,net->max_packet))
      return 1;
    net->write_pos=net->buff;
    packet+=left_length;
    len-=left_length;
    left_length=net->max_packet;
  }
  memcpy((byte*) net->write_pos,packet,len);
  net->write_pos+=len;
  return 0;
}


#ifdef MYSQL_SERVER

/*  Read and write using timeouts */

int
net_real_write(NET *net,const byte *packet,uint len)
{
  int length;
  byte *pos,*end;
  int *alarmed=0;

  pos=(byte*) packet; end=pos+len;
  while (pos != end)
  {
    if ((int) (length=raw_net_write(net->fd,pos,(size_t) (end-pos))) <= 0)
    {
      if ((errno == EAGAIN  || length == 0) && !alarmed)
      {
	if ((alarmed=thr_alarm(60)))		/* Don't wait too long */
	{
	  VOID(fcntl(net->fd, F_SETFL, net->fcntl & ~ O_NONBLOCK));
	  continue;
	}
      } else if (alarmed && !*alarmed && errno == EINTR)
	continue;
      net->error=1;				/* Close socket */
      break;
    }
    pos+=length;
  }
  if (alarmed)
  {
    thr_end_alarm(alarmed);
    VOID(fcntl(net->fd, F_SETFL, net->fcntl));
  }
  return (int) (pos != end);
}

#else

int
net_real_write(NET *net,const byte *packet,uint len)
{
  int length;
  byte *pos,*end;
  bool alarmed=0;

  pos=(byte*) packet; end=pos+len;
  while (pos != end)
  {
    if ((int) (length=raw_net_write(net->fd,pos,(size_t) (end-pos))) <= 0)
    {
      if ((errno == EAGAIN  || length == 0) && !alarmed)
      {
	alarmed=1;
	VOID(fcntl(net->fd, F_SETFL, net->fcntl & ~ O_NONBLOCK));
	continue;
      }
      break;
    }
    pos+=length;
  }
  if (alarmed)
    VOID(fcntl(net->fd, F_SETFL, net->fcntl));
  return (int) (pos != end);
}
#endif


/*****************************************************************************
** Read something from server/clinet
*****************************************************************************/

#ifdef MYSQL_SERVER

uint
net_read(NET *net)
{
  uchar *pos;
  ulong len,remain;
  long length;
  uint i;
  int *alarmed;

  len=packet_error;
  remain = 4;
  pos=net->buff;
  alarmed=0;

  for (i=0 ; i < 2 ; i++)
  {
    while (remain > 0)
    {
      if ((int) (length=raw_net_read(net->fd,(char*) pos,remain)) <= 0)
      {
	if ((errno == EAGAIN  || length == 0) && !alarmed)
	{
	  if ((alarmed=thr_alarm(net->timeout))) /* Don't wait too long */
	  {
	    VOID(fcntl(net->fd, F_SETFL, net->fcntl & ~ O_NONBLOCK));
	    continue;
	  }
	}
	else if (alarmed && !*alarmed && errno == EINTR)
	  continue;
	len= packet_error;
	net->error=1;			/* Close socket */
	goto end;
      }
      remain -= (ulong) length;
      pos+= (ulong) length;
    }
    if (i == 0)
    {					/* First parts is packet length */
      if ((len=uint3korr(net->buff)) >= max_allowed_packet)
      {
	fprintf(stderr,"Packet too large (%ld)\n", len);
	len= packet_error;		/* Return error */
	goto end;
      }
      if (net->buff[3] != (uchar) net->pkt_nr)
      {
	fprintf(stderr,"Packets out of order (Found: %d, expected %d)\n",
		(int) net->buff[3],net->pkt_nr);
	len= packet_error;
	goto end;
      }
      net->pkt_nr++;
      if (len >= net->max_packet)
      {					/* Alloc bigger package */
	uint pkt_length=(len+IO_SIZE) & ~(IO_SIZE-1);
	uchar *buff=(uchar*) my_realloc((char*) net->buff,pkt_length,
					MYF(MY_WME));
	if (!buff)
	{
	  len=packet_error;
	  goto end;
	}
	net->buff=net->write_pos=buff;
	net->buff_end=buff+(net->max_packet=pkt_length);
      }
      pos=net->buff;
      remain = len;
    }
  }
  *pos = 0;				/* Safeguard */

end:
  if (alarmed)
  {
    thr_end_alarm(alarmed);
    VOID(fcntl(net->fd, F_SETFL, net->fcntl));
  }
  return(len);
}

#else /* !MYSQL_SERVER */

uint net_read(NET *net)
{
  uchar *pos;
  ulong len,remain;
  long length;
  uint i;
  bool alarmed=0;

  len= packet_error;
  remain = 4;
  pos=net->buff;			/* net->packet -4 */
  for (i=0 ; i < 2 ; i++)
  {
    while (remain > 0)
    {
      if ((int) (length=raw_net_read(net->fd,pos,remain)) <= 0)
      {
	if ((errno == EAGAIN  || length == 0) && !alarmed)
	{
	  alarmed=1;
	  VOID(fcntl(net->fd, F_SETFL, net->fcntl & ~ O_NONBLOCK));
	  continue;
	}
	len= packet_error;
	goto end;
      }
      remain -= (ulong) length;
      pos+= (ulong) length;
    }
    if (i == 0)
    {					/* First parts is packet length */
      if ((len=uint3korr(net->buff)) >= max_allowed_packet)
      {
	fprintf(stderr,"Packet too large (%ld)\n", len);
	return packet_error;		/* Return error */
      }
      if (net->buff[3] != (uchar) net->pkt_nr)
      {
	fprintf(stderr,"Packets out of order (Found: %d, expected %d)\n",
		(int) net->buff[3],net->pkt_nr);
	len=packet_error;
	break;
      }
      net->pkt_nr++;
      if (len >= net->max_packet)
      {					/* Alloc bigger package */
	uint pkt_length=(len+IO_SIZE) & ~(IO_SIZE-1);
	uchar *buff=(uchar*) my_realloc((char*) net->buff,pkt_length,
					MYF(MY_WME));
	if (!buff)
	{
	  len=packet_error;
	  break;
	}
	net->buff=net->write_pos=buff;
	net->buff_end=buff+(net->max_packet=pkt_length);
      }
      pos=net->buff;
      remain = len;
    }
  }

end:
  if (alarmed)
    VOID(fcntl(net->fd, F_SETFL, net->fcntl));
  *pos = 0;				/* Safeguard */
  return(len);
}

#endif
