proc showQueryText {} {
	global qry
	.qry.t delete 0.0 end
	if {[info exists qry([.qry.q.combo.e get])]} {
		.qry.t insert end $qry([.qry.q.combo.e get])
	}
}

proc createQuery {} {
	global qry
	if {[.qry.q.combo.e get] != ""} {
		if {![info exists qry([.qry.q.combo.e get])]} {
			lappend qry(New) [.qry.q.combo.e get]
		}
		set qry([.qry.q.combo.e get]) [.qry.t get 0.0 end]
	}
	destroy .qry
}

proc queryUpdateAttributeList {} {
	set class [.qry.lists.tbls.e get]
	set combolst {}
	foreach i [queryList "\
select a.attname, t.typname, a.attlen, a.oid, c.oid \
	from pg_attribute a, pg_class c, pg_type t \
where a.attrelid = c.oid \
	and	c.relname = '$class' \
	and a.attnum > 0 \
	and a.atttypid = t.oid \
order by a.oid"] {
		lappend combolst [lindex $i 0] 
	}
	eval combobox_setlist .qry.lists.atts $combolst
} 

proc dbNewQuery {} {
	global base sld frm rel qry
	toplevel .qry
	wm transient .qry .	
	frame .qry.lists
	combobox .qry.lists.tbls
	set combolst {}
	foreach i [queryList " \
select distinct c.relname,c.oid from \
	pg_class c, pg_attribute a \
where c.relkind = 'r' \
	and a.attnum > 0 \
	and c.relname !~ '^pg_' \
	and a.attrelid = c.oid \
order by c.oid"] {
		lappend combolst [lindex $i 0]
	}
	eval combobox_setlist .qry.lists.tbls $combolst 
	bind .qry.lists.tbls.btm <Unmap> {queryUpdateAttributeList} 
	combobox .qry.lists.atts
	.qry.lists.atts.e insert end "*attributes*"
	.qry.lists.tbls.e insert end "*classes*"
	bind .qry.lists.atts.e <Return> {.qry.t insert end "[%W get] "}
	bind .qry.lists.tbls.e <Return> {.qry.t insert end "[%W get] "}
	pack .qry.lists.tbls .qry.lists.atts -side left -fill x -expand 1
	frame .qry.q
	label .qry.q.l -text "Query name"
	combobox .qry.q.combo -width 30
	text .qry.t -width 40 -height 6
	frame .qry.bts
	button .qry.bts.cancel -text cancel -command {destroy .qry}
	button .qry.bts.done -text done -command {createQuery}
	eval combobox_setlist .qry.q.combo $qry(New)
	bind .qry.q.combo.btm <Unmap> {showQueryText} 
	pack .qry.q.l .qry.q.combo -side left -fill x -expand 1
	pack .qry.bts.cancel .qry.bts.done -side left -fill x -expand 1
	pack .qry.lists .qry.q .qry.t .qry.bts -side top
	centerWindow .qry
	raise .qry
	focus .qry
	grab .qry
}

proc dbMakeQueryList {} {
	global sld qry
	.mb.db.m.qry delete 0 end
	.mb.db.m.qry add command -label Edit -underline 0 -command dbNewQuery
	if {![info exists qry(New)]} {
		set qry(New) {}
	} 
	foreach i $qry(New) {
		.mb.db.m.qry add command -label $i -command "doQuery $i"
	}
}

proc getPrintOptionsDone {ret} {
	global pr
	set pr(options) ""
	if {$ret} {
		append pr(options) "-colormode $pr(mode)"
		if {$pr(file)} {
			append pr(options) " -file $pr(filename)"
		} else {
			append pr(options) " -file |lpr"
		}
		eval .c postscript $pr(options) 
	}
	destroy .pr
}

proc getPrintOptions {} {
	toplevel .pr
	wm transient .pr .
	frame .pr.ft
	radiobutton .pr.ft.color -text Color \
		-variable pr(mode) -value color
	radiobutton .pr.ft.gray -text gray \
		-variable pr(mode) -value gray 
	radiobutton .pr.ft.mono -text "b&w" \
		-variable pr(mode) -value mono
	.pr.ft.color invoke
	pack .pr.ft.color .pr.ft.gray .pr.ft.mono -side left
	frame .pr.fm
	checkbutton .pr.fm.b -text "to file" \
		-variable pr(file) -onvalue 1 -offvalue 0
	entry .pr.fm.e -width 40 -textvariable pr(filename)
	pack .pr.fm.b .pr.fm.e -side left -fill x -expand 1
	frame .pr.fb
	button .pr.fb.cancel -text cancel -command { getPrintOptionsDone 0 }
	button .pr.fb.print -text print -command { getPrintOptionsDone 1 }
	pack .pr.fb.cancel .pr.fb.print -side left -fill x -expand 1
	pack .pr.ft .pr.fm .pr.fb -side top
	centerWindow .pr
	raise .pr
}

proc dbFilters {} {
}

proc preencheForm { tupla {lclass {}} } {
	global frm frmv sld base relvar
	if {$lclass == {}} {
		set pclass $base
	} {
		set pclass $lclass
	}
	set sld(oid,$pclass) [lindex $tupla 0]
	set i 0
	forclass w $lclass 0 {
		$w delete 0 end
		$w insert 0 [lindex $tupla [expr $i + 1]]
		incr i
	}
	forrelation att oatt oclass $pclass {
		set v [lindex $tupla [expr $i + 1]]
		set relvar($pclass.$att) $v 
		set relvar($oclass.$oatt) $v 
		incr i
	}
	foreach w [array names frmv] {
		$w delete 0 end
		$w insert 0 [expr $frmv($w)]
	}
}

### Retorna lista com classes usadas e aliases
proc dbClassesUsed {} {
	global sld frm rel
	set classes {}
	foreach w [array names frm] {
		if {[lsearch $classes [lindex $frm($w) 0]] < 0} {
			lappend classes [lindex $frm($w) 0]
		} 
	}
	set classes
}

proc queryList {qry} {
	global frm sld
	set data ""
	set res [pg_exec $sld(conn) $qry]
	set ntups [pg_result $res -numTuples]
	for {set i 0} {$i < $ntups} {incr i} {
		lappend data [pg_result $res -getTuple $i]
	} 
	set data
}

proc dbConnect { db } {
	global frm sld
	catch { 
		if { $db == $sld(db) } {
			return 
		}
	}
	catch {pg_disconnect $sld(conn)}
	set sld(conn) [pg_connect $db]
	set sld(db) $db
### prepare class list
	.mb.db.m.class delete 0 end
	foreach i [queryList "select distinct c.relname,c.oid from \
			pg_class c, pg_attribute a \
		where c.relkind = 'r' \
			and a.attnum > 0 \
			and c.relname !~ '^pg_' \
			and a.attrelid = c.oid \
		order by c.oid"] {
		.mb.db.m.class add command -label [lindex $i 0] \
			-command "set sld(class) [lindex $i 0]"
	}
}

proc dbMakeBaseList {} {
	global frm sld base
	if {![info exists sld(conn)]} { return }
	set class ""
	if {[info exists base]} {
		set class $base
	} 
	.mb.db.m.base delete 0 end
	foreach i [queryList "select distinct c.relname,c.oid from \
			pg_class c, pg_attribute a \
		where c.relkind = 'r' \
			and a.attnum > 0 \
			and c.relname !~ '^pg_' \
			and a.attrelid = c.oid \
		order by c.oid"] {
		.mb.db.m.base add radiobutton -label [lindex $i 0] \
			-variable base -value [lindex $i 0]
		if {$class == [lindex $i 0]} {
			.mb.db.m.base invoke end
		}	
	}
}

proc dbMakeDBList {} {
	global sld
	if [info exists sld(conn)] {
		if {$sld(conn) != ""} {
			return
		}
	}
### conecta temporariamente com template1 para ler lista de dbs
	set sld(conn) [pg_connect template1]
	set dblist [queryList "select datname from pg_database \
		where datname !~ 'template1' order by datname"]	
	.mb.db.m.db delete 0 end
	foreach i $dblist {
		.mb.db.m.db add command -label $i -command "dbConnect $i"
	}
}

proc mkAttribList { class lb } {
	$lb delete 0 end
	foreach i [queryList \
		"select a.attname, t.typname, a.attlen, a.oid, c.oid \
		from pg_attribute a, pg_class c, pg_type t \
		where a.attrelid = c.oid \
			and	c.relname = '$class' \
			and a.attnum > 0 \
			and a.atttypid = t.oid \
		order by a.oid"] {
			$lb insert end [lindex $i 0]
	}
}

proc dbCreateRelationship {} {
	global sld frm rel
	set class1 [lindex [.rel.cl.mbl config -text] 4]
	set class2 [lindex [.rel.cl.mbr config -text] 4]
	set rel($class1,$class2) \
		[list [list $class1 [.rel.l get active]] \
			  [list $class2 [.rel.r get active]]]
	pack [label .rel.lst.rel($class1,$class2) \
		-text "$class1.[.rel.l get active] <--> $class2.\
[.rel.r get active]"] -fill x -expand 1
	bind .rel.lst.rel($class1,$class2) <1> "
		unset rel($class1,$class2)
		destroy %W"
}

proc dbNewRelationship {} {
	global base sld frm rel
	if {![info exists base]} { return }
	toplevel .rel
	wm transient .rel .	
	frame .rel.cl
#### implementa uma especie de combobox com os menubuttons
	menubutton .rel.cl.mbl -text "** select **" \
		-menu .rel.cl.mbl.m -indicatoron 1 -relief raised
	menubutton .rel.cl.mbr -text "** select **" \
		-menu .rel.cl.mbr.m -indicatoron 1 -relief raised
	pack .rel.cl.mbl .rel.cl.mbr -side left -expand 1 -fill x
	menu .rel.cl.mbl.m -tearoff 0
	menu .rel.cl.mbr.m -tearoff 0
	listbox .rel.l -selectmode single
	listbox .rel.r -selectmode single
#### povoa os dois menus com lista de classes
	.rel.cl.mbl.m delete 0 end
	.rel.cl.mbr.m delete 0 end
	set classlist [queryList "select distinct c.relname,c.oid from \
			pg_class c, pg_attribute a \
		where c.relkind = 'r' \
			and a.attnum > 0 \
			and c.relname !~ '^pg_' \
			and a.attrelid = c.oid \
		order by c.oid"]
	foreach i $classlist {
		.rel.cl.mbl.m add command -label $i \
			-command ".rel.cl.mbl config -text [lindex $i 0] \
				;mkAttribList [lindex $i 0] .rel.l"
		.rel.cl.mbr.m add command -label $i \
			-command ".rel.cl.mbr config -text [lindex $i 0] \
				;mkAttribList [lindex $i 0] .rel.r"
	}
##### Mostra relacionamentos j existentes
	frame .rel.lst
	foreach r [array names rel] {
		set r1 [lindex $rel($r) 0]
		set r2 [lindex $rel($r) 1]
		set class1 [lindex $r1 0]
		set class2 [lindex $r2 0]
		set att1 [lindex $r1 1]
		set att2 [lindex $r2 1]
		pack [label .rel.lst.rel($class1,$class2) -text \
		"$class1.$att1 <--> $class2.$att2"] -fill x -expand 1
		bind .rel.lst.rel($class1,$class2) <1> "
			unset rel($class1,$class2)
			destroy %W"
	}
##### cria botes de comandos 'make' e 'done'
	frame .rel.bts
	button .rel.bts.make -text make -command dbCreateRelationship
	button .rel.bts.done -text done -command {destroy .rel} 
	pack .rel.bts.make .rel.bts.done \
		-side left -fill x -expand 1
	pack .rel.cl -expand 1 -fill x
	pack .rel.bts .rel.lst -side bottom -fill x
	pack .rel.l -side left
	pack .rel.r -side right 
	centerWindow .rel
	raise .rel
	focus .rel
	grab .rel
}

### executa body foreach widget matching lclass
proc forclass { varName lclass strict body } {
	global frm base errorCode errorInfo
	upvar $varName v
	foreach v [array names frm] {
		if {(($lclass == {}) || ($lclass == $base)) && !$strict \
			|| ($lclass == [lindex $frm($v) 0]) } {
				switch [catch {uplevel $body} str] {
				1 { return -code error -errorinfo $errorInfo \
						-errorcode $errorCode $str }
				2 { return -code return $str }
				3 return
			}
		}
	}
}

### executa body foreach relation present with class
### idx --> class index in classes
### att --> attribute for relationship
### oclass --> other class for the same relation
### oatt --> other class' attribute for this relation

proc forrelation { att oatt oclass class body } {
	global rel frm base errorCode errorInfo
	upvar $att a $oatt o $oclass oc
	foreach r [array names rel] {
		set c1 [lindex $rel($r) 0]
		set c2 [lindex $rel($r) 1]
		if {([lindex $c1 0] == $class) || ([lindex $c2 0] == $class)} {
			if {[lindex $c1 0] == $class} {
				set a [lindex $c1 1]
				set o [lindex $c2 1]
				set oc [lindex $c2 0]
			} else {
				set a [lindex $c2 1]
				set o [lindex $c1 1]
				set oc [lindex $c1 0]
			}  
			switch [catch {uplevel $body} str] {
			1 { return -code error -errorinfo $errorInfo \
					-errorcode $errorCode $str }
			2 { return -code return $str }
			3 return
			}
		}
	}
}

proc centerWindow { w } {
	update idletasks
	set x [expr [winfo rootx .]+[winfo width .]/2-[winfo width $w]/2]
	set y [expr [winfo rooty .]+[winfo height .]/2-[winfo height $w]/2]
	wm geometry $w +$x+$y
}

proc snap { xl yl } {
	global sld
	upvar $xl x
	upvar $yl y
	set x [expr $x + $sld(snap)/2]
	set y [expr $y + $sld(snap)/2]
	set x [expr $x - ($x % $sld(snap))]
	set y [expr $y - ($y % $sld(snap))]
}

proc createNavbar {} {
	global sld
	image create photo bt_play -file $sld(idir)/bt_play.gif 
	image create photo bt_back -file $sld(idir)/bt_back.gif
	image create photo bt_ffw -file $sld(idir)/bt_ffw.gif
	image create photo bt_rew -file $sld(idir)/bt_rew.gif
	toplevel .nb -width 100 -height 30
	frame .nb.top
	button .nb.top.retrieve -font {Helvetica 10 bold} -text retrieve \
		-command dbRetrieve
	button .nb.top.record -font {Helvetica 10 bold} -text record \
		-command dbRecord
	button .nb.top.delete -font {Helvetica 10 bold} -text delete \
		-command dbDelete
	button .nb.top.clean -font {Helvetica 10 bold} -text clean \
		-command dbClean
	pack .nb.top.retrieve .nb.top.record .nb.top.delete .nb.top.clean \
		-side left -expand 1 -fill x
	frame .nb.bot
	button .nb.bot.first -image bt_rew -command dbFirst
	button .nb.bot.previous -image bt_back -command dbPrev
	button .nb.bot.next -image bt_play -command dbNext
	button .nb.bot.last -image bt_ffw -command dbLast
	pack .nb.bot.first .nb.bot.previous .nb.bot.next .nb.bot.last \
		-side left -fill x -expand 1 
	frame .nb.opt
	label .nb.opt.l -text "search by"
	radiobutton .nb.opt.beg -text beginning \
		-variable sld(searchBegin) -value 1
	radiobutton .nb.opt.mid -text middle \
		-variable sld(searchBegin) -value 0
	pack .nb.opt.l .nb.opt.beg .nb.opt.mid -side top -fill x -expand 1 
	pack .nb.opt -side right -fill y -expand 1
	pack .nb.top -side top -fill x -expand 1
	pack .nb.bot -side bottom -fill x -expand 1
	raise .nb
}
