
proc makeWidgets {} {

global sld

#### first set our defaults
set sld(foreground) black
set sld(background) seashell
set sld(fillcolor) gray
set sld(colorlist) {red green blue yellow orange \
	pink violet maroon khaki aquamarine white gray70 gray50 gray30 black}
set sld(idir) $sld(dir)/icons
set sld(group) {}
set sld(groupcnt) g0
set sld(Resizing) 0
set sld(rsizOp) 0
set sld(cursor) left_ptr
set sld(searchBegin) 1

### now load user's defaults, if present
if [file exists ~/.sqlformsrc] {
	source ~/.sqlformsrc	
}

#### creating main window widgets
frame .mb
canvas .c -bg $sld(background) -width 600 -height 600
label .st -relief sunken

menubutton .mb.file -text File -underline 0 -menu .mb.file.m
menubutton .mb.edit -text Edit -underline 0 -menu .mb.edit.m
menubutton .mb.db -text Database -underline 0 -menu .mb.db.m
menubutton .mb.nav -text Navigate -underline 0 -menu .mb.nav.m
menubutton .mb.objects -text Objects -underline 0 -menu .mb.objects.m
menubutton .mb.font -text Font -underline 2 -menu .mb.font.m
menubutton .mb.effects -text Effects -underline 5 -menu .mb.effects.m \
		-state disabled
menubutton .mb.options -text Options -underline 1 -menu .mb.options.m
menubutton .mb.help -text Help -underline 0 -menu .mb.help.m

menu .mb.file.m
.mb.file.m add command -label "New C-n" -underline 0 \
	-command fileNew
.mb.file.m add command -label "Save C-s" -underline 0 \
	-command fileSave
.mb.file.m add command -label "Load C-l" -underline 0 \
	-command fileLoad
.mb.file.m add command -label Export -underline 0 \
	-command fileExport
.mb.file.m add command -label Print -underline 0 \
	-command filePrint
.mb.file.m add separator
.mb.file.m add command -label "Quit C-q" -underline 0 \
	-command "saveConfig; exit"

menu .mb.edit.m
.mb.edit.m add command -label Undo -underline 0 -state disabled
.mb.edit.m add command -label Redo -underline 0 -state disabled
.mb.edit.m add separator
.mb.edit.m add command -label "Paste C-v" -underline 0 \
	-command pasteObject
.mb.edit.m add command -label "Copy C-c" -underline 0 \
	-command copyObject
.mb.edit.m add command -label "Cut C-d" -underline 2 \
	-command cutObject
.mb.edit.m add separator
.mb.edit.m add command -label "bring to Front C-f" -underline 9 \
	-command frontObject
.mb.edit.m add command -label "send to Back C-b" -underline 9 \
	-command backObject
.mb.edit.m add command -label "group objects C-g" -underline 0 \
	-command groupObjects -state disabled
.mb.edit.m add command -label "ungroup objects C-u" \
	-command ungroupObjects -state disabled

menu .mb.db.m
.mb.db.m add cascade -label Database -underline 0 \
	-menu .mb.db.m.db
.mb.db.m add cascade -label "Base class" -underline 0 \
	-menu .mb.db.m.base
.mb.db.m add cascade -label Classes -underline 0 \
	-menu .mb.db.m.class
.mb.db.m add command -label Relationships -underline 0 \
	-command dbNewRelationship
.mb.db.m add cascade -label Queries -underline 0 \
	-menu .mb.db.m.qry
.mb.db.m add command -label Filters -underline 0 \
	-command dbFilters
menu .mb.db.m.db -postcommand dbMakeDBList
menu .mb.db.m.class
menu .mb.db.m.rel
menu .mb.db.m.base -postcommand dbMakeBaseList
menu .mb.db.m.qry -postcommand dbMakeQueryList

menu .mb.nav.m
.mb.nav.m add command -label next -underline 0 \
	-command dbNext
.mb.nav.m add command -label prev -underline 0 \
	-command dbPrev
.mb.nav.m add command -label first -underline 0 \
	-command dbFirst
.mb.nav.m add command -label last -underline 0 \
	-command dbLast
.mb.nav.m add command -label record -underline 0 \
	-command dbRecord
.mb.nav.m add command -label retrieve -underline 1 \
	-command dbRetrieve
.mb.nav.m add command -label delete -underline 0 \
	-command dbDelete 
.mb.nav.m add command -label "clean form" -underline 0 \
	-command dbClean
.mb.nav.m add separator
.mb.nav.m add radiobutton -label "search at beginning" \
	-variable sld(searchBegin) -value 1
.mb.nav.m add radiobutton -label "search at middle" \
	-variable sld(searchBegin) -value 0
.mb.nav.m add separator
.mb.nav.m add command -label "navigation bar" -command createNavbar

menu .mb.objects.m
.mb.objects.m add command -label "no object" -underline 0 \
	-command {doBindings none}
.mb.objects.m add command -label line -underline 0 \
	-command {doBindings line}
.mb.objects.m add command -label frame -underline 0 \
	-command {doBindings frame}
.mb.objects.m add command -label box -underline 2 \
	-command {doBindings box}
.mb.objects.m add command -label text -underline 0 \
	-command {doBindings text}
.mb.objects.m add command -label "boxed text" -underline 2 \
	-command {doBindings btext}
.mb.objects.m add command -label "image" -underline 0 -state disabled
.mb.objects.m add command -label "entry" -underline 4 \
	-command {doBindings entry}
.mb.objects.m add command -label "button" -underline 0 \
	-command {doBindings button}
menu .mb.font.m
set index 0
foreach family $sld(fontfamilies) {
	.mb.font.m add radiobutton -label $family -underline 0 \
		-variable sld(fontfamily) -value $family
	incr index
}
.mb.font.m add separator
.mb.font.m add radiobutton -label 12 -underline 1 \
	-variable sld(fontsize) -value 12
.mb.font.m add radiobutton -label 14 -underline 1 \
	-variable sld(fontsize) -value 14
.mb.font.m add radiobutton -label 18 -underline 1 \
	-variable sld(fontsize) -value 18
.mb.font.m add radiobutton -label 24 \
	-variable sld(fontsize) -value 24
.mb.font.m add radiobutton -label 36 \
	-variable sld(fontsize) -value 36
.mb.font.m add radiobutton -label 48 \
	-variable sld(fontsize) -value 48
.mb.font.m add radiobutton -label 72 \
	-variable sld(fontsize) -value 72
#### set default fontsize and fontfamily (first)
.mb.font.m invoke [expr $index + 5]
.mb.font.m invoke 1

menu .mb.effects.m
menu .mb.options.m
.mb.options.m add command -label palette -underline 0 \
	-command showPalette
.mb.options.m add cascade -label "line width" -underline 5 \
	-menu .mb.options.m.wid
.mb.options.m add cascade -label "snap" -underline 0 \
	-menu .mb.options.m.snap
.mb.options.m add separator
.mb.options.m add radiobutton -label "center text" \
	-variable sld(txtalign) -value center
.mb.options.m add radiobutton -label "right align"\
	-variable sld(txtalign) -value right
.mb.options.m add radiobutton -label "left align" \
	-variable sld(txtalign) -value left
.mb.options.m add separator
.mb.options.m add command -label footer -underline 0 -state disabled
.mb.options.m add command -label background -underline 0 -state disabled
.mb.options.m invoke 5
menu .mb.options.m.snap
.mb.options.m.snap add radiobutton -label "snap 1" \
	-variable sld(snap) -value 1
.mb.options.m.snap add radiobutton -label "snap 2" \
	-variable sld(snap) -value 2
.mb.options.m.snap add radiobutton -label "snap 4" \
	-variable sld(snap) -value 4
.mb.options.m.snap add radiobutton -label "snap 8" \
	-variable sld(snap) -value 8
.mb.options.m.snap add radiobutton -label "snap 16" \
	-variable sld(snap) -value 16
.mb.options.m.snap add radiobutton -label "snap 24" \
	-variable sld(snap) -value 24
.mb.options.m.snap add radiobutton -label "snap 32" \
	-variable sld(snap) -value 32
.mb.options.m.snap add radiobutton -label "snap 48" \
	-variable sld(snap) -value 48
.mb.options.m.snap add radiobutton -label "snap 64" \
	-variable sld(snap) -value 64
.mb.options.m.snap invoke 5

menu .mb.options.m.wid
.mb.options.m.wid add radiobutton -label "width 1" \
	-variable sld(lwidth) -value 1
.mb.options.m.wid add radiobutton -label "width 2" \
	-variable sld(lwidth) -value 2
.mb.options.m.wid add radiobutton -label "width 3" \
	-variable sld(lwidth) -value 3
.mb.options.m.wid add radiobutton -label "width 4" \
	-variable sld(lwidth) -value 4
.mb.options.m.wid add radiobutton -label "width 6" \
	-variable sld(lwidth) -value 6
.mb.options.m.wid add radiobutton -label "width 8" \
	-variable sld(lwidth) -value 8
.mb.options.m.wid add radiobutton -label "width 12" \
	-variable sld(lwidth) -value 12
.mb.options.m.wid invoke 4

menu .mb.help.m
.mb.help.m add command -label About -underline 0 \
	-command {tk_dialog .dlg ""\
"About sqlforms.\n
 This program is \n(C) Copyrighted 1998 \nby Rildo Pragana,\
 but is freely available in GPL terms.\n\
 Suggestion of improvements, inquiries and comments sent to \
 <rpragana@acm.org> are appreciated." "" -1 OK}
.mb.help.m add command -label Contents -underline 0 -state disabled
.mb.help.m add command -label "Canvas editing" -state disabled
.mb.help.m add command -label "Objects" -state disabled
.mb.help.m add command -label "File operations" -state disabled
.mb.help.m add command -label "Customizing fonts and colors" -state disabled
.mb.help.m add command -label "Special effects" -state disabled

label .mb.lb1 -text Class -bg gray90
label .mb.lb2 -relief sunken -textvariable sld(class)

pack .mb.file .mb.edit .mb.db .mb.nav .mb.objects .mb.font \
	.mb.options .mb.effects .mb.lb1 .mb.lb2 -side left
pack .mb.help -side right
pack .mb .c .st -side top -expand yes -fill x

canvasBind 
wm protocol . WM_DELETE_WINDOW "saveConfig; exit"
}
