
proc setbackground {} {
	global sld
	set scolor [tk_chooseColor]
	if [string length $scolor] {
		set sld(background) $scolor
		.c configure -background $scolor
	}
}

proc setforeground {} {
	global sld
	set scolor [tk_chooseColor]
	if [string length $scolor] {
		set sld(foreground) $scolor
	}
}

proc setfillcolor {} {
	global sld
	set scolor [tk_chooseColor]
	if [string length $scolor] {
		set sld(fillcolor) $scolor
	}
}

proc showPalette {} {
	global sld
	toplevel .pal
	wm transient .pal .
	makeColorButtons
	set sld(where) foreground
	frame .pal.f
	radiobutton .pal.f.fore	-text foreground \
		-variable sld(where) -value foreground
	radiobutton .pal.f.back	-text background \
		-variable sld(where) -value background
	radiobutton .pal.f.fill	-text fillcolor \
		-variable sld(where) -value fillcolor
	button .pal.f.cancel -text done -command {destroy .pal}
	frame .pal.b
	label .pal.b.l -text "By name"
	entry .pal.b.e
	button .pal.b.browse -text Browse -command {setColor [tk_chooseColor]}
	pack .pal.b.l -side left
	pack .pal.b.e -expand 1 -fill x -side left
	pack .pal.b.browse -side left
	pack .pal.f.fore .pal.f.back .pal.f.fill .pal.f.cancel -side left
	pack .pal.b .pal.f -side bottom
	.pal.f.fore invoke
	bind .pal.b.e <Return> {setColor [.pal.b.e get]}
	centerWindow .pal
	raise .pal
}

proc deleteColor {pos clr} {
	global sld
	destroy .pal.c.$pos
	set el [lsearch $sld(colorlist) $clr]
	set list1 [lrange $sld(colorlist) 0 [expr $el - 1]]
	set list2 [lrange $sld(colorlist) [expr $el + 1] end]	
	set sld(colorlist) [concat $list1 $list2]
}

proc setColor {clr} {
	global sld
	if "[string length $clr] == 0" { 
		return 
	}
	set sld($sld(where)) $clr
	.c configure -background $sld(background)
	if [expr [lsearch $sld(colorlist) $clr] >= 0] {
	} {
		lappend sld(colorlist) $clr
		makeColorButtons
	}
}

proc makeColorButtons {} {
	global sld
	catch {destroy .pal.c}
	frame .pal.c 
	set pos 0
	foreach clr $sld(colorlist) {
		button .pal.c.$pos -font {Times 8} -bg $clr -width 1 -height 1 \
			-command "setColor $clr"  
		grid .pal.c.$pos -column [expr $pos%10] -row [expr $pos/10]
		bind .pal.c.$pos <2> "deleteColor $pos $clr"
		incr pos
	}
	pack .pal.c -side top
}

