
/* $Id: postgr.h,v 1.3 1997/06/27 00:19:32 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#ifndef POSTGR_H
#define POSTGR_H

#include "string.h"
#include "stdio.h"
extern "C"{
#include <libpq-fe.h>
}

//////////////////////////////////////////////////////////
//       POSTGRES INTERFACE for DBBrowser               //  
//////////////////////////////////////////////////////////

class DBase{
friend class QueryResult;
public:
  enum error_code{
     no_error=0,
     error=1,
     fatal_error=2
  };
private:  
  String table_name;
  Oid * tuple_oids;
  int no_rows;
  int no_cols;
  int no_oids;
  String * field_names;
  Oid * field_types;

  struct TypeParams{
    String name;
    Oid oid;
  };
  TypeParams * types;
  int no_types;
 
  PGconn *conn;
  PGresult *result;
  PGresult *catalogue;
  int status;

  String str2sql(const String &str,Oid type){
    return "'"+str+"'";
  }  

  error_code get_table(const String& query);
  
  error_code begin_transaction();
  error_code declare_cursor(const String& name,const String& query);
  error_code close_cursor(const String& name);
  error_code end_transaction();
  
  String tuple_oid(int no);

  PGresult * send_query(const String& query);
  error_code get_types(); 
public:
  DBase(String dbName);
  ~DBase();
  
  error_code init_table(const String& table);
  int no_fields()const { return no_cols; }
  String field_name(int no){
    return field_names[no];
  }

  int field_no(const String &name){
    for(int i=0;i<no_cols;i++)
      if (field_names[i]==name) return i;
    return -1;  
  }
  Oid field_type(int no){
    if (no>=0) return field_types[no];
    else return 0;
  }
  Oid field_type(const String& name){
    return field_type(field_no(name));
  }
  
  Oid type_id(const String& name){
    for(int i=0;i<no_types;i++)
      if (types[i].name==name) return types[i].oid;
  }
  String type_name(Oid id){
    for(int i=0;i<no_types;i++)
      if (types[i].oid==id) return types[i].name;
  }
  
  error_code get_table(int no_of,const String* f,const String *u);
  error_code search(const String *field_checks,int no_of,
                                             const String* f,const String *u);
  int no_tuples()const { return no_rows; }

  error_code query_tuple(int no);
  String get_value(int col);

  error_code change(int tuple,int field,const String& new_value);
  error_code copy(int tuple){}
  error_code add(String *fields);
  error_code remove(int tuple);
 
  int get_table_catalogue();
  int get_operator_catalogue(Oid result,Oid left,Oid right);
  String read_catalogue(int ind);
  void close_catalogue();

  int ok()const{ return !status; }
};

class QueryResult{
  String query;
  PGresult *res;
  DBase *dbase;
public:
  QueryResult(DBase *db,String q){
    query=q;
    res=db->send_query(q);
    dbase=db;
  }
  ~QueryResult(){
    PQclear(res);
  }
  int error_code(){
    if (!res) return -1;
    else return PQresultStatus(res);
  }
  String error_message(){
    return PQstatus(dbase->conn);
  }
  int error()const{
    if (!res) return 1;
    int stat=PQresultStatus(res);
    if (stat==PGRES_COMMAND_OK || stat==PGRES_TUPLES_OK) return 0;
    return 1;
  }  
  int tuples_got(){
    if (res && PQresultStatus(res)==PGRES_TUPLES_OK) return PQntuples(res);
    return -1;
  }
  int no_fields(){
    if (error()) return -1;
    return PQnfields(res);
  }
  String field_name(int no){
     if (error()) return "";
     return PQfname(res,no);
  }
  String get_value(int row,int col){
    if (error()) return "";
    return PQgetvalue(res,row,col);
  }  
  String status(){
    if (!res) return "";
    return PQcmdStatus(res);
  }
  const String& query_cmd(){
    return query;
  }
};

#endif
