
/* $Id: dbbrowse.cc,v 1.5 1997/06/27 00:33:09 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#include "dbbrowse.h"
#include <iostream.h>
#include <stdlib.h>
#include "postgr.h"
#include "brform.h"

void usage(String name){

  clog<<"Usage: "<<name<<" [options] [dbname] [options]\n"
      <<"\t-debug <level>\tprint xforms debug information\n"
      <<"\t-name <name>\tchange application name\n"
      <<"\t-sync\tsynnchronous mode(debug)\n"
      <<"\t-display <host>:<dpy>\tremote host\n"
      <<"\t-visule <class>\tTrueColor,PseudoColor...\n"
      <<"\t-depth <depth>\tPrefered visual depth\n"
      <<"\t-private\tForce private colormap\n"
      <<"\t-shared\tForce shared colormap\n"
      <<"\t-stdcmap\tForce standard colormap\n"
      <<"\t-double\tEnable double buffering\n"
      <<"\t-bw <width>\tChange border width\n"
      <<"\t-rgamma <gamma>\tRed gamma\n"
      <<"\t-ggamma <gamma>\tGreen gamma\n"
      <<"\t-bgamma <gamma>\tBlue gamma\n";
}

//////////////////////////////////////////////////////////
//           MAIN FUNCTION                             
//////////////////////////////////////////////////////////

int main(int argc,char *argv[]){

  cout<<"DBBrowser ver. 0.9 beta (c) 1997 Jacek Konieczny\n";
  
  fl_initialize(&argc,argv,"DBBrowser",0,0);

  if (argc>2 || (argc==2 && argv[1][0]=='-')){
    usage(argv[0]);
    return 1;
  }  
  String dbname;

  if (argc==2) dbname=argv[1];
  else{
    dbname=getenv("USER");
    if (dbname="") dbname=getenv("LOGNAME");
  }

  if (dbname==""){
    usage(argv[0]);
    return 1;
  }
  
  DBase * dbase=new DBase(dbname);
  if (!dbase->ok()){
    delete dbase;
    return 1;
  }  
  browser_form=new BrowserForm(dbase);
  browser_form->go();
  delete browser_form;
  browser_form=NULL;
  return 0;
}  

