
/* $Id: brform.h,v 1.5 1997/06/27 00:19:31 Jacek Exp $
 *
 * Copyright 1990 Jacek Konieczny
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of Jacek Konieczny not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission. Jacek Konieczny makes no representations about the suitability
 * of this software for any purpose. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Author:	Jacek Konieczny
 *
 *	  email: jajcus@free.polbox.pl
 *                  Currently (June '97) I have very limited Internet
 *                  access so I may sometimes be unavailable this way
 *                  and the address may change in near future.
 *          
 *   snail-mail:
 *
 *		Jacek Konieczny
 *		ul. Kownackiej 2	
 *		44-109 Gliwice
 *		Poland
 */

#ifndef BRFORM_H 
#define BRFORM_H

#include <forms.h>
extern "C"{
#include "form.h"
}

class DBase;

//////////////////////////////////////////////////////////
//           X11 INTERFACE - browser window             //
//////////////////////////////////////////////////////////

class BrowserForm{
  enum file_menu_items{
	MI_QUIT=1
  };
  enum mode_type{
    mode_none,
    mode_browse,
    mode_search,
    mode_query
  }mode;  
  static String file_menu_text;
  FD_browser *form;
  DBase *dbase;
  int field_no;
  int record_no;
  String table;
  String order_by;
  String order_using;
  
  void disable_object(FL_OBJECT *o){
    fl_deactivate_object(o);
    fl_set_object_lcol(o,FL_INACTIVE_COL);
  }
  void enable_object(FL_OBJECT *o){
    fl_activate_object(o);
    fl_set_object_lcol(o,FL_BLACK);
  }
  void set_mode(mode_type m);
  void setup_menus();
  void setup_table_choice();
  void setup_order_by_choices();
  void setup_using_choices();
  void setup_order_by_choice(FL_OBJECT *choice);
  void setup_using_choice(FL_OBJECT *choice,FL_OBJECT *ob_choice);
  void update();
  void full_update();
  void update_sliders();
  void update_fields();
  void do_add();
  void do_add(FL_OBJECT *input,int n);
  void do_change();
  void do_change(FL_OBJECT *input,int n);
  void prepare_browse(String *o,String *u);
  int prepare_search(String *ch);
  static int at_close(FL_FORM *,void *);
public:
  BrowserForm(DBase*dbase);
  ~BrowserForm();
  int go();
  void query_button_callback();
  void browse_button_callback();
  void search_button_callback();
  void delete_button_callback();
  void copy_button_callback();
  void display_button_callback();
  void field_slider_callback(FL_OBJECT * slider);
  void field_callback(FL_OBJECT *input,int no);
  void field_button_callback(int d);
  void record_button_callback(int d);
  void record_slider_callback(FL_OBJECT *slider);
  void table_choice_callback(FL_OBJECT *choice);
  void order_by_choice_callback(FL_OBJECT *choice,int no);
  void using_choice_callback(FL_OBJECT *choice){}
  void file_menu_callback(FL_OBJECT *menu);
};
extern BrowserForm *browser_form;

#endif
