package org.videolan.vlc.databinding;
import org.videolan.vlc.R;
import org.videolan.vlc.BR;
import android.view.View;
public class PlaylistItemBinding extends android.databinding.ViewDataBinding {
    
    private static final android.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = null;
    }
    // views
    public final android.widget.TextView audioItemSubtitle;
    public final android.widget.TextView audioItemTitle;
    public final android.widget.ImageView itemMore;
    public final android.widget.TextView length;
    private final android.widget.RelativeLayout mboundView0;
    // variables
    private java.lang.String mSubTitle;
    private org.videolan.vlc.media.MediaWrapper mMedia;
    private org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder mHolder;
    private int mTitleColor;
    // values
    // listeners
    private OnClickListenerImpl mAndroidViewViewOnCl;
    private OnClickListenerImpl1 mAndroidViewViewOnCl1;
    
    public PlaylistItemBinding(android.databinding.DataBindingComponent bindingComponent, View root) {
        super(bindingComponent, root, 0);
        final Object[] bindings = mapBindings(bindingComponent, root, 5, sIncludes, sViewsWithIds);
        this.audioItemSubtitle = (android.widget.TextView) bindings[2];
        this.audioItemSubtitle.setTag(null);
        this.audioItemTitle = (android.widget.TextView) bindings[1];
        this.audioItemTitle.setTag(null);
        this.itemMore = (android.widget.ImageView) bindings[4];
        this.itemMore.setTag(null);
        this.length = (android.widget.TextView) bindings[3];
        this.length.setTag(null);
        this.mboundView0 = (android.widget.RelativeLayout) bindings[0];
        setRootTag(root);
        invalidateAll();
    }
    
    @Override
    public void invalidateAll() {
        synchronized(this) {
            mDirtyFlags = 0b10000L;
        }
        requestRebind();
    }
    
    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }
    
    public boolean setVariable(int variableId, Object variable) {
        switch(variableId) {
            case BR.subTitle :
                setSubTitle((java.lang.String) variable);
                return true;
            case BR.media :
                setMedia((org.videolan.vlc.media.MediaWrapper) variable);
                return true;
            case BR.holder :
                setHolder((org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder) variable);
                return true;
            case BR.titleColor :
                setTitleColor((int) variable);
                return true;
        }
        return false;
    }
    
    public void setSubTitle(java.lang.String subTitle) {
        this.mSubTitle = subTitle;
        synchronized(this) {
            mDirtyFlags |= 0b1L;
        }
        super.requestRebind();
    }
    public java.lang.String getSubTitle() {
        return mSubTitle;
    }
    public void setMedia(org.videolan.vlc.media.MediaWrapper media) {
        this.mMedia = media;
        synchronized(this) {
            mDirtyFlags |= 0b10L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.media.MediaWrapper getMedia() {
        return mMedia;
    }
    public void setHolder(org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder holder) {
        this.mHolder = holder;
        synchronized(this) {
            mDirtyFlags |= 0b100L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder getHolder() {
        return mHolder;
    }
    public void setTitleColor(int titleColor) {
        this.mTitleColor = titleColor;
        synchronized(this) {
            mDirtyFlags |= 0b1000L;
        }
        super.requestRebind();
    }
    public int getTitleColor() {
        return mTitleColor;
    }
    
    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }
    
    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String subTitle = mSubTitle;
        java.lang.String StringsMillisToStrin = null;
        boolean TextUtilsIsEmptyText = false;
        org.videolan.vlc.media.MediaWrapper media = mMedia;
        org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder holder = mHolder;
        int TextUtilsIsEmptyText1 = 0;
        android.view.View.OnClickListener androidViewViewOnCli = null;
        android.view.View.OnClickListener androidViewViewOnCli1 = null;
        java.lang.String titleMedia = null;
        long lengthMedia = 0L;
        int TextUtilsIsEmptyText2 = 0;
        int titleColor = mTitleColor;
    
        if ((dirtyFlags & 0b10001L) != 0) {
            // read subTitle~
            subTitle = subTitle;
        
            // read TextUtils~~isEmpty~TextUtils~~subTitle~
            TextUtilsIsEmptyText = android.text.TextUtils.isEmpty(subTitle);
            if((dirtyFlags & 0b10001L) != 0) {
                if (TextUtilsIsEmptyText) {
                    dirtyFlags |= 0b1000000L;
                    dirtyFlags |= 0b100000000L;
                } else {
                    dirtyFlags |= 0b100000L;
                    dirtyFlags |= 0b10000000L;
                }}
        
            // read ?:TextUtils~~isEmpty~TextUtils~~subTitle~~GONE~.~View~~VISIBLE~.~View~
            TextUtilsIsEmptyText1 = TextUtilsIsEmptyText ? android.view.View.GONE : android.view.View.VISIBLE;
            // read ?:TextUtils~~isEmpty~TextUtils~~subTitle~~int2~int1
            TextUtilsIsEmptyText2 = TextUtilsIsEmptyText ? 2 : 1;
        }
        if ((dirtyFlags & 0b10010L) != 0) {
            // read media~
            media = media;
        
            if (media != null) {
                // read title~.~media~
                titleMedia = media.getTitle();
                // read length~.~media~
                lengthMedia = media.getLength();
            }
        
            // read Strings~~millisToString~Strings~~length~.~media~
            StringsMillisToStrin = org.videolan.vlc.util.Strings.millisToString(lengthMedia);
        }
        if ((dirtyFlags & 0b10100L) != 0) {
            // read holder~
            holder = holder;
        
            if (holder != null) {
                // read android.view.View.OnClickListener~holder~~onMoreClick
                androidViewViewOnCli = (((mAndroidViewViewOnCl == null) ? (mAndroidViewViewOnCl = new OnClickListenerImpl()) : mAndroidViewViewOnCl).setValue(holder));
                // read android.view.View.OnClickListener~holder~~onClick
                androidViewViewOnCli1 = (((mAndroidViewViewOnCl1 == null) ? (mAndroidViewViewOnCl1 = new OnClickListenerImpl1()) : mAndroidViewViewOnCl1).setValue(holder));
            }
        }
        if ((dirtyFlags & 0b11000L) != 0) {
            // read titleColor~
            titleColor = titleColor;
        }
        // batch finished
        if ((dirtyFlags & 0b10001L) != 0) {
            // api target 1
            this.audioItemSubtitle.setText(subTitle);
            this.audioItemSubtitle.setVisibility(TextUtilsIsEmptyText1);
            this.audioItemTitle.setMaxLines(TextUtilsIsEmptyText2);
        }
        if ((dirtyFlags & 0b10010L) != 0) {
            // api target 1
            this.audioItemTitle.setText(titleMedia);
            this.length.setText(StringsMillisToStrin);
        }
        if ((dirtyFlags & 0b11000L) != 0) {
            // api target 1
            this.audioItemTitle.setTextColor(titleColor);
        }
        if ((dirtyFlags & 0b10100L) != 0) {
            // api target 1
            this.itemMore.setOnClickListener(androidViewViewOnCli);
            this.mboundView0.setOnClickListener(androidViewViewOnCli1);
        }
    }
    // Listener Stub Implementations
    public static class OnClickListenerImpl implements android.view.View.OnClickListener{
        private org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder value;
        public OnClickListenerImpl setValue(org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder value) {
            this.value = value;
            return value == null ? null : this;
        }
        @Override
        public void onClick(android.view.View arg0) {
            this.value.onMoreClick(arg0);
        }
    }
    public static class OnClickListenerImpl1 implements android.view.View.OnClickListener{
        private org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder value;
        public OnClickListenerImpl1 setValue(org.videolan.vlc.gui.audio.PlaylistAdapter.ViewHolder value) {
            this.value = value;
            return value == null ? null : this;
        }
        @Override
        public void onClick(android.view.View arg0) {
            this.value.onClick(arg0);
        }
    }
    // dirty flag
    private  long mDirtyFlags = 0b1111111111111111111111111111111111111111111111111111111111111111L;
    
    public static PlaylistItemBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot) {
        return inflate(inflater, root, attachToRoot, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static PlaylistItemBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot, android.databinding.DataBindingComponent bindingComponent) {
        return android.databinding.DataBindingUtil.<PlaylistItemBinding>inflate(inflater, org.videolan.vlc.R.layout.playlist_item, root, attachToRoot, bindingComponent);
    }
    public static PlaylistItemBinding inflate(android.view.LayoutInflater inflater) {
        return inflate(inflater, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static PlaylistItemBinding inflate(android.view.LayoutInflater inflater, android.databinding.DataBindingComponent bindingComponent) {
        return bind(inflater.inflate(org.videolan.vlc.R.layout.playlist_item, null, false), bindingComponent);
    }
    public static PlaylistItemBinding bind(android.view.View view) {
        return bind(view, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static PlaylistItemBinding bind(android.view.View view, android.databinding.DataBindingComponent bindingComponent) {
        if (!"layout/playlist_item_0".equals(view.getTag())) {
            throw new RuntimeException("view tag isn't correct on view:" + view.getTag());
        }
        return new PlaylistItemBinding(bindingComponent, view);
    }
}
    /* flag mapping
        flag 0: subTitle~
        flag 1: media~
        flag 2: holder~
        flag 3: titleColor~
        flag 4: INVALIDATE ANY
        flag 5: ?:TextUtils~~isEmpty~TextUtils~~subTitle~~GONE~.~View~~VISIBLE~.~View~== false
        flag 6: ?:TextUtils~~isEmpty~TextUtils~~subTitle~~GONE~.~View~~VISIBLE~.~View~== true
        flag 7: ?:TextUtils~~isEmpty~TextUtils~~subTitle~~int2~int1== false
        flag 8: ?:TextUtils~~isEmpty~TextUtils~~subTitle~~int2~int1== true
    flag mapping end*/
    //end