package org.videolan.vlc.databinding;
import org.videolan.vlc.R;
import org.videolan.vlc.BR;
import android.view.View;
public class ExtensionItemViewBinding extends android.databinding.ViewDataBinding {
    
    private static final android.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = null;
    }
    // views
    public final android.widget.TextView author;
    public final android.widget.ImageView image;
    public final android.widget.ImageView itemMore;
    private final android.widget.RelativeLayout mboundView0;
    public final android.widget.TextView title;
    // variables
    private org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder mHolder;
    private android.graphics.drawable.BitmapDrawable mImage;
    private org.videolan.vlc.extensions.api.VLCExtensionItem mItem;
    // values
    // listeners
    private OnClickListenerImpl mAndroidViewViewOnCl;
    
    public ExtensionItemViewBinding(android.databinding.DataBindingComponent bindingComponent, View root) {
        super(bindingComponent, root, 0);
        final Object[] bindings = mapBindings(bindingComponent, root, 5, sIncludes, sViewsWithIds);
        this.author = (android.widget.TextView) bindings[3];
        this.author.setTag(null);
        this.image = (android.widget.ImageView) bindings[1];
        this.image.setTag(null);
        this.itemMore = (android.widget.ImageView) bindings[4];
        this.itemMore.setTag(null);
        this.mboundView0 = (android.widget.RelativeLayout) bindings[0];
        this.title = (android.widget.TextView) bindings[2];
        this.title.setTag(null);
        setRootTag(root);
        invalidateAll();
    }
    
    @Override
    public void invalidateAll() {
        synchronized(this) {
            mDirtyFlags = 0b1000L;
        }
        requestRebind();
    }
    
    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }
    
    public boolean setVariable(int variableId, Object variable) {
        switch(variableId) {
            case BR.holder :
                setHolder((org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder) variable);
                return true;
            case BR.image :
                setImage((android.graphics.drawable.BitmapDrawable) variable);
                return true;
            case BR.item :
                setItem((org.videolan.vlc.extensions.api.VLCExtensionItem) variable);
                return true;
        }
        return false;
    }
    
    public void setHolder(org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder holder) {
        this.mHolder = holder;
        synchronized(this) {
            mDirtyFlags |= 0b1L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder getHolder() {
        return mHolder;
    }
    public void setImage(android.graphics.drawable.BitmapDrawable image) {
        this.mImage = image;
        synchronized(this) {
            mDirtyFlags |= 0b10L;
        }
        super.requestRebind();
    }
    public android.graphics.drawable.BitmapDrawable getImage() {
        return mImage;
    }
    public void setItem(org.videolan.vlc.extensions.api.VLCExtensionItem item) {
        this.mItem = item;
        synchronized(this) {
            mDirtyFlags |= 0b100L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.extensions.api.VLCExtensionItem getItem() {
        return mItem;
    }
    
    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }
    
    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String titleItem = null;
        int typeItem = 0;
        org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder holder = mHolder;
        android.graphics.drawable.BitmapDrawable image = mImage;
        int TypeItemInt0VISIBLEV = 0;
        java.lang.String subTitleItem = null;
        android.view.View.OnClickListener androidViewViewOnCli = null;
        org.videolan.vlc.extensions.api.VLCExtensionItem item = mItem;
        boolean TypeItemInt0 = false;
    
        if ((dirtyFlags & 0b1001L) != 0) {
            // read holder~
            holder = holder;
        
            if (holder != null) {
                // read android.view.View.OnClickListener~holder~~onClick
                androidViewViewOnCli = (((mAndroidViewViewOnCl == null) ? (mAndroidViewViewOnCl = new OnClickListenerImpl()) : mAndroidViewViewOnCl).setValue(holder));
            }
        }
        if ((dirtyFlags & 0b1010L) != 0) {
            // read image~
            image = image;
        }
        if ((dirtyFlags & 0b1100L) != 0) {
            // read item~
            item = item;
        
            if (item != null) {
                // read title~.~item~
                titleItem = item.getTitle();
                // read type~.~item~
                typeItem = item.getType();
                // read subTitle~.~item~
                subTitleItem = item.getSubTitle();
            }
        
            // read !=~type~.~item~~int0
            TypeItemInt0 = typeItem!=0;
            if((dirtyFlags & 0b1100L) != 0) {
                if (TypeItemInt0) {
                    dirtyFlags |= 0b100000L;
                } else {
                    dirtyFlags |= 0b10000L;
                }}
        
            // read ?:!=~type~.~item~~int0~VISIBLE~.~View~~GONE~.~View~
            TypeItemInt0VISIBLEV = TypeItemInt0 ? android.view.View.VISIBLE : android.view.View.GONE;
        }
        // batch finished
        if ((dirtyFlags & 0b1100L) != 0) {
            // api target 1
            this.author.setText(subTitleItem);
            this.itemMore.setVisibility(TypeItemInt0VISIBLEV);
            this.title.setText(titleItem);
        }
        if ((dirtyFlags & 0b1010L) != 0) {
            // api target 1
            android.databinding.adapters.ImageViewBindingAdapter.setImageDrawable(this.image, image);
        }
        if ((dirtyFlags & 0b1001L) != 0) {
            // api target 1
            this.mboundView0.setOnClickListener(androidViewViewOnCli);
        }
    }
    // Listener Stub Implementations
    public static class OnClickListenerImpl implements android.view.View.OnClickListener{
        private org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder value;
        public OnClickListenerImpl setValue(org.videolan.vlc.gui.browser.ExtensionAdapter.ViewHolder value) {
            this.value = value;
            return value == null ? null : this;
        }
        @Override
        public void onClick(android.view.View arg0) {
            this.value.onClick(arg0);
        }
    }
    // dirty flag
    private  long mDirtyFlags = 0b1111111111111111111111111111111111111111111111111111111111111111L;
    
    public static ExtensionItemViewBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot) {
        return inflate(inflater, root, attachToRoot, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static ExtensionItemViewBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot, android.databinding.DataBindingComponent bindingComponent) {
        return android.databinding.DataBindingUtil.<ExtensionItemViewBinding>inflate(inflater, org.videolan.vlc.R.layout.extension_item_view, root, attachToRoot, bindingComponent);
    }
    public static ExtensionItemViewBinding inflate(android.view.LayoutInflater inflater) {
        return inflate(inflater, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static ExtensionItemViewBinding inflate(android.view.LayoutInflater inflater, android.databinding.DataBindingComponent bindingComponent) {
        return bind(inflater.inflate(org.videolan.vlc.R.layout.extension_item_view, null, false), bindingComponent);
    }
    public static ExtensionItemViewBinding bind(android.view.View view) {
        return bind(view, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static ExtensionItemViewBinding bind(android.view.View view, android.databinding.DataBindingComponent bindingComponent) {
        if (!"layout/extension_item_view_0".equals(view.getTag())) {
            throw new RuntimeException("view tag isn't correct on view:" + view.getTag());
        }
        return new ExtensionItemViewBinding(bindingComponent, view);
    }
}
    /* flag mapping
        flag 0: holder~
        flag 1: image~
        flag 2: item~
        flag 3: INVALIDATE ANY
        flag 4: ?:!=~type~.~item~~int0~VISIBLE~.~View~~GONE~.~View~== false
        flag 5: ?:!=~type~.~item~~int0~VISIBLE~.~View~~GONE~.~View~== true
    flag mapping end*/
    //end