package org.videolan.vlc.databinding;
import org.videolan.vlc.R;
import org.videolan.vlc.BR;
import android.view.View;
public class ListItemBinding extends android.databinding.ViewDataBinding {
    
    private static final android.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = null;
    }
    // views
    public final android.widget.ImageView icon;
    public final android.widget.LinearLayout layoutItem;
    public final android.widget.TextView subtitle;
    public final android.widget.TextView title;
    // variables
    private org.videolan.vlc.media.MediaWrapper mMedia;
    private org.videolan.vlc.gui.HistoryAdapter.ViewHolder mHolder;
    // values
    // listeners
    private OnClickListenerImpl mAndroidViewViewOnCl;
    
    public ListItemBinding(android.databinding.DataBindingComponent bindingComponent, View root) {
        super(bindingComponent, root, 0);
        final Object[] bindings = mapBindings(bindingComponent, root, 4, sIncludes, sViewsWithIds);
        this.icon = (android.widget.ImageView) bindings[1];
        this.icon.setTag(null);
        this.layoutItem = (android.widget.LinearLayout) bindings[0];
        this.subtitle = (android.widget.TextView) bindings[3];
        this.subtitle.setTag(null);
        this.title = (android.widget.TextView) bindings[2];
        this.title.setTag(null);
        setRootTag(root);
        invalidateAll();
    }
    
    @Override
    public void invalidateAll() {
        synchronized(this) {
            mDirtyFlags = 0b1000L;
        }
        requestRebind();
    }
    
    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }
    
    public boolean setVariable(int variableId, Object variable) {
        switch(variableId) {
            case BR.media :
                setMedia((org.videolan.vlc.media.MediaWrapper) variable);
                return true;
            case BR.holder :
                setHolder((org.videolan.vlc.gui.HistoryAdapter.ViewHolder) variable);
                return true;
            case BR.position :
                return true;
        }
        return false;
    }
    
    public void setPosition(int position) {
        // not used, ignore
    }
    public int getPosition() {
        return 0;
    }
    public void setMedia(org.videolan.vlc.media.MediaWrapper media) {
        this.mMedia = media;
        synchronized(this) {
            mDirtyFlags |= 0b1L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.media.MediaWrapper getMedia() {
        return mMedia;
    }
    public void setHolder(org.videolan.vlc.gui.HistoryAdapter.ViewHolder holder) {
        this.mHolder = holder;
        synchronized(this) {
            mDirtyFlags |= 0b10L;
        }
        super.requestRebind();
    }
    public org.videolan.vlc.gui.HistoryAdapter.ViewHolder getHolder() {
        return mHolder;
    }
    
    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }
    
    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        org.videolan.vlc.media.MediaWrapper media = mMedia;
        int ArtistMediaObjectnul = 0;
        int typeMedia = 0;
        java.lang.String artistMedia = null;
        org.videolan.vlc.gui.HistoryAdapter.ViewHolder holder = mHolder;
        boolean ArtistMediaObjectnul1 = false;
        android.view.View.OnClickListener androidViewViewOnCli = null;
        java.lang.String titleMedia = null;
        android.graphics.drawable.Drawable TypeMediaTYPEVIDEOMe = null;
        boolean TypeMediaTYPEVIDEOMe1 = false;
    
        if ((dirtyFlags & 0b1001L) != 0) {
            // read media~
            media = media;
        
            if (media != null) {
                // read type~.~media~
                typeMedia = media.getType();
                // read artist~.~media~
                artistMedia = media.getArtist();
                // read title~.~media~
                titleMedia = media.getTitle();
            }
        
            // read ==~type~.~media~~TYPE_VIDEO~.~MediaWrapper~
            TypeMediaTYPEVIDEOMe1 = typeMedia==org.videolan.vlc.media.MediaWrapper.TYPE_VIDEO;
            // read ==~artist~.~media~~Objectnull
            ArtistMediaObjectnul1 = artistMedia==null;
            if((dirtyFlags & 0b1001L) != 0) {
                if (TypeMediaTYPEVIDEOMe1) {
                    dirtyFlags |= 0b10000000L;
                } else {
                    dirtyFlags |= 0b1000000L;
                }}
            if((dirtyFlags & 0b1001L) != 0) {
                if (ArtistMediaObjectnul1) {
                    dirtyFlags |= 0b100000L;
                } else {
                    dirtyFlags |= 0b10000L;
                }}
        
            // read ?:==~type~.~media~~TYPE_VIDEO~.~MediaWrapper~~@android:drawable/ic_browser_video_normal~~@android:drawable/ic_browser_audio_normal~
            TypeMediaTYPEVIDEOMe = TypeMediaTYPEVIDEOMe1 ? getRoot().getResources().getDrawable(R.drawable.ic_browser_video_normal) : getRoot().getResources().getDrawable(R.drawable.ic_browser_audio_normal);
            // read ?:==~artist~.~media~~Objectnull~GONE~.~View~~VISIBLE~.~View~
            ArtistMediaObjectnul = ArtistMediaObjectnul1 ? android.view.View.GONE : android.view.View.VISIBLE;
        }
        if ((dirtyFlags & 0b1010L) != 0) {
            // read holder~
            holder = holder;
        
            if (holder != null) {
                // read android.view.View.OnClickListener~holder~~onClick
                androidViewViewOnCli = (((mAndroidViewViewOnCl == null) ? (mAndroidViewViewOnCl = new OnClickListenerImpl()) : mAndroidViewViewOnCl).setValue(holder));
            }
        }
        // batch finished
        if ((dirtyFlags & 0b1001L) != 0) {
            // api target 1
            android.databinding.adapters.ImageViewBindingAdapter.setImageDrawable(this.icon, TypeMediaTYPEVIDEOMe);
            this.subtitle.setText(artistMedia);
            this.subtitle.setVisibility(ArtistMediaObjectnul);
            this.title.setText(titleMedia);
        }
        if ((dirtyFlags & 0b1010L) != 0) {
            // api target 1
            this.layoutItem.setOnClickListener(androidViewViewOnCli);
        }
    }
    // Listener Stub Implementations
    public static class OnClickListenerImpl implements android.view.View.OnClickListener{
        private org.videolan.vlc.gui.HistoryAdapter.ViewHolder value;
        public OnClickListenerImpl setValue(org.videolan.vlc.gui.HistoryAdapter.ViewHolder value) {
            this.value = value;
            return value == null ? null : this;
        }
        @Override
        public void onClick(android.view.View arg0) {
            this.value.onClick(arg0);
        }
    }
    // dirty flag
    private  long mDirtyFlags = 0b1111111111111111111111111111111111111111111111111111111111111111L;
    
    public static ListItemBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot) {
        return inflate(inflater, root, attachToRoot, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static ListItemBinding inflate(android.view.LayoutInflater inflater, android.view.ViewGroup root, boolean attachToRoot, android.databinding.DataBindingComponent bindingComponent) {
        return android.databinding.DataBindingUtil.<ListItemBinding>inflate(inflater, org.videolan.vlc.R.layout.list_item, root, attachToRoot, bindingComponent);
    }
    public static ListItemBinding inflate(android.view.LayoutInflater inflater) {
        return inflate(inflater, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static ListItemBinding inflate(android.view.LayoutInflater inflater, android.databinding.DataBindingComponent bindingComponent) {
        return bind(inflater.inflate(org.videolan.vlc.R.layout.list_item, null, false), bindingComponent);
    }
    public static ListItemBinding bind(android.view.View view) {
        return bind(view, android.databinding.DataBindingUtil.getDefaultComponent());
    }
    public static ListItemBinding bind(android.view.View view, android.databinding.DataBindingComponent bindingComponent) {
        if (!"layout/list_item_0".equals(view.getTag())) {
            throw new RuntimeException("view tag isn't correct on view:" + view.getTag());
        }
        return new ListItemBinding(bindingComponent, view);
    }
}
    /* flag mapping
        flag 0: media~
        flag 1: holder~
        flag 2: position~
        flag 3: INVALIDATE ANY
        flag 4: ?:==~artist~.~media~~Objectnull~GONE~.~View~~VISIBLE~.~View~== false
        flag 5: ?:==~artist~.~media~~Objectnull~GONE~.~View~~VISIBLE~.~View~== true
        flag 6: ?:==~type~.~media~~TYPE_VIDEO~.~MediaWrapper~~@android:drawable/ic_browser_video_normal~~@android:drawable/ic_browser_audio_normal~== false
        flag 7: ?:==~type~.~media~~TYPE_VIDEO~.~MediaWrapper~~@android:drawable/ic_browser_video_normal~~@android:drawable/ic_browser_audio_normal~== true
    flag mapping end*/
    //end