/*
** AREXX $VER: Start_TeX.mg V1.42 (17.01.1993)
**
** This AREXX script saves and compiles the current MicroGNUEmacs buffer.
** The only (optional) argument is the format to be used. A '?' formatname
** will interactively ask for the format to use.
**
** A command is send to the TeX server to compile the file. Hence a return
** value of 0 does not mean that the file compiled well, but only that the
** command was sent to the server and replied to. 
**
** AUTHOR: J\"org H\"ohle, March 91
**
** BUGS: virtex doesn't like filenames with blanks (and ARexx parses them
**       hardly too), so avoid them in file, directory *and* device names.
**
** FILES: ENV:TEXFORMAT     default format used
*/

Options Results

PORTNAME = 'Start_TeX'
SCRIPT   = 'TeX-server.rexx' /* no path required, message only */

/*
** 1: Ask interactively for the format name
** 0: Don't
*/
If "" = GetClip("TEXQUERY") Then
  ASKFORMAT = 0
ELSE
  ASKFORMAT = 1

Parse Arg FORMAT .
If "?" = FORMAT Then Do
  ASKFORMAT = 1
  FORMAT    = ""
End; Else If '&' = Left(FORMAT,1) Then
  FORMAT = SubStr(FORMAT,2)

'rexx-buffer' BUF
/*
** BUF.2 is the complete filename (beware of spaces)
*/

If "TEX" ~= Upper(Right(BUF.2,3)) Then Do
/*
** More foolproof : use namestruc() to verify extension
*/
  If "LTX" ~= Upper(Right(BUF.2,3)) Then Do
    'rexx-display "Sorry, filename must end in `tex' of `ltx''."'
    Exit 5
  End; Else Do
    If ASKFORMAT = 1 Then
      FORMAT = ""
    Else
      FORMAT = "lplain"
  End
End

'save-buffer'
/*
** Fails if file is write protected
*/

If Show('Port',PORTNAME) Then Do
  ENVFORMAT = MyGetEnv("TEXFORMAT")
  If "" = FORMAT Then Do
    FORMAT = ENVFORMAT
    If ASKFORMAT | "" = ENVFORMAT Then Do
      If "" = FORMAT Then
        FORMAT = 'plain'

      'rexx-request "Which format to use ? (default 'FORMAT') "'
/*
** 0: answered
** 1: default
** 2: abort(^G)
*/
      If 0 = RC Then
        FORMAT = RESULT
      Else If 1 < RC Then Do
        'rexx-display ""'
        Exit 5
      End
    End /* ASKFORMAT */
  End   /* !FORMAT   */

  If FORMAT ~= ENVFORMAT Then
    Call MySetEnv("TEXFORMAT",FORMAT)

  'rexx-display "Calling TeX server 'PORTNAME'."'

/*
** We want to free MG if the TeX server is just busy with another file
*/
  'rexx-unlock'
/*
** We free this MG port and get the name of a new one for later use
*/
  FREEMG = RESULT

  Address Value PORTNAME
  'compile' FORMAT BUF.2

  Address Value FREEMG
  'rexx-display "TeX server called for file 'BUF.2'."'

End; Else Do
/*
** The TeX server must be started first
*/
  'rexx-display "The TeX server 'SCRIPT' is not running !"'
  Exit 5
End

Exit

/*
** When will ARexx supply GetEnv/SetEnv ?
*/
MyGetEnv: Procedure
Parse Arg NAME

If Open(TEMPFILE,"ENV:"||NAME,'r') Then Do
  GIVES = Readln(TEMPFILE)
  Call Close TEMPFILE
End; Else
  GIVES = ""

Return GIVES

MySetEnv: Procedure
Parse Arg NAME,CONTENT

Address COMMAND "SetEnv" NAME CONTENT

Return
