/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   medl_ir.c
   import references form MEDLINE format
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "str_fun.h"
#include "fl_ut.h"
#include "refs.h"
#include "interf.h"
#include "str_refs.h"
#include "medl_ir.h"
#include "ix01_fun.h"

 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];
 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN+1];

 extern char journal_pix_name[PFAD_LEN+1];

 FILE * fptxt;
 static char txt_name[PFAD_LEN + 1];

 FILE * fparr;
 static char arr_name[PFAD_LEN + 1];

 // geaendert 15.8.2003
 // FILE * fpquell;
 static FILE * fpquell;
 
 extern FILE * ix01file;
 
 
 extern char quell_name[PFAD_LEN];
 extern quell_rec one_quell_rec;

 static int alles_ok;

 static char * txtzeile;
 static char * arrzeile;
 static char * ex_zeile;
 static char * exex_zeile;
 static char * exexex_zeile;
 static char * autor_zeile;
 static char * desc_zeile;
 static char * abstract_zeile;

 static int mit_mesh;

 char actual_tag[255];
 char titel_zeile[TITEL_LEN +1];
 char idnr_zeile[IDNR_LEN +1];
 char jahrgang_zeile[JAHRGANG_LEN +1];
 char monat_zeile[MONAT_LEN +1];
 char tag_zeile[TAG_LEN +1];
 char volume_zeile[BAND_LEN +1];
 char issue_nummer_zeile[ISSUE_NUMMER_LEN +1];
 char s_von_zeile[SEITE_VON_LEN + 1];
 char s_bis_zeile[SEITE_BIS_LEN + 1];
 char quellkuerzel_zeile[QUELLKUERZEL_LEN + 1];
 char zeitschrift_zeile_gl[ZEITSCHRIFT_LEN + 1]; /* global */

 static char kennziff[KENNZIFFER_LEN+1];

 /* begin functions */
 static int dateinamen_bestimmen(void);
 static int kennziffer_bestimmen(void);
 static int dateien_oeff(void);
 static int medl_konvertieren(void);
 static int zeitschriften_kennung(
                                 char * kennung, /* 4-Buchstabenkennung */
                                 char * medline_name /* Name in medline */
                                 );
 /* end functions */

#define JOURN_DEL " .-,/;:()[]\t"
   /* Delimiter zum Analysieren der Zeichtschriftennamen */

#define SOURCE_DAT "SOURCE.DAT"

#define LEERTAG "      "
  /* kennzeichnet leeren Zeilenanfang (6 spaces) */

#define AUTAG "AU  - "
  /* kennzeichnet 'author' */

#define TITATAG "TI  - "
  /* kennzeichnet 'title of article' */

#define DPTAG "DP  - "
  /* kennzeichnet das 'date of publication' */

#define VITAG "VI  - "
  /* kennzeichnet das 'volume' */

#define TATAG "TA  - "
  /* kennzeichnet Zeitschrift */

#define PGTAG "PG  - "
  /* kennzeichnet 'pages' */

#define MHTAG "MH  - "
  /* kennzeichnet 'MeSH' */

#define ABTAG "AB  - "
  /* kennzeichnet 'Abstract' */

#define IPTAG "IP  - "
  /* kennzeichnet 'Issue number'*/

#define AIDTAG "AID - "
  /* kennzeichnet 'ID number (article identifier: doi, pii)'*/

#define PMIDTAG "PMID- "
  /* PubMed identifier */

#define ARR_LEN  (size_t) 32000L
// #define ABSTRACT_ZEILE_LEN 30600


int medl_ir_main(void)
{

   if ((txtzeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for txtzeile\n");
       exit(1);
   }
   if ((arrzeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for arrzeile\n");
       exit(1);
   }
   if ((ex_zeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for ex_zeile\n");
       exit(1);
   }
   if ((exex_zeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for exex_zeile\n");
       exit(1);
   }
   if ((exexex_zeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for exex_zeile\n");
       exit(1);
   }
   if ((autor_zeile =  (char *) malloc((AUTORZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for autor_zeile\n");
       exit(1);
   }
   if ((desc_zeile =  (char *) malloc((DESC_ZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for desc_zeile\n");
       exit(1);
   }
   if ((abstract_zeile =  (char *) malloc((ABSTRACT_ZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nERROR: Cannot allocate memory for abstract_zeile\n");
       exit(1);
   }
   strcpy(actual_tag,"");
   strcpy(txtzeile,"");
   strcpy(arrzeile,"");
   strcpy(ex_zeile,"");
   strcpy(exex_zeile,"");
   strcpy(exexex_zeile,"");
   strcpy(autor_zeile,"");
   strcpy(titel_zeile,"");
   strcpy(idnr_zeile,"");
   strcpy(quellkuerzel_zeile,"");
   strcpy(zeitschrift_zeile_gl,"");
   strcpy(jahrgang_zeile,"");
   strcpy(monat_zeile,"");
   strcpy(tag_zeile,"");
   strcpy(volume_zeile,"");
   strcpy(issue_nummer_zeile,"");
   strcpy(s_von_zeile,"");
   strcpy(s_bis_zeile,"");
   strcpy(desc_zeile,"");
   strcpy(abstract_zeile,"");

   alles_ok = 1;
   
   if (dateinamen_bestimmen())
   {
     if (kennziffer_bestimmen())
     {
       if (dateien_oeff())
       {
          static char ein[INPUT_BU_LEN+1];
          int ta, yes_delete;
          wrtxt("\nMenu: Import of MeSH (`keywords') fields [y/n]?\n");
          strcpy(ein,"menu");
          ta = menu_wahl(ein,
            "[y] yes, import MH-fields\n"
            "[n] no, do not import MH-fields");
            
          if (ta==1)
          {
            mit_mesh=1;
          }
          else
          {
            mit_mesh=0;
          }
         medl_konvertieren();
         fclose(fptxt);
         fclose(fparr);
         ein_zeile(ein,"Input file may be deleted, please press [ENTER] to "
           "continue",INPUT_BU_LEN);
         yes_delete = do_delete_yn();
         if (yes_delete==1)
         {
            if(remove(txt_name)==0)
            {
               sprintf(wrtxtbu,"\nFile `%s' successfully deleted\n",txt_name);
               wrtxt(wrtxtbu);
            }
         }
       }
     }
   }

   free(abstract_zeile);
   free(desc_zeile);
   free(autor_zeile);
   free(exexex_zeile);
   free(exex_zeile);
   free(ex_zeile);
   free(arrzeile);
   free(txtzeile);
   return 1;
}


static int dateinamen_bestimmen(void)
{
   char arr_name_kopie[PFAD_LEN + 1]; /* output name */
   char txt_name_kopie[PFAD_LEN + 1]; /* input file name */

   
 
   if (!datei_suchen_mit_pfad("*.txt",textpfad,txt_name))
   {
      wrtxt("\n(aborted)\n");
      return 0;
   }
   strlimcpy(arr_name,textpfad,PFAD_LEN);
   strlimcat(arr_name,one_config_set.form_name,PFAD_LEN);
   strlimcpy(arr_name_kopie,arr_name,PFAD_LEN);
   strlimcpy(txt_name_kopie,txt_name,PFAD_LEN);
   upper(arr_name_kopie); 
   upper(txt_name_kopie);
   if (strcmp(arr_name_kopie,txt_name_kopie)==0)
   {
      wrtxt("\n(Input and output file names must not be identical, aborted)\n");
      return 0;
   }
    
   
   return 1;
}

static int kennziffer_bestimmen(void)
{
   char refnr[KENNZIFFER_LEN+1];

   refspix_rec ix01rec_lokal; 
   long ix01zeiger;
   int ok;
   read_ix01(journal_pix_name);
   fseek(ix01file,0L,SEEK_END);
   if (ftell(ix01file)/sizeof(refspix_rec) >= 1)
   {
     fseek(ix01file,-(long) sizeof(refspix_rec),SEEK_END);
     fread(&ix01rec_lokal,sizeof(refspix_rec),1,ix01file);
     sprintf(wrtxtbu,"New reference number "
       "(preferrably higher than %s)",
       ix01rec_lokal.kennziffer);
   } 
   else
   {
     sprintf(wrtxtbu,"New reference number");
   }
   close_ix01();
   do
   {
     ein_zeile(refnr,wrtxtbu,KENNZIFFER_LEN);
     if (strlen(refnr)==0)
     {
       ok = 1;
     } else
     {
       read_ix01(journal_pix_name);
       ix01zeiger = locate_ix01(refnr,&ix01rec_lokal);
       close_ix01();
       if (ix01zeiger==-1)
       {  
          ok=1;
       }
       else
       {
          wrtxt("\nReference number already in database, please select another "
            "one!\n");
           ok=0;
       }
     }
      
   } while (ok==0);

   if (strlen(refnr)==0)
   {
      strcpy(kennziff,"ChangeMe");
   } else
   {
      strlimcpy(kennziff,refnr,KENNZIFFER_LEN);
   }
   return 1;
}

static int dateien_oeff(void)
{
   if ((fptxt = fopen(txt_name,"rt"))==NULL)
   {
        sprintf(wrtxtbu,"\nERROR: Cannot read %s\n",txt_name);
        wrtxt(wrtxtbu);
        return 0;
   }

   if ((fparr = fopen(arr_name,"wt"))==NULL)
   {
        sprintf(wrtxtbu,"\nERROR: Cannot create %s\n",arr_name);
        wrtxt(wrtxtbu);
        fclose(fptxt);
        return 0;
   }
   return 1;
}

static int medl_konvertieren(void)
{
   int anzahl_namenselem;    /* Elemente Namen */
   int anzahl_namen;          /* Anzahl Autorennamen */
   int anzahl_abstract_zeilen;
   int anzahl_tita_zeilen;
   int anzahl_mesh;


   anzahl_namenselem = 0;
   anzahl_namen = 1;
   anzahl_abstract_zeilen = 1;
   anzahl_tita_zeilen = 1;
   anzahl_mesh = 1;

   while (fgets(txtzeile,ARR_LEN,fptxt)!=NULL)
   {
     strcpy(ex_zeile,"");
     strcpy(exex_zeile,"");
     strcpy(exexex_zeile,"");

     if (strlen(txtzeile) >= ARR_LEN - 1)
     {
         wrtxt("\n(Problem: Line too long)");
         alles_ok = 0;
         return 0;
     }
     rtrim(txtzeile,'\n');
     if (strlen(txtzeile)==0)
     {
        if (
             strlen(autor_zeile) > 0 ||
             strlen(titel_zeile) > 0 ||
             strlen(quellkuerzel_zeile) > 0 ||
             strlen(zeitschrift_zeile_gl) > 0 ||
             strlen(jahrgang_zeile) > 0 ||
             strlen(monat_zeile) > 0 ||
             strlen(tag_zeile) > 0 ||
             strlen(volume_zeile) > 0 ||
             strlen(issue_nummer_zeile) > 0 ||
             strlen(s_von_zeile) > 0 ||
             strlen(s_bis_zeile) > 0 ||
             strlen(desc_zeile) > 0 ||
             strlen(abstract_zeile) > 0
           )
        {
           /* ... first empty line following the data */
           break;
        }
        else
        {
           /* ... leading empty lines are ignored */
           continue;
        }
        /* changed on 13.01.2000 */
        /* break; */
     }

     /* Bei diesen Feldern sind Folgezeilen moeglich */
     if (!strcmp(actual_tag,TITATAG) ||
         !strcmp(actual_tag,ABTAG))
     {
        if (locate_substring(LEERTAG,txtzeile) < 0)
        {
           strcpy(actual_tag,"");
        }
     }

     if (locate_substring(AUTAG,txtzeile)==0)
     {
        int i;
        strcpy(actual_tag,AUTAG);
        if (anzahl_namen >= MAX_N_AUTHORS)
        {
          continue;
        }
        extract_subs(ex_zeile,txtzeile,strlen(AUTAG),AUTORZEILE_LEN);
        anzahl_namenselem = countitem(ex_zeile," ");
        if (anzahl_namenselem < 2)
        {
            strlimcat(autor_zeile,"?,?\n",AUTORZEILE_LEN);
        }

        else
        {
           for (i=1;i<anzahl_namenselem;i++)
           {
             extractitem(i,ex_zeile," ",exex_zeile);
             strlimcat(exexex_zeile,exex_zeile,AUTORZEILE_LEN);
             strlimcat(exexex_zeile," ",AUTORZEILE_LEN);
           }
           rtrim(exexex_zeile,' ');
           exexex_zeile[AUNAME_LEN]='\0';
           if (strlen(exex_zeile) > 0)
           strlimcat(autor_zeile,exexex_zeile,AUTORZEILE_LEN);
           strlimcat(autor_zeile,",",AUTORZEILE_LEN);
              /* Nachname eingetragen */

           strcpy(exex_zeile,"");
           strcpy(exexex_zeile,"");

           extractitem(anzahl_namenselem,ex_zeile," ",exex_zeile);
           exex_zeile[AUVORNAMEN_LEN]='\0';
           strlimcat(autor_zeile,exex_zeile,AUTORZEILE_LEN);
           strlimcat(autor_zeile,"\n",AUTORZEILE_LEN);
        }
        anzahl_namen++;
     }
     if (
         (locate_substring(TITATAG,txtzeile)==0)||   /* erste Zeile? */
         (locate_substring(LEERTAG,txtzeile)==0 &&   /* Folgezeile im TITA */
          !strcmp(actual_tag,TITATAG))
        )
     {
        strcpy(actual_tag,TITATAG);
        extract_subs(ex_zeile,txtzeile,strlen(TITATAG),TITEL_LEN);
        trim(ex_zeile,' ');
        strlimcat(titel_zeile,ex_zeile,TITEL_LEN);
        strlimcat(titel_zeile," ",TITEL_LEN);
        anzahl_tita_zeilen++;
     }
     if (locate_substring(DPTAG,txtzeile)==0)
     {
        strcpy(actual_tag,DPTAG);
        extract_subs(ex_zeile,txtzeile,strlen(DPTAG),ARR_LEN);
        extractitem(1,ex_zeile," -/.:",exex_zeile);
        exex_zeile[JAHRGANG_LEN]='\0';
        strlimcpy(jahrgang_zeile,exex_zeile,JAHRGANG_LEN);
        sprintf(wrtxtbu,"\n(YEAR of publication converted)");
        wrtxt(wrtxtbu);
        if (countitem(ex_zeile," -/.:")>=2)
        {
           extractitem(2,ex_zeile," -/.:",exex_zeile);
           upper(exex_zeile);
           if (!strcmp(exex_zeile,"JAN")) strcpy(monat_zeile,"1");
           else if (!strcmp(exex_zeile,"FEB")) strcpy(monat_zeile,"2");
           else if (!strcmp(exex_zeile,"MAR")) strcpy(monat_zeile,"3");
           else if (!strcmp(exex_zeile,"APR")) strcpy(monat_zeile,"4");
           else if (!strcmp(exex_zeile,"MAY")) strcpy(monat_zeile,"5");
           else if (!strcmp(exex_zeile,"JUN")) strcpy(monat_zeile,"6");
           else if (!strcmp(exex_zeile,"JUL")) strcpy(monat_zeile,"7");
           else if (!strcmp(exex_zeile,"AUG")) strcpy(monat_zeile,"8");
           else if (!strcmp(exex_zeile,"SEP")) strcpy(monat_zeile,"9");
           else if (!strcmp(exex_zeile,"OCT")) strcpy(monat_zeile,"10");
           else if (!strcmp(exex_zeile,"NOV")) strcpy(monat_zeile,"11");
           else if (!strcmp(exex_zeile,"DEC")) strcpy(monat_zeile,"12");
           else strcpy(monat_zeile,"");
        }
        if (strlen(monat_zeile)>0)
        {
          sprintf(wrtxtbu,"\n(Date of publication: MONTH converted)");
          wrtxt(wrtxtbu);
        }
        if (countitem(ex_zeile," -/.:")>=3)
        {
           extractitem(3,ex_zeile," -/.:",exex_zeile);
           exex_zeile[TAG_LEN]='\0';
           if ( /*
                 *  I must admit, not extremely elegant ...
                 *
                 *  This construct avoids that in dates fields as
                 *  `DP  - 1999 Nov-Dec' `11' is (correctly) entered into
                 *  the MONP--field and `De' into the `DAYP' field.
                 */
                strcmp(exex_zeile,"1")==0 ||
                strcmp(exex_zeile,"01")==0 ||
                strcmp(exex_zeile,"2")==0 ||
                strcmp(exex_zeile,"02")==0 ||
                strcmp(exex_zeile,"3")==0 ||
                strcmp(exex_zeile,"03")==0 ||
                strcmp(exex_zeile,"4")==0 ||
                strcmp(exex_zeile,"04")==0 ||
                strcmp(exex_zeile,"5")==0 ||
                strcmp(exex_zeile,"05")==0 ||
                strcmp(exex_zeile,"6")==0 ||
                strcmp(exex_zeile,"06")==0 ||
                strcmp(exex_zeile,"7")==0 ||
                strcmp(exex_zeile,"07")==0 ||
                strcmp(exex_zeile,"8")==0 ||
                strcmp(exex_zeile,"08")==0 ||
                strcmp(exex_zeile,"9")==0 ||
                strcmp(exex_zeile,"09")==0 ||
                strcmp(exex_zeile,"10")==0 ||
                strcmp(exex_zeile,"11")==0 ||
                strcmp(exex_zeile,"12")==0 ||
                strcmp(exex_zeile,"13")==0 ||
                strcmp(exex_zeile,"14")==0 ||
                strcmp(exex_zeile,"15")==0 ||
                strcmp(exex_zeile,"16")==0 ||
                strcmp(exex_zeile,"17")==0 ||
                strcmp(exex_zeile,"18")==0 ||
                strcmp(exex_zeile,"19")==0 ||
                strcmp(exex_zeile,"20")==0 ||
                strcmp(exex_zeile,"21")==0 ||
                strcmp(exex_zeile,"22")==0 ||
                strcmp(exex_zeile,"23")==0 ||
                strcmp(exex_zeile,"24")==0 ||
                strcmp(exex_zeile,"25")==0 ||
                strcmp(exex_zeile,"26")==0 ||
                strcmp(exex_zeile,"27")==0 ||
                strcmp(exex_zeile,"28")==0 ||
                strcmp(exex_zeile,"29")==0 ||
                strcmp(exex_zeile,"30")==0 ||
                strcmp(exex_zeile,"31")==0
              )
           {
              strlimcpy(tag_zeile,exex_zeile,TAG_LEN);
           }
        }
        if (strlen(tag_zeile)>0)
        {
          sprintf(wrtxtbu,"\n(Date of publication: DAY converted)");
          wrtxt(wrtxtbu);
        }
     }
     if (locate_substring(VITAG,txtzeile)==0)
     {
        strcpy(actual_tag,VITAG);
        extract_subs(ex_zeile,txtzeile,strlen(VITAG),ARR_LEN);
        ex_zeile[BAND_LEN]='\0';
        strlimcpy(volume_zeile,ex_zeile,BAND_LEN);
        sprintf(wrtxtbu,"\n(VOLUME IDENTIFIER converted)");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(PMIDTAG,txtzeile)==0)
     {
        strcpy(actual_tag,PMIDTAG);
        extract_subs(ex_zeile,txtzeile,strlen(PMIDTAG),ARR_LEN);
        ex_zeile[IDNR_LEN]='\0';
        if (strlen(idnr_zeile) > 0)
        {
           strlimcat(idnr_zeile," ",IDNR_LEN);
        }
        strlimcat(idnr_zeile,"pmid:",IDNR_LEN);
        strlimcat(idnr_zeile,ex_zeile,IDNR_LEN);
        sprintf(wrtxtbu,"\n(PUBMED IDENTIFIER converted)");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(AIDTAG,txtzeile)==0)
     {
        int doipos;
        strcpy(actual_tag,AIDTAG);
        extract_subs(ex_zeile,txtzeile,strlen(AIDTAG),ARR_LEN);
        ex_zeile[IDNR_LEN]='\0';
        if ((doipos=locate_substring("[doi]",ex_zeile)) > 0)
        {
          extract_subs(exex_zeile,ex_zeile,0,doipos-1);
          if (strlen(idnr_zeile) > 0)
          {
             strlimcat(idnr_zeile," ",IDNR_LEN);
          }
          strlimcat(idnr_zeile,"doi:",IDNR_LEN);
          strlimcat(idnr_zeile,exex_zeile,IDNR_LEN);
          sprintf(wrtxtbu,"\n(DOI converted)");
          wrtxt(wrtxtbu);
        }
     }
     if (locate_substring(AIDTAG,txtzeile)==0)
     {
        int piipos;
        strcpy(actual_tag,AIDTAG);
        extract_subs(ex_zeile,txtzeile,strlen(AIDTAG),ARR_LEN);
        ex_zeile[IDNR_LEN]='\0';
        if ((piipos=locate_substring("[pii]",ex_zeile)) > 0)
        {
          extract_subs(exex_zeile,ex_zeile,0,piipos-1);
          if (strlen(idnr_zeile) > 0)
          {
             strlimcat(idnr_zeile," ",IDNR_LEN);
          }
          strlimcat(idnr_zeile,"pii:",IDNR_LEN);
          strlimcat(idnr_zeile,exex_zeile,IDNR_LEN);
          sprintf(wrtxtbu,"\n(PII converted)");
          wrtxt(wrtxtbu);
        }
     }
     if (locate_substring(IPTAG,txtzeile)==0)
     {
        strcpy(actual_tag,IPTAG);
        extract_subs(ex_zeile,txtzeile,strlen(IPTAG),ARR_LEN);
        ex_zeile[ISSUE_NUMMER_LEN]='\0';
        strlimcpy(issue_nummer_zeile,ex_zeile,ISSUE_NUMMER_LEN);
        sprintf(wrtxtbu,"\n(ISSUE NUMBER converted)");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(TATAG,txtzeile)==0)
     {
        strcpy(actual_tag,TATAG);
        extract_subs(ex_zeile,txtzeile,strlen(TATAG),ARR_LEN);
        zeitschriften_kennung(quellkuerzel_zeile,ex_zeile);
        strlimcpy(zeitschrift_zeile_gl,ex_zeile,ZEITSCHRIFT_LEN);
     }

     if (locate_substring(PGTAG,txtzeile)==0)
     {
        strcpy(actual_tag,PGTAG);
        extract_subs(ex_zeile,txtzeile,strlen(PGTAG),ARR_LEN);
        extractitem(1,ex_zeile," -",exex_zeile);
        exex_zeile[SEITE_VON_LEN]='\0';
        strlimcpy(s_von_zeile,exex_zeile,SEITE_VON_LEN);
        strcpy(exex_zeile,"");
        extractitem(2,ex_zeile," -",exex_zeile);

        seitenziffern_komplettieren(s_von_zeile,exex_zeile,exexex_zeile);
        exexex_zeile[SEITE_BIS_LEN]='\0';
        strlimcpy(s_bis_zeile,exexex_zeile,SEITE_BIS_LEN);
        sprintf(wrtxtbu,"\n(PAGE NUMBER(S) converted)");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(MHTAG,txtzeile)==0)
     {
        strcpy(actual_tag,MHTAG);
        extract_subs(ex_zeile,txtzeile,strlen(MHTAG),ARR_LEN);
        trim(ex_zeile,' ');
        trim(ex_zeile,',');
        strlimcat(desc_zeile,ex_zeile,DESC_ZEILE_LEN);
        strlimcat(desc_zeile,"\n",DESC_ZEILE_LEN);
        anzahl_mesh++;
     }
     if (
         (locate_substring(ABTAG,txtzeile)==0)||     /* erste Zeile? */
         (locate_substring(LEERTAG,txtzeile)==0 &&   /* Folgezeile im ABST */
          !strcmp(actual_tag,ABTAG))
        )
     {
        strcpy(actual_tag,ABTAG);
        strlimcpy(ex_zeile,txtzeile,ARR_LEN);
        rtrim(ex_zeile,' ');
        strlimcat(abstract_zeile,ex_zeile,ABSTRACT_ZEILE_LEN);
        strlimcat(abstract_zeile,"\n",ABSTRACT_ZEILE_LEN);
        anzahl_abstract_zeilen++;
     }
   } /* while (fgets(.. */

   if (mit_mesh==0)
   {
      strcpy(desc_zeile,"");
      anzahl_mesh=1;
   }
   sprintf(wrtxtbu,"\n(%i AUTHOR NAMES converted)",anzahl_namen-1);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\n(%i lines for TITLE OF ARTICLE converted)",
      anzahl_tita_zeilen-1);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\n(Short form for JOURNAL NAME "
             "[%s]: `%s')",zeitschrift_zeile_gl,quellkuerzel_zeile);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\n(MeSH: %i items written into KEYWORDS field)",
      anzahl_mesh-1);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\n(%i lines of ABSTRACT converted)",
      anzahl_abstract_zeilen-1);
   wrtxt(wrtxtbu);

   sprintf(wrtxtbu,"\n");
   wrtxt(wrtxtbu);
   fprintf(fparr,"%sREFERENCE-NUMBER-[width:%i]\n",one_config_set.form_label,KENNZIFFER_LEN);
   fprintf(fparr,"%s\n",kennziff);
   fprintf(fparr,"%sDOCUMENT-TYPE-[width:%i]\n",one_config_set.form_label,REFTYP_LEN);
   fprintf(fparr,"%s\n","j1");
   fprintf(fparr,"%sAUTHORS-[width:%i,%i]\n",
     one_config_set.form_label, AUNAME_LEN,AUVORNAMEN_LEN);
   rtrim(autor_zeile,'\n');
   if (strlen(autor_zeile)==0)
   {
      strcpy(autor_zeile,"?,?");
   }
   fprintf(fparr,"%s\n",autor_zeile);
   rtrim(titel_zeile,' ');
   rtrim(titel_zeile,'.');
   wwrap(titel_zeile,EDITING_LINE_LEN);
   fprintf(fparr,"%sTITLE-ARTICLE-[width:%iw]\n%s\n",
     one_config_set.form_label,TITEL_LEN,titel_zeile);

   fprintf(fparr,"%sJOURNAL-[width:%i]\n%s\n",
       one_config_set.form_label,KUERZEL_LEN,quellkuerzel_zeile);

   fprintf(fparr,"%sIDNR-[width:%i]\n%s\n",
       one_config_set.form_label,IDNR_LEN,idnr_zeile);

   fprintf(fparr,"%sDATE-YEAR-[width:%i;num]\n%s\n",
       one_config_set.form_label,JAHRGANG_LEN,jahrgang_zeile);

   fprintf(fparr,"%sDATE-MONTH-[width:%i;num:1..12]\n%s\n",
       one_config_set.form_label,MONAT_LEN,monat_zeile);

   fprintf(fparr,"%sDATE-DAY-[width:%i;num:1..31]\n%s\n",
       one_config_set.form_label,TAG_LEN,tag_zeile);
   
   fprintf(fparr,"%sVOLUME-[width:%i]\n%s\n",
       one_config_set.form_label,BAND_LEN,volume_zeile);
   
   fprintf(fparr,"%sISSUE-NUMBER-[width:%i]\n%s\n",
       one_config_set.form_label,ISSUE_NUMMER_LEN,issue_nummer_zeile);

   fprintf(fparr,"%sFIRST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_VON_LEN,s_von_zeile);

   fprintf(fparr,"%sLAST-PAGE-[width:%i]\n%s\n",
       one_config_set.form_label,SEITE_BIS_LEN,s_bis_zeile);
   
   fprintf(fparr,"%sSTATUS-[width:%i]\n%s\n",
       one_config_set.form_label,STATUS_LEN,"");
   trim(desc_zeile,'\n');
   if (strlen(desc_zeile)==0)
   {
      strcpy(desc_zeile,"no MeSH in MEDLINE format");
   }
   fprintf(fparr,"%sKEYWORDS-[width:%i]\n%s\n",
       one_config_set.form_label,KEYWORDS_LEN,desc_zeile);
   fprintf(fparr,"%sK-NUMBER-[width:%i]\n\n",
       one_config_set.form_label,KEYWORDS_NUMBER_LEN);
   fprintf(fparr,"%sABSTRACT-[width:%iw]\n",
       one_config_set.form_label,ABSTRACT_ZEILE_LEN);
   fprintf(fparr,"%s",abstract_zeile);
   fprintf(fparr,"\n%sEND-OF-RECORD\n",one_config_set.form_label);

   sprintf(wrtxtbu,"\nFile `%s' processed\n",txt_name);
   wrtxt(wrtxtbu);

   wrtxt("\n(Conversion completed)\n");
   sprintf(wrtxtbu,MEDLINE_INFO_1,arr_name);
   wrtxt(wrtxtbu);
   return 1;
}

static int zeitschriften_kennung(
                                 char * kennung, /* 4-Buchstabenkennung */
                                 char * medline_name /* Name in medline */
                                 )
{
   char zeitschrift[ZEITSCHRIFT_LEN + 2];
   char medline_zeitschrift[ZEITSCHRIFT_LEN + 2];
   char kurz_zeitschrift[KURZFORM_LEN + 2];
   long anzahl_records, i;
   int j, anzahl_woerter;


   strcpy(kennung,"j1");
   strcpy(zeitschrift,"");
   strcpy(medline_zeitschrift,"");
   strcpy(kurz_zeitschrift,"");
   if (filesize(quell_name) < sizeof(one_quell_rec))
   {
       strcpy(kennung,"j1");
       return 0;
   }
   if ((fpquell = fopen(quell_name,"rb"))==NULL)
   {
       strcpy(kennung,"j1");
       return 0;
   }

   anzahl_woerter=countitem(medline_name,JOURN_DEL);
   for (j=1;j<=anzahl_woerter;j++)
   {
       extractitem(j,medline_name,JOURN_DEL,exex_zeile);
       strlimcat(medline_zeitschrift,exex_zeile,ZEITSCHRIFT_LEN);
       strlimcat(medline_zeitschrift," ",ZEITSCHRIFT_LEN);
   }
   rtrim(medline_zeitschrift,' ');
   upper(medline_zeitschrift);

   fseek(fpquell,0L,SEEK_END);
   anzahl_records = ftell(fpquell) / sizeof(one_quell_rec) - 1;
   rewind(fpquell);
   for (i=0;i<=anzahl_records;i++)
   {
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
       if (one_quell_rec.in_use_quell==0)
       {
         continue;
       }
       trim(one_quell_rec.quell_zeitschrift,' ');
       if (strlen(one_quell_rec.quell_zeitschrift) > 0)
       {
         strcpy(zeitschrift,"");
         anzahl_woerter=countitem(one_quell_rec.quell_zeitschrift,JOURN_DEL);
         for (j=1;j<=anzahl_woerter;j++)
         {
             extractitem(j,one_quell_rec.quell_zeitschrift,JOURN_DEL,exex_zeile);
             strlimcat(zeitschrift,exex_zeile,ZEITSCHRIFT_LEN);
             strlimcat(zeitschrift," ",ZEITSCHRIFT_LEN);
         }
         rtrim(zeitschrift,' ');
         upper(zeitschrift);
         if (!strcmp(zeitschrift,medline_zeitschrift))
         {
            strlimcpy(kennung,one_quell_rec.quell_kuerzel,QUELLKUERZEL_LEN);
            break;
         }
       }
       if (strlen(one_quell_rec.quell_kurzform) > 0)
       {
         strcpy(kurz_zeitschrift,"");
         anzahl_woerter=countitem(one_quell_rec.quell_kurzform,JOURN_DEL);
         for (j=1;j<=anzahl_woerter;j++)
         {
             extractitem(j,one_quell_rec.quell_kurzform,JOURN_DEL,exex_zeile);
             strlimcat(kurz_zeitschrift,exex_zeile,KURZFORM_LEN);
             strlimcat(kurz_zeitschrift," ",KURZFORM_LEN);
         }
         rtrim(kurz_zeitschrift,' ');
         upper(kurz_zeitschrift);
         if (!strcmp(kurz_zeitschrift,medline_zeitschrift))
         {
            strlimcpy(kennung,one_quell_rec.quell_kuerzel,QUELLKUERZEL_LEN);
            break;
         }
       }
   }
   fclose(fpquell);
   return 1;
}

