/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/* etext.c Shell for text editor */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>

#include "etext.h"
#include "refs.h"
#include "interf.h"
#include "rglobal.h"
#include "fl_ut.h"
#include "initial.h"
#include "str_fun.h"
#include "interf.h"
#include "file_mg.h"


 extern FILE * dir_kat;

 int textmenu(void);
 int scriptmenu(void);
 int systemmenu(void);
 

int main(int argc, char * argv[])
{
  signal(SIGINT,SIG_IGN);
  /* initialize global variables, including pathnames */
  initialisieren();
  cfg_datei_lesen();
  weiter_initialisieren(); 
  /* 
   * (the initialization in `weiter_initialisieren' requires 
   * that cfg_datei_lesen() has been executed) 
   */
  if (argc > 1)
  {
     if (!strcmp(argv[1],"-h") || !strcmp(argv[1],"--help"))
     {
        wrtxt("\nUsage: etext [-option|--long-option]\n"
              "\n"
              "-h --help             print this help screen\n"
              "-v --version          print version and compilation time\n"
              "-d --debug            print paths and file names"
              "\n");
#ifdef REFS_USES_LINUXGCC
        wrtxt("\n");
#endif
        return 0;
     }
     if (!strcmp(argv[1],"-v") || !strcmp(argv[1],"--version"))
     {
        sprintf(wrtxtbu,"\nEtext for References v%s, compiled %s, %s\n",
          REFS_SUB_VERSION,__DATE__,__TIME__);
        wrtxt(wrtxtbu);
#ifdef REFS_USES_LINUXGCC
        wrtxt("\n");
#endif
        return 0;
     }
     if (!strcmp(argv[1],"-d") || !strcmp(argv[1],"--debug"))
     {
        dateien_und_pfade_anzeigen();
#ifdef REFS_USES_LINUXGCC
        wrtxt("\n");
#endif
        return 0;
     }
  }
  textmenu();
  wrtxt("\n(Etext closed)\n");
#ifdef REFS_USES_LINUXGCC
  wrtxt("\n");
#endif
  return 0;
}

int textmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option, option_confirm;
  static char kommando[PFAD_LEN + 1];
 
  strcpy(ein,"menu");
  option = 0;
  option_confirm = 0;
  while (option_confirm!=1)
  {
    sprintf(wrtxtbu,"\nEtext v%s main menu: edit/process text files "
      "[r/s/k/j/3/m/t/v/p/f/h/a/q]\n",REFS_VERSION);
    wrtxt(wrtxtbu);
    sprintf(wrtxtbu,
      "[r] references form\n" /*1*/
      "[s] search command form\n" /*2*/
      "[k] keywords thesaurus form\n" /*3*/
      "[j] journal data form\n" /*4*/
      "[3] three forms: r+k+j\n" /*5*/
      "[m] more text files\n" /*6*/
      "[t] type text file name\n" /*7*/
      "[v] view text file\n" /* 8 */
      "[p] process text files\n" /*9*/
      "[f] file and system functions\n" /*10*/
      "[h] help, References documentation\n" /* 11 */
      "[a] about References\n" /*12*/
      "[q] quit"); /*13*/
    option = menu_wahl(ein,wrtxtbu);
    if (option==1) /* [r] */
    {
       textdatei_editieren(one_config_set.form_name);
       strcpy(ein,"menu");
    }
    if (option==2) /* [s] */
    {
       textdatei_editieren(one_config_set.search_form_name);
       strcpy(ein,"menu");
    }
    if (option==3) /* [k] */
    {
       textdatei_editieren(one_config_set.ky_form_name);
       strcpy(ein,"menu");
    }
    if (option==4) /* [j] */
    {
       textdatei_editieren(one_config_set.jn_form_name);
       strcpy(ein,"menu");
    }
    if (option==5) /* [e] */
    {
       drei_textdateien_editieren(one_config_set.form_name,
                                  one_config_set.ky_form_name,
                                  one_config_set.jn_form_name);
       strcpy(ein,"menu");
    }
    if (option==6) /* [m] */
    {
       char textdatei_name[PFAD_LEN + 1];
       
       if (datei_suchen_mit_pfad("*",textpfad,textdatei_name))
       {
         textdatei_editieren(textdatei_name);
       }
       else
       {
          wrtxt("\nNo valid file name selected\n");
          anhalten();
       }
       strcpy(ein,"menu");
    }
    if (option==7) /* [t]*/
    {
       char textdatei_name[PFAD_LEN + 1];
       int name_ok;
       name_ok = 0;
       while (!name_ok)
       {
          ein_zeile(textdatei_name,"Please type text file name",PFAD_LEN);
          if ((name_ok = isvalidfilename2(textdatei_name)) == 0)
          {
            if (strlen(textdatei_name)==0)
            {
               wrtxt("\n(No text file selected)\n");
               break;
            }
            wrtxt("\nThis is not a valid filename!\n");
          }
       }
       if (strlen(textdatei_name)==0)
       {
          strcpy(ein,"menu");
          continue;   
       }
       
       if (!isfile(textdatei_name))
       {
          textdatei_anlegen(textdatei_name);
       }
       textdatei_editieren(textdatei_name);
       strcpy(ein,"menu");

    }

    if (option==8) /* [v] */
    {
       char textdatei_name[PFAD_LEN + 1];
       if (datei_suchen_mit_pfad("*",textpfad,textdatei_name))
       {
         vtxt(textdatei_name,"");
       }
       strcpy(ein,"menu");
    }
    if (option==9) /* [p] */
    {
       scriptmenu();
       strcpy(ein,"menu");
    }
    if (option==10) /* [f] */
    {
       systemmenu();
       strcpy(ein,"menu");
    }
    if (option==11) /* [h] */
    {
      strlimcpy(kommando,one_config_set.pdf_viewer,PFAD_LEN);
      strlimcat(kommando," ",PFAD_LEN);
      strlimcat(kommando,one_config_set.help_file,PFAD_LEN);
      system(kommando);
      anhalten();
      strcpy(ein,"menu");
    }
    if (option==12) /* [a] */
    {
      wrtxt(VERSION_INFO);
      anhalten();
      dateien_und_pfade_anzeigen();
      strcpy(ein,"menu");
    }
    if (option==13) /* [q] */
    {
      strcpy(ein,"menu");
      wrtxt("\nConfirm to quit etext [yes/no]\n");
      option_confirm = menu_wahl(ein,
        "[yes] yes, quit etext\n"
        "[ no] no, continue to run etext"
        );
      strcpy(ein,"menu");
    }
  }
  return 1;
}

int scriptmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
  static char kommando[PFAD_LEN + 1];
  static char dateiname[PFAD_LEN + 1];
 
  strcpy(ein,"menu");
  option = 0;
  while (option < 13)
  {
    sprintf(wrtxtbu,"\nMenu: process text files "
      "[htm/ltx/exc/xex/srt/wdm/osw/vi/msr/rsr/exa/snc/q]\n");
    wrtxt(wrtxtbu);
    option = menu_wahl(ein,
      "[htm] convert list of references text file to HTML-file \n" /* 1 */
      "[ltx] convert list of references text file to LaTeX-file \n" /* 2 */
      "[exc] excite: extract \\cite{} arguments from LaTeX text files \n" /* 3 */
      "[xex] extended excite: extract arguments of \\cite{}-equivalents \n" /* 4 */
      "[srt] process sorting macro with the sortrefs command\n" /* 5 */
      "[wdm] citations search-and-replace macro for MS Word\n" /* 6 */
      "[osw] citations search-and-replace macro for OOOrg/StarOffice writer\n" /* 7 */
      "[ vi] citations search-and-replace script for vi/vim/gvim\n" /* 8 */
      "[msr] manual search-and-replace citations list for textprocessors\n" /* 9 */
      "[rsr] References search-and-replace script for citations\n" /* 10 */
      "[exa] extract reference numbers from arr-file\n" /* 11 */
      "[snc] sort groups of numeric citations\n" /* 12 */
      "[  q] quit" /* 13 */ 
      );
    if (option==1) /* [htm] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `reflist.html', "
          "extension `.html' will be appended)"))
       {
          strlimcpy(ausgabedatei,"reflist",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".html",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"txt2html.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==2) /* [ltx] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `reflist.tex', "
          "extension `.tex' will be appended)"))
       {
          strlimcpy(ausgabedatei,"reflist",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".tex",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"txt2ltx.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==3) /* [exc] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `rcite.tbt', "
          "extension `.tbt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"rcite",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".tbt",PFAD_LEN);
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"excite.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.tex",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==4) /* [xex] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `rcite.tbt', "
          "extension `.tbt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"rcite",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".tbt",PFAD_LEN);
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"xexcite.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.tex",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==5) /* [srt] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `sorted.tbt', "
          "extension `.tbt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"sorted",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".tbt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"sortrefs.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==6) /* [wdm] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `msw-mak.txt', "
          "extension `.txt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"msw-mak",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".txt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"msw_sr.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt(ETEXT_MSW_SR);
         // wrtxt("(completed, to proceed:\n\n"
         //       "   1. load the macro into the text editor with [ENTER] at next prompt,\n"
         //       "   2. copy macro to the clipboard, \n"
         //       "   3. paste it into the macro editor of OOOrg/StarOffice writer\n"
         //       "   4. execute (run) the macro)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==7) /* [osw] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `ooo-mak.txt', "
          "extension `.txt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"ooo-mak",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".txt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"ooo_sr.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       /* strlimcat(kommando,"ooo_xsr.awk ",PFAD_LEN); */
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         // wrtxt("(completed, to proceed:\n\n"
         //       "   1. load the macro into the text editor with [ENTER] at next prompt,\n"
         //       "   2. copy macro to the clipboard, \n"
         //       "   3. paste it into the macro editor of OOOrg/StarOffice writer\n"
         //       "   4. execute (run) the macro)\n");
         wrtxt(ETEXT_OSW_SR);
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==8) /* [ vi] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `vi-mak.txt', "
          "extension `.txt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"vi-mak",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".txt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"vi_sr.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==9) /* [msr] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `msrl-mak.txt', "
          "extension `.txt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"msrl-mak",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".txt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"man_srl.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==10) /* [rsr] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `rc-mak.sr', "
          "extension `.sr' will be appended)"))
       {
          strlimcpy(ausgabedatei,"rc-mak",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".sr",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"refs_sr.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
         load_file_yn(ausgabedatei);
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==11) /* [exa] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `ex_arr.tbt', "
          "extension `.txt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"ex_arr",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".tbt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"ex_arr.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.arr",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed)\n");
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
    if (option==12) /* [snc] */
    {
       static char ausgabedatei[PFAD_LEN+1];
       if (!dateivornamen_holen(ausgabedatei,"Output file (default `numgr.txt', "
          "extension `.txt' will be appended)"))
       {
          strlimcpy(ausgabedatei,"numgr",PFAD_LEN);
       }
       strlimcat(ausgabedatei,".txt",PFAD_LEN);
       
       strlimcpy(kommando,one_config_set.awk_name,PFAD_LEN);
       strlimcat(kommando," -f ",PFAD_LEN);
       strlimcat(kommando,one_config_set.path_to_scripts,PFAD_LEN);
       strlimcat(kommando,"group-num-cit.awk ",PFAD_LEN);
       strlimcat(kommando,"-v output_file=",PFAD_LEN);
       strlimcat(kommando,ausgabedatei,PFAD_LEN);
       strlimcat(kommando," ",PFAD_LEN);
       if (datei_suchen(textpfad,"*.txt",dateiname))
       {
         strlimcat(kommando,dateiname,PFAD_LEN);
         system(kommando);
         wrtxt("(completed, process this raw macro with [edit-main-p wdm]\n"
               "   or with [edit-main-p osw])\n");
       } else
       {
         wrtxt("\nNo file selected\n");
       }
       strcpy(ein,"menu");
    }
  }
  return 1;

}

int systemmenu(void)
{
  static char ein[INPUT_BU_LEN+1];
  int option;
  strcpy(ein,"menu");
  option = 0;
  while (option < 5)
  {
    sprintf(wrtxtbu,"\nMenu: file and system functions [f/e/s/c/q]\n");
    wrtxt(wrtxtbu);
    sprintf(wrtxtbu,
      "[f] file manager: delete, rename, duplicate files\n"     /* 1 */
      "[e] select an alternative text editor\n"                 /* 2 */
      "[s] shell command\n"                                     /* 3 */
      "[c] edit configuration file\n"                           /* 4 */
      "[q] quit");                                              /* 5 */
    option = menu_wahl(ein,wrtxtbu);
    if (option==1) /* [f] */
    {
       file_managermenu();
       strcpy(ein,"menu");
    }
    if (option==2) /* [s] */
    {
       static char alternativer_editor[INPUT_BU_LEN+1];

       wrtxt("\nCurrent text editor is `");
       wrtxt(one_config_set.editor_name);
       wrtxt("'\n");
       ein_zeile(alternativer_editor,
         "Please enter the name of an alternative text editor",
         INPUT_BU_LEN);
         if (strlen(alternativer_editor) > 0)
         {
            strlimcpy(one_config_set.editor_name,alternativer_editor,
              PFAD_LEN);
            wrtxt("\nNew text editor is `");
            wrtxt(one_config_set.editor_name);
            wrtxt("'\n");
              
         }
           
       strcpy(ein,"menu");
    }
    if (option==3) /* [s] */
    {
       shell_ausfuehren();
       strcpy(ein,"menu");
    }
    if (option==4) /* [c] */
    {
       char kmdo[PFAD_LEN+1];
       strlimcpy(kmdo,one_config_set.editor_name,PFAD_LEN);
       strlimcat(kmdo," ",PFAD_LEN);
       strlimcat(kmdo,cfg_name,PFAD_LEN);
       system(kmdo);
       anhalten();
       wrtxt("\nChanges become effective after the next program start\n");
       strcpy(ein,"menu");
    }
   
  }
  return 1;
}
