
/*
 *    Copyright 1986, 1987 Pat Joseph Monardo. All rights reserved.
 *    Copying of this file is granted according to the provisions 
 *    specified in the file COPYING which must accompany this file.
 */


/*
 *		str.c
 */

#include "tex.h"
#include "io.h"
#include "file.h"
#include "error.h"
#include "str.h"

ascii 	str_pool[POOL_SIZE];
ptr		pool_ptr;
ptr		str_start[MAX_STRINGS];
str		str_ptr;
str		null_str;

bool
str_eq_buf (s, k)
	str		s;
	int		k;
{
	int		j;
	
	j = str_start[s];
	while (j < str_start[s + 1]) {
		if (str_pool[j] != buffer[k])
			return FALSE;
		incr(j); incr(k);
	}
	return TRUE;
}

bool
str_eq_str (s, t)
	str		s;
	str		t;
{
	int		j;
	int		k;

	if (length(s) != length(t))
		return FALSE;
	j = str_start[s];
	k = str_start[t];
	while (j < str_start[s + 1]) {
		if (str_pool[j] != str_pool[k])
			return FALSE;
		incr(j); incr(k);
	}
	return TRUE;
}

str
make_string ()
{
	incr(str_ptr);
	if (str_ptr == MAX_STRINGS)
		overflow("number of strings", MAX_STRINGS);
	str_start[str_ptr] = pool_ptr;
	return (str_ptr - 1);
}

str
make_string_given (s)
	char* 	s;
{
	while (*s != NUL) {
		append_char(*s);
		incr(s);
	}
	return (make_string());
}

init_strings ()
{
	int 	k;

	str_ptr = pool_ptr = 0;
	for (k = 0; k <= 127; incr(k)) {
		if (k < ' ') {
			append_char('^');
			append_char('^');
			append_char(k + 0100);
		} else if (k == 127)
			make_string_given("^^?");
		else append_char(k);
		make_string();
	}
	null_str = make_string();
}
