		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	zoom_bpl_sh0
		XREF	zoom_bpl_0
		XREF	zoom_bpl_1
		XREF	zoom_bpl_2
		XREF	zoom_bpl_3
		XREF	zoom_bpl_4
		XREF	zoom_bpl_5
		XREF	zoom_bpl_6
		XREF	zoom_bpl_7
		XREF	zoom_bpl_8
		XREF	zoom_bpl_sh1

		XREF	zoom_multable
		XREF	zoom_coltable1
		XREF	zoom_coltable2
		XREF	zoom_tempbpl
		XREF	zoom_palette

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	whitepal
		XREF	blackpal

		XREF	salir

		XDEF	zoom_main

		incdir	'include:'

		IFND	WASIMACROS
		include	'macros2.i'
		ENDC
	
		include	'hardware/custom.i'
		include	'hardware/blit.i'
		include	'hardware/dmabits.i'

		incdir	'zoom_procfill'

		section	zoom,code


RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm


zoom_main
		RESET_SPRITES	c_zoom_spr
		bsr	zoom_setup
		bsr	zoom_makepal

		move.l	#c_zoom_pal,fader_copper
		move.w	#255,fader_colors
		jsr	fader_makecopper

		move.l	#blackpal,fader_original
		move.l	#zoom_palette,fader_target
		move.w	#6,fader_steps
		jsr	fader_initcrossfade

		move.l	#c_zoom,$dff080

.loop		lea	zoom_bpl_draw(pc),a0
		move.l	(a0),d0
		rept	8
		move.l	4(a0),(a0)+
		endr
		move.l	d0,(a0)

		move.l	zoom_distance(pc),d0
		cmp.l	#1360*4,d0
		bgt.b	.skip

		tst	.nomore(pc)
		bne.b	.skip

		move.l	#zoom_palette,fader_original
		move.l	#whitepal,fader_target
		move.w	#6,fader_steps
		jsr	fader_initcrossfade
		st	.nomore
		bra.b	.skip

.nomore		dc.w	0
.skip		wrast	255
		jsr	fader_setpalette

		move.l	#c_zoom_bpls,a0
		lea	zoom_bpl_show(pc),a1
		move.w	#7,d7
.cop		move.l	(a1)+,d0
		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		addq.l	#8,a0
		dbra	d7,.cop

		bsr	zoom_move
		bsr	zoom_draw


		tst.l	salir
		bne	.salzoom
		cmp.w	#5,p61_pos
		blt	.loop	

		;btst	#6,$bfe001
		;bne	.loop

.salzoom
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

logo		incbin	'raw.biglogo'

zoom_distance	dc.l	$4000
zoom_speed	dc.l	-85

zoom_bpl_draw	dc.l	zoom_bpl_8
zoom_bpl_show	dc.l	zoom_bpl_0
		dc.l	zoom_bpl_1
		dc.l	zoom_bpl_2
		dc.l	zoom_bpl_3
		dc.l	zoom_bpl_4
		dc.l	zoom_bpl_5
		dc.l	zoom_bpl_6
		dc.l	zoom_bpl_7

zoom_makepal	lea	zoom_palette,a0
		lea	zoom_refpal,a1
		moveq.l	#0,d0
		move.w	#$1,d1

		move.w	#255,d7

.loop		moveq.l	#0,d4
		move.w	d0,d2

		rept	8
		add.b	d2,d2
		subx.b	d3,d3
		and.b	d1,d3
		add.b	d3,d4
		endr

		cmp.w	#8,d4
		blt.b	.no
		move.w	#7,d4
.no		move.l	(a1,d4.w*4),(a0)+

		addq.l	#1,d0
		dbra	d7,.loop
		rts

zoom_refpal	incbin	'pal.zoom'

zoom_setup	lea	zoom_coltable1+(5120*4),a0
		lea	logo,a1

		moveq.l	#0,d6
		move.w	#1919,d7
.setup0		move.l	a1,-(a0)
		dbra	d7,.setup0

		move.w	#1279,d7
.setup1		move.l	a1,-(a0)
		move.w	(a1)+,d0
		lea	(a1,d0.w*2),a1
		dbra	d7,.setup1

		lea	logo,a1
		moveq.l	#0,d6
		move.w	#1919,d7
.setup2		move.l	a1,-(a0)
		dbra	d7,.setup2

		move.l	#$4000,zoom_distance
		rts

zoom_move	lea	zoom_distance(pc),a0
		movem.l	(a0),d0/d1

		add.l	d1,d0
		cmp.w	#$10,d0
		bgt.b	.ok1
		moveq.l	#1,d0
		clr.l	d1

.ok1		movem.l	d0/d1,(a0)
		rts

zoom_draw	moveq.l	#0,d2

		move.l	#$10000000,d1
		divs.l	zoom_distance(pc),d1

		move.l	d1,d0
		muls.l	#-128,d0
		asr.l	#1,d1
		addx.l	d2,d1

		add.l	#$1<<15,d0
		swap	d0
		swap	d1

		lea	zoom_multable,a0
		move.w	#511,d7

.setup1		move.w	d0,d6

		cmp.w	#-128,d6
		bgt.b	.ok1
		move.w	#-128,d6

.ok1		cmp.w	#127,d6
		blt.b	.ok2
		move.w	#127,d6

.ok2		add.w	#128,d6
		mulu.w	#40,d6
		move.w	d6,(a0)+

		add.l	d1,d0
		addx.w	d2,d0
		dbra	d7,.setup1

		lea	zoom_coltable1+(2560*4),a0
		lea	zoom_coltable2,a1

		move.l	zoom_distance(pc),d1
		asl.l	#6,d1

		move.l	d1,d0
		muls.l	#-160,d0

		add.l	#$1<<15,d0
		swap	d0
		swap	d1

		move.w	#319,d7
.setup2		move.l	(a0,d0.w*4),a2
		move.l	a2,(a1)+

		addx.l	d1,d0
		addx.l	d2,d0
		dbra	d7,.setup2

		lea	zoom_tempbpl,a6
		moveq.l	#0,d0
		move.w	#255,d7
.clrloop
		rept	10
		move.l	d0,(a6)+
		endr
		dbra	d7,.clrloop

		lea	zoom_coltable2,a0
		lea	zoom_multable,a1
		lea	zoom_p10,a3

		lea	zoom_tempbpl,a6
		lea	40(a6),a6

		move.w	#(320/16)-1,d7
wordloop	moveq.l	#1,d0
		subq.l	#2,a6

bitloop		move.l	(a0)+,a2
		move.w	(a2)+,d1
		move.l	(a3,d1.w*4),a5
		jmp	(a5)

		rept	20
		move.w	(a2)+,d1
		move.w	(a1,d1.w),d1
		eor.w	d0,(a6,d1.w)
		endr

pixel		add.w	d0,d0
		bne	bitloop
		dbra	d7,wordloop

zoom_fill	lea	zoom_tempbpl,a6
		lea	40(a6),a5
		move.l	zoom_bpl_draw,a0

		move.w	#255,d7
.loop
		rept	10
		move.l	(a6)+,d0
		move.l	(a5),d1
		eor.l	d0,d1
		move.l	d1,(a5)+
		move.l	d1,(a0)+
		endr
		dbra	d7,.loop
		rts

a set 0
zoom_p10
	rept	20
	dc.l	pixel-a
a set a+10
	endr

	section	data_c,data_c

	cnop	0,8
c_zoom
	dc.w	$1fc,$000f
	dc.w	$08e,$2881
	dc.w	$090,$28c1
	dc.w	$092,4*14
	dc.w	$094,4*44

	dc.w	$108,0
	dc.w	$10a,0

	dc.w	$100,$0210
	dc.w	$102,$0000
	dc.w	$104,$0000
	dc.w	$106,$0000

;	dc.w	$180,$474
;	dc.w	$182,$8c8
;c_zoom_pal
;	ds.b	2112

c_zoom_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

sprite	set	$120
c_zoom_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

	dc.w	$180,$474
	dc.w	$182,$8c8


	dc.w	$1007,$fffe
	dc.w	$106,$0000
c_zoom_pal
	ds.b	2112

	dc.l	-2,-2		

	cnop	0,16
spr_off	ds.l	8
