


		machine	68030
		
		opt	l+,c-

		XREF	water_shit0
		XREF	water_chunky1
		XREF	water_chunky2
		XREF	chk_waterhei_0
		XREF	chk_waterhei_1
		XREF	water_shit1
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2

		XREF	lv3_vblank
		XREF	lv3_blit
		XREF	lv3_copper

		XREF	salir
	
		XREF	P61_Pos
		XREF	P61_CRow

		XDEF	water_main

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		section	water3d,code

wid		set	160
hei		set	128-32
dens		set	2


water_main	move.l	#c_water,$dff080

.loop1		move.w	#$555,$dff180
.ll		cmp.b	#255,$dff006
		bne.b	.ll
		move.w	#$000,$dff180

		jsr	c2p_cpu
		jsr	water_dbuffer
		bsr	water_paintbrush
		bsr	water_diff
		bsr	water_clearscreen
		bsr	water_draw

		;btst	#6,$bfe001
		;bne.b	.loop1

		tst.l	salir
		bne	.salwater3d
		cmp.w	#28,P61_Pos
		bne	.loop1
.salwater3d	rts

water_paintbrush
		addq.w	#1,water_timing
		move.w	water_timing,d0
		and.w	#127,d0
		cmp.w	#63,d0
		ble.b	.do
		rts
.do		move.l	water_hei_visible,a0
		lea	brush1,a1

		move.w	#64,d5
		move.w	#hei-1,d7
.yloop		moveq.l	#9,d6
.xloop		move.w	(a1)+,d0

		rept	16
		add.w	d0,d0
		subx.w	d1,d1
		and.w	d5,d1
		add.w	d1,(a0)+
		endr

		dbra	d6,.xloop
		dbra	d7,.yloop
		rts

		cnop	0,16
brush1		incbin	'bpl.brush'

water_diff	move.l	water_hei_hidden,a0
		move.l	water_hei_visible,a1

		moveq.l	#dens,d6
		
		move.w	#(hei*20)-1,d7
.xyloop
	rept	8

	move.w	320(a0),d0
	add.w	-320(a0),d0
	add.w	2(a0),d0
	add.w	-2(a0),d0

	asr.w	#1,d0
	sub.w	(a1),d0

	addq.l	#2,a0

	move.w	d0,d1
	asr.w	d6,d1		; density value
	sub.w	d1,d0

	move.w	d0,(a1)+
		
	endr

	dbra	d7,.xyloop

;	sub.l	#320,a1			; copyback from down to top
;	move.l	water_hei_visible(pc),a0
;	rept	160/2
;	move.l	(a1)+,(a0)+
;	endr
;	rept	160/2			; and from top to down
;	move.l	(a0)+,(a1)+
;	endr
	rts

water_timing	dc.w	0
water_xpos	dc.w	0
water_ypos	dc.w	0
water_random	dc.b	'sanity  '

water_clearscreen
		move.l	c2p__chunky,a6
		move.l	#160*hei,d7
		add.l	d7,a6

		sub.l	d0,d0
		sub.l	d1,d1
		sub.l	d2,d2
		sub.l	d3,d3
		sub.l	d4,d4
		sub.l	a0,a0
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4

		move.w	#((160*hei)/(32*4*10))-1,d7
.loop
		rept	32
		movem.l	d0-d4/a0-a4,-(a6)
		endr
		dbra	d7,.loop
		rts

water_draw	move.l	c2p__chunky,a0
		move.l	water_hei_visible,a1

		add.l	#160*(hei-1),a0

		move.l	#320,a3
		move.l	#160,a2

		move.w	#159,d7
.xloop		swap	d7
		movem.l	a0/a1,-(sp)

		move.w	#$ff,d6
		move.w	#hei,d5
		move.w	#hei,d4

		move.w	#(hei/4)-1,d7
.yloop

wv		macro
		move.w	(a1),d0
		asr.w	#3,d0
		add.w	d5,d0
		move.w	d4,d1
		sub.w	d0,d1
		bls.b	.nopaint\@

		move.w	d0,d4
		bra.b	.ploope\@
.ploop\@	move.b	d6,(a0)
		sub.l	a2,a0
.ploope\@	dbra	d1,.ploop\@

.nopaint\@	add.l	a3,a1
		endm

		wv
		subq.w	#2,d6
		subq.w	#1,d5
		wv
		subq.w	#3,d6
		subq.w	#1,d5
		wv
		subq.w	#2,d6
		subq.w	#1,d5
		wv
		subq.w	#3,d6
		dbra	d7,.yloop

		movem.l	(sp)+,a0/a1
		addq.l	#2,a1
		addq.l	#1,a0
		swap	d7
		dbra	d7,.xloop
		rts


water_dbuffer	lea	water_hei_hidden,a0
		move.l	a0,a1

		move.l	(a0)+,d1
		move.l	(a0)+,d0
		move.l	d0,(a1)+
		move.l	d1,(a1)+
		rts

water_hei_hidden	dc.l	chk_waterhei_1
water_hei_visible	dc.l	chk_waterhei_0

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	lea	$dff000,a6
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	move.l	c2p__chunky(pc),a6
	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4

	move.l	a7,c2p_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	water_chunky1
c2p__chunky_	dc.l	water_chunky2

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

	cnop	0,16
c2p_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	c2p_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	lea	$dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_2,lv3_blit
	rts

c2p_blit_2	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_3,lv3_blit
	rts

c2p_blit_3	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_4,lv3_blit
	rts

c2p_blit_4	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_5,lv3_blit
	rts

c2p_blit_5	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_6,lv3_blit
	rts

c2p_blit_6	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_7,lv3_blit
	rts

c2p_blit_7	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#6*plsize,a1

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_8,lv3_blit
	rts

c2p_blit_8	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#7*plsize,a1

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_end,lv3_blit
	rts

c2p_blit_end	clr.l	c2p_proceed
	clr.l	lv3_blit

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d1
	move.l	d1,(a0)+
	move.l	d0,(a0)+

	move.l	d0,newplanes
	addq.l	#1,timing_frame2
	rts

c2p_dbuff	lea	c2p__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	c2p__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	0

swap_screens	move.l	newplanes(pc),d0

	lea	c_water_bpls,a0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#plsize,d0
	addq.l	#8,a0
	dbra	d7,.sloop

	addq.l	#1,timing_frame1
	rts

test_speed	move.l	c2p__chunky(pc),a0
	move.l	timing_frame1(pc),d0
	move.l	timing_frame2(pc),d1

	tst.l	d0
	beq.b	.no

	mulu.w	#wid,d1
	divs.l	d0,d1
	move.l	d1,timing_speed

	moveq.l	#0,d2

	move.l	a0,a1
	move.w	#(wid*8/16)-1,d7
.clrloop	move.l	d0,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	dbra	d7,.clrloop

	add.l	d1,a0
	add.l	#wid*2,a0

	move.w	#3,d7
.loop	movem.l	a0-a4,(a0)
	add.l	#wid,a0
	dbra	d7,.loop

.no	rts

timing_frame1	dc.l	0
timing_frame2	dc.l	0
timing_speed	dc.l	0

	section	data_c,data_c

	cnop	0,64
c_water	dc.w	$1fc,$4007
	dc.w	$100,$0201

	dc.w	$08e,$0082|(($118-2*hei)<<8)
	dc.w	$090,$18C1		* DIWindow Size YX
	dc.w	$092,$0038
	dc.w	$094,$00D0-(4*8)	* DDFetch

	incbin	'pal.water'

	dc.w	$100,$0201|$0010
	dc.w	$102,$0010
	dc.w	$104,$0200
	dc.w	$106,$0000

	dc.w	$108,-40
	dc.w	$10a,0

c_water_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

	dc.w	$fe8f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

