		;machine	68030
		
		opt	debug,l+,c-,p=68030

		XREF	water3d_chunky1
		XREF	water3d_chunky2
		XREF	chk_water3dhei_0
		XREF	chk_water3dhei_1
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	planes1
		XREF	planes2

		XREF	lv3_vblank
		XREF	lv3_blit
		XREF	lv3_copper

		XREF	fader_original
		XREF	fader_target
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_makecopper
		XREF	fader_initcrossfade
		XREF	fader_setpalette

		XREF	blackpal

		XREF	salir
	
		XREF	P61_Pos
		XREF	P61_CRow

		XDEF	water3d_main

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		incdir	'water3d'

		section	water3d,code

RESET_SPRITES MACRO	;\1=copperlist sprite label
		lea	\1,a0
		moveq.l	#7,d0
		move.w	#$0120,d1
		move.l	#spr_off,d2
.spr_count\@
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		dbf	d0,.spr_count\@
		ENDM

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wid		set	160
hei		set	128-32
dens		set	6


water3d_main
		RESET_SPRITES	c_water_spr

		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		move.l	#((8*40*256)/(32*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		;sub.l	a4,a4
		;sub.l	a5,a5
.chiploop2
		rept	16
		movem.l	d1-d7/a3,-(a0)
		movem.l	d1-d7/a3,-(a1)
		endr
		dbf	d0,.chiploop2

		lea	c_water_bpls,a0
		move.l	#planes2,d0
		moveq.l	#7,d7
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#320*256/8,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		move.l	#c_water,$dff080

		move.l	#c_water_pal,fader_copper
		move.l	#blackpal,fader_original
		move.l	#water_pal,fader_target
		move.w	#7,fader_steps
		move.w	#255,fader_colors

		jsr	fader_makecopper
		jsr	fader_initcrossfade
		move.l	#water_vblank,lv3_vblank

.loop1		;move.w	#$555,$dff180
.ll		cmp.b	#255,$dff006
		bne.b	.ll
		;move.w	#$000,$dff180

		jsr	c2p_cpu
		jsr	water_dbuffer

		cmp.w	#129,water_time
		blt.b	.no1
		bsr	water_paintbrush

.no1		bsr	water_diff
		bsr	water_clearscreen
		bsr	water_draw

		tst.l	salir
		bne	.salwater3d
		cmp.w	#25,P61_Pos
		bne	.loop1
.salwater3d
		bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

water_hei	dc.w	12
water_time	dc.w	0

water_pal	incbin	'pal.water'
water_vblank	jsr	swap_screens
		cmp.w	#24,p61_pos
		blt	.nofade
		cmp.w	#32,p61_crow
		bne	.nofade
		move.l	#c_water_pal,fader_copper
		move.l	#water_pal,fader_original
		move.l	#blackpal,fader_target
		move.w	#7,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
.nofade		jsr	fader_setpalette
		addq.w	#1,water_time
		rts

water_paintbrush
		move.w	water_time,d0
		move.w	d0,d1
		sub.w	#128,d1
		cmp.w	#128,d1
		bcs.b	dobrush1

		move.w	d0,d1
		sub.w	#128+512,d1
		cmp.w	#128,d1
		bcs.b	dobrush2

		movem.l	water_random(pc),d0-d1
		add.l	d0,d1
		roxr.w	#3,d1
		swap	d0
		eor.l	d1,d0
		movem.l	d0-d1,water_random

		move.l	water_hei_visible,a0

		and.l	#127,d0
		and.l	#063,d1

		add.l	#(160-128)/2,d0
		add.l	#(096-064)/2,d1

		mulu.w	#160,d1
		add.l	d1,d0
		move.w	#-$100,d2
		lea	(a0,d0.l*2),a1
		move.w	d2,000(a1)
		move.w	d2,002(a1)
		move.w	d2,320(a1)
		move.w	d2,322(a1)
		rts

dobrush2	move.w	#-20,water_hei

dobrush1	move.l	water_hei_visible,a0
		move.w	water_hei(pc),d5
		lea	brush1,a1

		move.w	#hei-1,d7
.yloop		moveq.l	#9,d6
.xloop		move.w	(a1)+,d0
		rept	16
		add.w	d0,d0
		subx.w	d1,d1
		and.w	d5,d1
		add.w	d1,(a0)+
		endr
		dbra	d6,.xloop
		dbra	d7,.yloop
		rts

		cnop	0,16
brush1		incbin	'bpl.circulo'

water_diff	move.l	water_hei_hidden,a0
		move.l	water_hei_visible,a1

		moveq.l	#dens,d6
		
		move.w	#(hei*20)-1,d7
.xyloop
		rept	8

		move.w	320(a0),d0
		add.w	-320(a0),d0
		add.w	2(a0),d0
		add.w	-2(a0),d0

		asr.w	#1,d0
		sub.w	(a1),d0

		addq.l	#2,a0

		move.w	d0,d1
		asr.w	d6,d1		; density value
		sub.w	d1,d0

		move.w	d0,(a1)+

		endr

		dbra	d7,.xyloop

;		sub.l	#320,a1			; copyback from down to top
;		move.l	water_hei_visible(pc),a0
;		rept	160/2
;		move.l	(a1)+,(a0)+
;		endr
;		rept	160/2			; and from top to down
;		move.l	(a0)+,(a1)+
;		endr
		rts

water_timing	dc.w	0
water_xpos	dc.w	0
water_ypos	dc.w	0
water_random	dc.b	'sanity  '

water_clearscreen
		move.l	c2p__chunky,a6
		move.l	#160*hei,d7
		add.l	d7,a6

		sub.l	d0,d0
		sub.l	d1,d1
		sub.l	d2,d2
		sub.l	d3,d3
		sub.l	d4,d4
		sub.l	a0,a0
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4

		move.w	#((160*hei)/(32*4*10))-1,d7
.loop
		rept	32
		movem.l	d0-d4/a0-a4,-(a6)
		endr
		dbra	d7,.loop
		rts

water_draw	move.l	c2p__chunky,a0
		move.l	water_hei_visible,a1

		add.l	#160*(hei-1),a0

		move.l	#320,a3
		move.l	#160,a2

		move.w	#159,d7
.xloop		swap	d7
		movem.l	a0/a1,-(sp)

		move.w	#$ff,d6
		move.w	#hei,d5
		move.w	#hei,d4

		move.w	#(hei/8)-1,d7
.yloop

wv		macro
		move.w	(a1),d0
		asr.w	#3,d0
		add.w	d5,d0
		move.w	d4,d1
		sub.w	d0,d1
		bls.b	.nopaint\@

		move.w	d0,d4
		bra.b	.ploope\@
.ploop\@	move.b	d6,(a0)
		sub.l	a2,a0
.ploope\@	dbra	d1,.ploop\@

.nopaint\@	add.l	a3,a1
		endm

		wv
		subq.w	#1,d5
		sub.w	#5,d6
		wv
		subq.w	#1,d5
		wv
		subq.w	#1,d5
		subq.w	#5,d6
		wv

		wv
		subq.w	#1,d5
		sub.w	#5,d6
		wv
		subq.w	#1,d5
		wv
		subq.w	#1,d5
		subq.w	#5,d6
		wv


		subq.w	#1,d5
		dbra	d7,.yloop

		movem.l	(sp)+,a0/a1
		addq.l	#2,a1
		addq.l	#1,a0
		swap	d7
		dbra	d7,.xloop
		rts


water_dbuffer	lea	water_hei_hidden,a0
		move.l	a0,a1

		move.l	(a0)+,d1
		move.l	(a0)+,d0
		move.l	d0,(a1)+
		move.l	d1,(a1)+
		rts

water_hei_hidden	dc.l	chk_water3dhei_1
water_hei_visible	dc.l	chk_water3dhei_0

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	lea	$dff000,a6
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	move.l	c2p__chunky(pc),a6
	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4

	move.l	a7,c2p_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	water3d_chunky1
c2p__chunky_	dc.l	water3d_chunky2

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

	cnop	0,16
c2p_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	c2p_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	lea	$dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_2,lv3_blit
	rts

c2p_blit_2	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_3,lv3_blit
	rts

c2p_blit_3	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_4,lv3_blit
	rts

c2p_blit_4	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_5,lv3_blit
	rts

c2p_blit_5	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_6,lv3_blit
	rts

c2p_blit_6	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_7,lv3_blit
	rts

c2p_blit_7	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#6*plsize,a1

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_8,lv3_blit
	rts

c2p_blit_8	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#7*plsize,a1

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_end,lv3_blit
	rts

c2p_blit_end	clr.l	c2p_proceed
	clr.l	lv3_blit

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d1
	move.l	d1,(a0)+
	move.l	d0,(a0)+

	move.l	d0,newplanes
	addq.l	#1,timing_frame2
	rts

c2p_dbuff	lea	c2p__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	c2p__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	planes2

swap_screens	move.l	newplanes(pc),d0

	lea	c_water_bpls,a0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#plsize,d0
	addq.l	#8,a0
	dbra	d7,.sloop

	addq.l	#1,timing_frame1
	rts

test_speed	move.l	c2p__chunky(pc),a0
	move.l	timing_frame1(pc),d0
	move.l	timing_frame2(pc),d1

	tst.l	d0
	beq.b	.no

	mulu.w	#wid,d1
	divs.l	d0,d1
	move.l	d1,timing_speed

	moveq.l	#0,d2

	move.l	a0,a1
	move.w	#(wid*8/16)-1,d7
.clrloop	move.l	d0,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	dbra	d7,.clrloop

	add.l	d1,a0
	add.l	#wid*2,a0

	move.w	#3,d7
.loop	movem.l	a0-a4,(a0)
	add.l	#wid,a0
	dbra	d7,.loop

.no	rts

timing_frame1	dc.l	0
timing_frame2	dc.l	0
timing_speed	dc.l	0

	section	data_c,data_c

	cnop	0,64
c_water	dc.w	$1fc,$4007
	dc.w	$100,$0201

	dc.w	$08e,$0082|(($118-2*hei)<<8)
	dc.w	$090,$18C1		* DIWindow Size YX
	dc.w	$092,$0038
	dc.w	$094,$00D0-(4*8)	* DDFetch

	dc.w	$100,$0201|$0010
	dc.w	$102,$0010
	dc.w	$104,$0200
	dc.w	$106,$0020

	dc.w	$108,-40
	dc.w	$10a,0

	dc.w	$1007,$fffe

sprite	set	$120
c_water_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

c_water_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

	dc.w	$ffdf,$fffe
	dc.w	$2007,$fffe
c_water_pal
	ds.b	2112
	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
