		;machine 68030

		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	bltbuf1
		XREF	bltbuf2

		XREF	water2d_chunky1
		XREF	water2d_chunky2
		XREF	chk_water2dhei_0
		XREF	chk_water2dhei_1

		XREF	lv3_copper
		XREF	lv3_vblank
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	whitepal
		XREF	blackpal

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	salir
		
		XREF	water_texture

		XDEF	waterback_main

		IFND	WASIMACROS
		include	'include:macros2.i'
		ENDC

		incdir	'water2d'

	section	water_back,code

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

wmouse	macro
.wm1\@	btst	#6,$bfe001
	bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
	beq.b	.wm2\@
	endm

resetcopper	macro
	bsr	off_sprites
	endm

wid		set	160
hei		set	128-32
dens		set	4


waterback_main

		RESET_SPRITES	c_water_spr

		move.l	#whitepal,fader_original
		move.l	#water_pal,fader_target
		move.l	#c_water_pal,fader_copper
		move.w	#63,fader_colors
		move.w	#5,fader_steps
		jsr	fader_makecopper
		jsr	fader_initcrossfade
		jsr	fader_setpalette

		move.l	#water_lv3,lv3_vblank

		move.l	#c_water,$dff080


.loop1		;move.w	#$000,$dff180
.ll		cmp.b	#255,$dff006
		bne.b	.ll
		;move.w	#$000,$dff180

		jsr	c2p_cpu
		jsr	water_dbuffer
		bsr	water_paintbrush
		;bsr	water_spot
		bsr	water_draw

		tst.l	salir
		bne	.salwater
		cmp.w	#7,p61_pos
		bne	.loop1
		;btst	#6,$bfe001
		;bne.b	.loop1

.salwater	bsr	c2p_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts


water_lv3	jsr	swap_screens

		jsr	fader_setpalette

		addq.w	#1,water_timing

		move.w	water_timing,d0
		and.w	#127,d0
		cmp.w	#127,d0
		blt	.nada
		
		lea	water_brush,a0
		movem.l	(a0),d0-d4
		move.l	d0,d5
		movem.l	d1-d5,(a0)
.nada
		rts
water_paintbrush
		;addq.w	#1,water_timing
		move.w	water_timing,d0
		and.w	#127,d0
		cmp.w	#63,d0
		ble.b	.do
		rts
.do		move.l	water_hei_visible,a0
		move.l	water_brush,a1

		move.w	#256,d5
		move.w	#hei-1,d7
.yloop		moveq.l	#9,d6
.xloop		move.w	(a1)+,d0

		rept	16
		add.w	d0,d0
		subx.w	d1,d1
		and.w	d5,d1
		add.w	d1,(a0)+
		endr

		dbra	d6,.xloop
		dbra	d7,.yloop
		rts

water_brush	dc.l	.br1
		dc.l	.br2
		dc.l	.br3
		dc.l	.br4
		dc.l	.br5
.br1		incbin	'bpl.b1.1'
.br2		incbin	'bpl.b1.2'
.br3		incbin	'bpl.b1.3'
.br4		incbin	'bpl.b1.4'
.br5		incbin	'bpl.b1.5'

water_spot	move.l	water_hei_hidden,a0
		movem.l	water_random(pc),d0/d1
		add.l	d1,d0
		roxr.w	#3,d0
		swap	d0
		eor.l	d0,d1
		roxl.l	#4,d1
		movem.l	d0/d1,water_random

		and.l	#$001f001f,d1
		and.l	#127*255,d0
		add.l	d1,(a0,d0.l)
		rts

water_timing	dc.w	0
water_xpos	dc.w	0
water_ypos	dc.w	0
water_random	dc.b	'sanity  '

water_draw	move.l	c2p__chunky,a0
		move.l	water_hei_visible,a1
		move.l	water_hei_hidden,a2
		lea	water_texture+(145+(145*256)),a6
		;lea	(155+(155*256),a6),a6
		;adda.l	#155+(155*256),a6

		moveq.l	#0,d0
		moveq.l	#dens,d6

		addq.l	#2,a2

		move.w	#(wid*hei/2)-1,d7
.loop
		rept	2

		move.w	318(a2),d0
		move.w	-322(a2),d1
		move.w	-4(a2),d3
		move.w	(a2)+,d2

		move.w	d0,d4
		sub.w	d1,d4
		move.w	d2,d5
		sub.w	d3,d5
		asr.w	#4,d4
		asr.w	#4,d5
		lsl.w	#8,d4
		move.b	d5,d4
		move.b	(a6,d4.w),(a0)+

		add.w	d1,d0
		add.w	d2,d0
		add.w	d3,d0
		asr.w	#1,d0
		sub.w	(a1),d0
		move.w	d0,d1
		asr.w	d6,d1		; density value
		sub.w	d1,d0
		move.w	d0,(a1)+

		endr

		dbra	d7,.loop

		moveq.l	#0,d0
		move.w	#(wid/8)-1,d7
.loop2
		rept	4
		move.l	d0,(a2)+
		move.l	d0,(a1)+
		endr

		dbra	d7,.loop2
		rts

water_pal	incbin	'phong64.pal'


water_dbuffer	lea	water_hei_hidden,a0
		move.l	a0,a1

		move.l	(a0)+,d1
		move.l	(a0)+,d0
		move.l	d0,(a1)+
		move.l	d1,(a1)+
		rts

water_hei_hidden	dc.l	chk_water2dhei_1
water_hei_visible	dc.l	chk_water2dhei_0

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

c2p_wait	lea	$dff000,a6
	BWAIT
	tst.b	c2p_proceed
	bne.b	c2p_wait
	rts

c2p_cpu	move.l	c2p__chunky(pc),a6
	move.l	c2p_pixels(pc),a5
	add.l	a6,a5

	move.l	c2p__bltbuf_(pc),a4

	move.l	a7,c2p_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	c2p_loop

c2p_data
c2p__chunky	dc.l	water2d_chunky1
c2p__chunky_	dc.l	water2d_chunky2

c2p__planes	dc.l	planes1
c2p__planes_	dc.l	planes2

c2p__bltbuf	dc.l	bltbuf1
c2p__bltbuf_	dc.l	bltbuf2

c2p_stack	dc.l	0
c2p_pixels	dc.l	wid*hei
c2p_proceed	dc.l	0

merge	macro
	move.l	\2,\3
	lsr.l	#\5,\3
	eor.l	\1,\3
	and.l	\4,\3
	eor.l	\3,\1
	lsl.l	#\5,\3
	eor.l	\3,\2
	endm

wordmerge	macro
	move.l	\1,\3
	swap	\2
	move.w	\2,\1
	move.w	\3,\2
	swap	\2
	endm

	cnop	0,16
c2p_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	c2p_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	c2p_stack,a7

	bsr	c2p_wait
	st	c2p_proceed

	bsr	c2p_dbuff

	lea	$dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_2,lv3_blit
	rts

c2p_blit_2	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_3,lv3_blit
	rts

c2p_blit_3	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_4,lv3_blit
	rts

c2p_blit_4	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_5,lv3_blit
	rts

c2p_blit_5	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_6,lv3_blit
	rts

c2p_blit_6	lea	$dff000,a6

	move.l	c2p__bltbuf,a0
	move.l	c2p__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#c2p_blit_end,lv3_blit
	rts


c2p_blit_end	clr.l	c2p_proceed
	clr.l	lv3_blit

	lea	c2p__planes(pc),a0
	movem.l	(a0),d0-d1
	move.l	d1,(a0)+
	move.l	d0,(a0)+

	move.l	d0,newplanes
	addq.l	#1,timing_frame2
	rts

c2p_dbuff	lea	c2p__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	c2p__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	0

swap_screens	move.l	newplanes(pc),d0

	lea	c_water_bpls,a0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#plsize,d0
	addq.l	#8,a0
	dbra	d7,.sloop

	addq.l	#1,timing_frame1
	rts

test_speed	move.l	c2p__chunky(pc),a0
	move.l	timing_frame1(pc),d0
	move.l	timing_frame2(pc),d1

	tst.l	d0
	beq.b	.no

	mulu.w	#wid,d1
	divs.l	d0,d1
	move.l	d1,timing_speed

	moveq.l	#0,d2

	move.l	a0,a1
	move.w	#(wid*8/16)-1,d7
.clrloop	move.l	d0,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	move.l	d2,(a1)+
	dbra	d7,.clrloop

	add.l	d1,a0
	add.l	#wid*2,a0

	move.w	#3,d7
.loop	movem.l	a0-a4,(a0)
	add.l	#wid,a0
	dbra	d7,.loop

.no	rts

timing_frame1	dc.l	0
timing_frame2	dc.l	0
timing_speed	dc.l	0

;water_texture	dc.l	0	;incbin	'chk.phong64'
;		ds.b	256*64

	section	data_c,data_c

	cnop	0,64
c_water	dc.w	$1fc,$4007
	dc.w	$100,$0201

	dc.w	$08e,$0082|(($108-2*hei)<<8)
	dc.w	$090,$08C1		* DIWindow Size YX
	dc.w	$092,$0038
	dc.w	$094,$00D0-(4*8)	* DDFetch

c_water_pal	ds.b	2112	;incbin	'pal.phong64'

	dc.w	$106,$0000

sprite	set	$120
c_water_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0

	dc.w	$100,$0201|$6000
	dc.w	$102,$0010
	dc.w	$104,$0200

	dc.w	$108,-40
	dc.w	$10a,0

c_water_bpls
	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f8,0,$fa,0
	dc.w	$fc,0,$fe,0

	dc.w	$fe8f,$fffe
	dc.w	$9c,$8010		; set copper

	dc.l	-2,-2

	cnop	0,16
spr_off	ds.l	8
