
;		machiine 68030

		opt	p=68030,c-

	include	'macros/macros.gs'
	include	macros2.i
	include	startupdarkness+data.s


***************** INTERRUPCION

wrast		macro
.wr1\@		cmp.b	#\1,$dff006
		bne.b	.wr1\@
.wr2\@		cmp.b	#\1,$dff006
		beq.b	.wr2\@
		endm

wmouse		macro
.wm1\@	btst	#6,$bfe001
		bne.b	.wm1\@
.wm2\@	btst	#6,$bfe001
		beq.b	.wm2\@
		endm

resetcopper	macro
		bsr	off_sprites
		endm

int3		movem.l	d0-a6,-(sp)

		move.w	$dff01e,d0
		btst	#6,d0
		beq.b	.noblit

		move.l	lv3_blit,d0
		beq.b	.no0

		move.l	d0,a0
		jsr	(a0)

.no0		movem.l	(sp)+,d0-a6
		move.w	#$40,$dff09c
		rte

.noblit		btst	#5,d0
		beq.b	.novblank

		move.l	lv3_vblank,d0
		beq.b	.no1
		move.l	d0,a0
		jsr	(a0)

.no1		movem.l	(sp)+,d0-a6
		move.w	#$20,$dff09c
		rte

.novblank	movem.l	(sp)+,d0-a6
		move.w	#$70,$dff09c
		rte

lv3_vblank	dc.l	0
lv3_blit	dc.l	0


hei	set	256

Begin		move.l	#c_water,$dff080
		lea	c_water_bpls,a0
		move.l	#water_planes1,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*hei,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		move.w	#$8040,$dff096		; blitter priority on

.loop1
		bsr	c2p_cpu
		bsr	doit
		subq.b	#1,conta
		cmp.b	#62,conta
		beq	.endappear
		LMB	.loop1
.endappear	
		RMB

.loop2
		bsr	c2p_cpu
		bsr	doit
		addq.b	#1,conta
		cmp.b	#127,conta
		beq	.enddisappear		
		LMB	.loop2
.enddisappear
		rts


		CNOP	0,16
doit
		lea	ck_8bit_gfx,a0
		lea	y_table,a1
		lea	c2p_pic,a2

		move.l	#(320*256)-1,d7

		clr.l	d0
		clr.l	d1
		clr.l	d2

		move.b	conta,d2

.loop		move.b	(a0)+,d0
		move.b	(a1)+,d1
		add.b	d2,d1
		cmp.b	d0,d1
		sgt	d1
		and.b	d1,d0
.no		move.b	d0,(a2)+

		subq.l	#1,d7
		tst.l	d7
		bne	.loop
		rts					

conta		dc.b	127
;--------------------------------------------------------------------

;-------------------------- Double Buffer ---------------------------
		CNOP	0,8
DBuffer		lea	c_water_bpls,a0
		movem.l	water_planes,d0-d1	
		exg.l	d0,d1
		movem.l	d0-d1,water_planes

		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*hei,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		rts		
;--------------------------------------------------------------------


plsize	set	40*hei
plsiz2	set	plsize*2

c2p_wait	tst.b	c2p_proceed
		bne.b	c2p_wait
		rts

c2p_cpu		bsr	c2p_wait
		st	c2p_proceed
		move.l	c2p_chunky(pc),a6
		move.l	c2p_pixels(pc),a5
		add.l	a6,a5

		move.l	c2p_bltbuf(pc),a4
		lea	plsiz2(a4),a3
		lea	plsiz2(a3),a2

		move.l	-(a3),a1
		move.l	-(a2),a0
		move.l	plsiz2(a2),d7

		move.l	#$0f0f0f0f,d4
		move.l	#$00ff00ff,d5
		move.l	#$55555555,d6

		bra.b	c2p_loop

c2p_data
c2p_chunky	dc.l	c2p_pic
c2p_bltbuf	dc.l	water_bltbuf
c2p_pixels	dc.l	320*hei
c2p_proceed	dc.l	0

merge		macro
		move.l	\2,\3
		lsr.l	#\5,\3
		eor.l	\1,\3
		and.l	\4,\3
		eor.l	\3,\1
		ifnc	'','\6'
		move.l	\1,\6
		endc
		lsl.l	#\5,\3
		eor.l	\3,\2
		endm

word		macro
		move.l	\1,\3
		swap	\2
		move.w	\2,\1
		move.w	\3,\2
		swap	\2
		endm

		cnop	0,64
c2p_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,plsiz2(a2)
		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
				move.l	a0,(a2)+
		and.l	d4,d7		;  2
		eor.l	d7,d1		;  4
		lsl.l	#4,d7		;  8
		eor.l	d7,d3		; 10

		move.l	d3,d7		; 12
		lsr.l	#8,d7		; 16
		eor.l	d2,d7		; 18
		and.l	d5,d7		; 20
		eor.l	d7,d2		; 22
		lsl.l	#8,d7		; 26
		eor.l	d7,d3		; 28
				move.l	a1,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24

		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		; 28
		lsl.l	#8,d7		;  4
		eor.l	d7,d1		;  6

		move.l	d1,d7		;  8
		lsr.l	#1,d7		; 12
		eor.l	d0,d7		; 14
		and.l	d6,d7		; 16
		eor.l	d7,d0		; 18
		add.l	d7,d7		; 20
		eor.l	d1,d7		; 22

		move.l	d0,a0		; 24
		move.l	d3,a1		; 26

		endr

		cmp.l	a5,a6
		bcs	c2p_loop

		lea	$dff000,a6
		BWAIT

		move.l	#water_bltbuf,a0
		move.l	water_planes,a1
		moveq.l	#-1,d0
		move.w	#2,d1

		move.w	d1,$62(a6)
		move.w	d1,$64(a6)
		move.w	#0,$66(a6)
		move.l	#-1,$44(a6)

		move.l	#water_bltbuf,a0
		move.l	water_planes,a1

		add.l	#(4*40*hei)-2,a1

		move.l	a0,$50(a6)		; orig 1
		subq.l	#2,a0
		move.l	a0,$4c(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#$cccc,$70(a6)
		move.l	#$eDE40000,$40(a6)

		move.w	#4*20*hei,$5c(a6)	; size_v
		move.w	#1,$5e(a6)		; size_h

		move.l	#c2p_blit2,lv3_blit
		rts


c2p_blit2	lea	$dff000,a6
		move.l	#water_bltbuf,a0
		move.l	water_planes,a1

		move.l	a0,$50(a6)		; orig 1
		addq.l	#2,a0
		move.l	a0,$4C(a6)		; orig 2
		move.l	a1,$54(a6)		; dest

		move.w	#$cccc,$70(a6)
		move.l	#$0DE42000,$40(a6)

		move.w	#4*20*hei,$5c(a6)	; size_v
		move.w	#1,$5e(a6)		; size_h

		move.l	#c2p_blit3,lv3_blit
		rts

c2p_blit3	clr	c2p_proceed
		clr.l	lv3_blit
		rts

		cnop	0,64
c2p_pic		dcb.b	320*256

		section	misc,data

ck_8bit_gfx	incbin	shirley-zd.bin
y_table		incbin	waterplasma64.bin

water_planes	dc.l	water_planes1
		dc.l	water_planes2

		section	chip,data_c

		cnop	0,64
c_water		dc.w	$1fc,$0007
		dc.w	$100,$0201

c_water_bpls	dc.w	$ec,0,$ee,0
		dc.w	$e8,0,$ea,0
		dc.w	$fc,0,$fe,0
		dc.w	$f8,0,$fa,0

		dc.w	$e4,0,$e6,0
		dc.w	$e0,0,$e2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f0,0,$f2,0

		;dc.w	$08e,$2881,$090,$28C1
		;dc.w	$092,$0038,$094,$00D0

xst set 14	; 14 14
xnd set	44	; 44 36

		dc.w	$08e,$2881
		dc.w	$090,$28c1
		dc.w	$092,xst*4,$094,xnd*4

		incbin	shirley-zd.pal

		dc.w	$100,$0201|$0010
		dc.w	$102,$0000
		dc.w	$104,$0200
		dc.w	$106,$0020

		dc.w	$108,0
		dc.w	$10a,0

		dc.l	-2,-2

		section	bbb,bss_c
		cnop	0,64
water_bltbuf		ds.b	8*40*256
water_planes1		ds.b	8*40*256
water_planes2		ds.b	8*40*256