		;machine	68030

		opt	debug,l+,c-,p=68030

		XDEF	water_init
		XDEF	water_fadeinit
		XDEF	water_cop
		XDEF	water_main

		XREF	water_ck_8bit_gfx
		XREF	water_y_table
		XREF	water_shade

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	planes4
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	shyrley_chunky1
		XREF	shyrley_chunky2

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_steps
		XREF	fader_colors
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	whitepal

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	salir

		IFND	WASIMACROs
		include	include:macros2.i
		ENDC

		incdir	'water'

		section	water,code

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

water_init
		move.l	#water_ck_8bit_gfx,water__chunky
		move.l	#water_ck_8bit_gfx,water__chunky_
		jsr	water_cpu
		move.l	#shyrley_chunky1,water__chunky
		move.l	#shyrley_chunky2,water__chunky_

		lea	c_water_bpls,a0
		move.l	#planes4,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*256,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		bsr	water_wait

		move.l	#((320*256)/4)-1,d0
		lea	planes1,a0
		lea	planes4,a1
.mierdaloop	move.l	(a0)+,(a1)+
		dbf	d0,.mierdaloop
		rts

water_fadeinit
		move.l	#whitepal,fader_original
		move.l	#water_pal,fader_target
		move.l	#c_water_pal,fader_copper
		move.w	d0,fader_steps
		move.w	d1,fader_colors
		jsr	fader_makecopper
		jsr	fader_initcrossfade

		rts


water_cop
		move.l	lv3_vblank,save_lv3
		move.l	#water_lv3,lv3_vblank

		move.l	#c_water,$dff080

.pera		tst.b	fader_finish
		beq	.pera
		move.l	save_lv3,lv3_vblank
		rts

save_lv3	dc.l	0



		CNOP	0,16
water_main
		move.l	#c_water,$dff080

		move.l	#((320*256)/4)-1,d0
		lea	planes4,a0
		lea	planes1,a1
		lea	planes2,a2
		lea	planes3,a3
		lea	water_ck_8bit_gfx,a4
		lea	shyrley_chunky1,a5
		lea	shyrley_chunky2,a6
.mierdaloop	move.l	(a0),(a1)+
		move.l	(a0),(a2)+
		move.l	(a0)+,(a3)+
		move.l	(a4),(a5)+
		move.l	(a4)+,(a6)+
		dbf	d0,.mierdaloop

		move.l	#water_lv3,lv3_vblank

.noout		tst.l	salir
		bne	.enddis
		cmp.w	#41,p61_crow
		blt	.noout		

		move.l	#water_pal,fader_original
		move.l	#water_pal,fader_target
		move.l	#c_water_pal,fader_copper
		move.w	#1,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade
		;jsr	fader_setpalette

.espera		bsr	water_cpu
		bsr	doit
		tst.l	salir
		bne	.enddis
		cmp.w	#34,p61_pos
		blt	.espera

.enddis
		bsr	water_wait
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts


water_lv3
		
		jsr	fader_setpalette
		
		cmp.w	#33,p61_pos
		blt	.nop

		jsr	swap_screens

		cmp.w	#41,p61_crow	;27
		blt	.nop
		cmp.l	#-255<<8,conta
		ble.b	.nop
		sub.l	#3<<8,conta

.nop		rts

;---------------------------------------------------------------
		CNOP	0,16
doit
		lea	water_ck_8bit_gfx,a0
		lea	water_y_table,a1
		move.l	water__chunky,a2
		lea	water_shade,a3
		;lea	(65536,a3),a3
		adda.l	#65536,a3
		;lea	table,a4

		move.l	#((320*256)/12)-1,d7

		clr.l	d0
		clr.l	d1
		clr.l	d2

		move.l	(conta).l,d2

		;nop
		;nop

.loop		rept	3
		moveq.l	#0,d1
		move.w	(a1),d1
		add.l	d2,d1
		move.b	(a0)+,d1
		move.w	(a3,d1.l),d3
		
		moveq.l	#0,d1
		move.w	(1,a1),d1
		add.l	d2,d1
		move.b	(a0)+,d1
		move.b	(a3,d1.l),d3

		swap	d3

		moveq.l	#0,d1
		move.w	(2,a1),d1
		add.l	d2,d1
		move.b	(a0)+,d1
		move.w	(a3,d1.l),d3

		moveq.l	#0,d1
		move.w	(3,a1),d1
		add.l	d2,d1
		move.b	(a0)+,d1
		move.b	(a3,d1.l),d3

		move.l	d3,(a2)+
		addq.l	#4,a1

		endr
		dbra	d7,.loop

		rts					

top	set	258

conta		dc.l	top<<8	;127

;		rept	top*2
;		dc.w	0
;		endr
;a	set	0
;table
;		rept	top
;		dc.w	a<<8
;a	set	a+1
;		endr
;		rept	top*2
;		dc.w	top<<8
;		endr
		
;--------------------------------------------------------------------


wid	set	320
hei	set	256

plsize	set	wid*hei/8
plsiz2	set	plsize*2

water_wait
	lea	$dff000,a6
	BWAIT
	tst.b	water_proceed
	bne.b	water_wait
	rts

water_cpu	move.l	water__chunky(pc),a6
	move.l	water_pixels(pc),a5
	add.l	a6,a5

	move.l	water__bltbuf_(pc),a4
	lea	plsiz2(a4),a3
	lea	plsiz2(a3),a2
	lea	plsiz2(a2),a1

	move.l	a7,water_stack

	move.l	-(a3),a7
	move.l	-(a2),a0
	move.l	-(a1),d7

	move.l	#$0f0f0f0f,d4
	move.l	#$00ff00ff,d5
	move.l	#$55555555,d6

	bra.b	water_loop

water_data
water__chunky	dc.l	shyrley_chunky1
water__chunky_	dc.l	shyrley_chunky2

water__planes	dc.l	planes1
water__planes_	dc.l	planes2
water__planes__	dc.l	planes3

water__bltbuf	dc.l	bltbuf1
water__bltbuf_	dc.l	bltbuf2

water_stack	dc.l	0
water_pixels	dc.l	wid*hei
water_proceed	dc.l	0

merge		macro
		move.l	\2,\3
		lsr.l	#\5,\3
		eor.l	\1,\3
		and.l	\4,\3
		eor.l	\3,\1
		ifnc	'','\6'
		move.l	\1,\6
		endc
		lsl.l	#\5,\3
		eor.l	\3,\2
		endm

wordmerge	macro
		move.l	\1,\3
		swap	\2
		move.w	\2,\1
		move.w	\3,\2
		swap	\2
		endm

		cnop	0,64
water_loop	;merge	d0,d2,d7,d4,4
		;merge	d1,d3,d7,d4,4
		;merge	d2,d3,d7,d5,8
		;merge	d2,d3,d7,d6,1
		;merge	d0,d1,d7,d5,8
		;merge	d0,d1,d7,d6,1

		rept	2

		move.l	(a6)+,d0
		move.l	(a6)+,d2
		move.l	(a6)+,d1
		move.l	(a6)+,d3
				move.l	d7,(a1)+

		ifeq wid-256
		addq.l	#4,a6
		endc

		move.l	d2,d7		;  2
		lsr.l	#4,d7		;  6
		eor.l	d0,d7		;  8
		and.l	d4,d7		; 10
		eor.l	d7,d0		; 12
		lsl.l	#4,d7		; 16
		eor.l	d7,d2		; 18

		move.l	d3,d7		; 20
		lsr.l	#4,d7		; 24
		eor.l	d1,d7		; 26
		and.l	d4,d7		; 28
				move.l	a0,(a2)+
		eor.l	d7,d1		;  2
		lsl.l	#4,d7		;  6
		eor.l	d7,d3		;  8

		move.l	d3,d7		; 10
		lsr.l	#8,d7		; 14
		eor.l	d2,d7		; 16
		and.l	d5,d7		; 18
		eor.l	d7,d2		; 20
		lsl.l	#8,d7		; 24
		eor.l	d7,d3		; 26
				move.l	a7,(a3)+
		move.l	d3,d7		;  2
		lsr.l	#1,d7		;  6
		eor.l	d2,d7		;  8
		and.l	d6,d7		; 10
		eor.l	d7,d2		; 12
		add.l	d7,d7		; 14
		eor.l	d7,d3		; 16

		move.l  d1,d7		; 18
		lsr.l	#8,d7		; 22
		eor.l	d0,d7		; 24
		and.l	d5,d7		; 26
				move.l	d2,(a4)+
		eor.l	d7,d0		;  2
		lsl.l	#8,d7		;  6
		eor.l	d7,d1		;  8

		move.l	d1,d7		; 10
		lsr.l	#1,d7		; 14
		eor.l	d0,d7		; 16
		and.l	d6,d7		; 18
		eor.l	d7,d0		; 20
		add.l	d7,d7		; 22
		eor.l	d1,d7		; 24

		move.l	d0,a0		; 26
		move.l	d3,a7		; 28

		endr

		cmp.l	a5,a6
		bcs	water_loop

		move.l	d7,(a1)+
		move.l	a0,(a2)+
		move.l	a7,(a3)+

		move.l	water_stack,a7

	bsr	water_wait
	st	water_proceed

	;move.w	#$555,$dff180
	;wrast	255
	;move.w	#$000,$dff180

	bsr	water_dbuff

	lea	$dff000,a6

	moveq.l	#-1,d0
	moveq.l	#2,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.w	#$cccc,$70(a6)

	move.l	water__bltbuf,a0
	move.l	water__planes,a1

	add.l	#(4*wid*hei/8)-2,a1

	move.l	a0,$50(a6)		; orig 1
	subq.l	#2,a0
	move.l	a0,$4c(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.l	#$eDE40000,$40(a6)

	move.w	#1+(4*wid*hei/16),$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h

	move.l	#water_blit2,lv3_blit
	rts


water_blit2	lea	$dff000,a6
	move.l	water__bltbuf,a0
	move.l	water__planes,a1

	move.l	a0,$50(a6)		; orig 1
	addq.l	#2,a0
	move.l	a0,$4C(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.l	#$0DE42000,$40(a6)

	move.w	#(4*wid*hei/16),$5c(a6)	; size_v
	move.w	#1,$5e(a6)		; size_h

	move.l	#water_blit3,lv3_blit
	rts

water_blit3	clr.l	water_proceed
	clr.l	lv3_blit

	lea	water__planes(pc),a0
	movem.l	(a0),d0-d2
	move.l	d1,(a0)+
	move.l	d2,(a0)+
	move.l	d0,(a0)+

	move.l	d0,newplanes
	rts

water_dbuff	lea	water__chunky(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)

	lea	water__bltbuf(pc),a0
	movem.l	(a0),d0-d1
	exg.l	d0,d1
	movem.l	d0-d1,(a0)
	rts

newplanes	dc.l	planes1

swap_screens	move.l	newplanes(pc),d0

	lea	c_water_bpls,a0
	moveq.l	#7,d7
.sloop	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#wid*hei/8,d0
	addq.l	#8,a0
	dbra	d7,.sloop

		;move.w	$dff004,d1
		;not.w	d1
		;and.w	#$8000,d1
		;rol.w	#1,d1

		;add.w	#$28,d1
		;lea	c_vector_rows,a0
		;moveq.l	#8,d0
		;move.w	#hei-1,d7
.loop		;move.b	d1,(a0)
		;addq.b	#1,d1
		;add.l	d0,a0
		;move.b	d1,(a0)
		;addq.b	#1,d1
		;add.l	d0,a0
		;dbra	d7,.loop
		rts



;water_ck_8bit_gfx	dc.l	0	;incbin	chk.shirley-zd
;water_y_table		dc.l	0	;incbin	waterplasma64.bin
;water_shade		dc.l	0	
water_pal	incbin	'shirley-zd.pal'

water_planes	dc.l	planes1
		dc.l	planes2

	section	water,data_c

	cnop	0,8
c_water	dc.w	$2007,$fffe

	dc.w	$1fc,$0007



xst	set	14	; 14 14
xnd	set	44	; 44 36

	dc.w	$08e,$2881
	dc.w	$090,$28c1
	dc.w	$092,xst*4
	dc.w	$094,xnd*4

	dc.w	$100,$0201|$0010
	dc.w	$102,$0000
	dc.w	$104,$0200
	dc.w	$106,$0020

	dc.w	$108,0
	dc.w	$10a,0

sprite	set	$120
c_water_spr
	dc.w	sprite,0,sprite+2,0
	dc.w	sprite+4,0,sprite+6,0
	dc.w	sprite+8,0,sprite+10,0
	dc.w	sprite+12,0,sprite+14,0
	dc.w	sprite+16,0,sprite+18,0
	dc.w	sprite+20,0,sprite+22,0
	dc.w	sprite+24,0,sprite+26,0
	dc.w	sprite+28,0,sprite+30,0


c_water_bpls
	dc.w	$ec,0,$ee,0
	dc.w	$e8,0,$ea,0
	dc.w	$fc,0,$fe,0
	dc.w	$f8,0,$fa,0

	dc.w	$e4,0,$e6,0
	dc.w	$e0,0,$e2,0
	dc.w	$f4,0,$f6,0
	dc.w	$f0,0,$f2,0


	dc.w	$ffdf,$fffe
	dc.w	$2a07,$fffe

c_water_pal	dcb.b	2112,0

	dc.l	-2,-2

