		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	vaso_pic
		XREF	vaso_chippic
		
		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_colors
		XREF	fader_steps
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_setpalette
		XREF	fader_makecopper

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	whitepal
		XREF	blackpal

		XREF	salir

		XDEF	vaso_main

		IFND	WASIMACROS
		include	include:macros2.i
		ENDC

		incdir	'vaso'

		section	vaso,code

RESET_SPRITES MACRO	;\1=copperlist sprite label
		lea	\1,a0
		moveq.l	#7,d0
		move.w	#$0120,d1
		move.l	#spr_off,d2
.spr_count\@
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		move.w	d1,(a0)+
		swap	d2
		move.w	d2,(a0)+
		addq.w	#2,d1
		dbf	d0,.spr_count\@
		ENDM

wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

vaso_main

		RESET_SPRITES	c_pic1_spr

		lea	(vaso_chippic).l,a0
		lea	(vaso_pic).l,a1
		move.l	#((640*512)/(32*32))-1,d0
.clrloop
		rept	32
		movem.l	(a1)+,d1-d7/a2
		movem.l	d1-d7/a2,(a0)
		lea	(32,a0),a0
		endr
		dbf	d0,.clrloop

		move.l	#whitepal,fader_original
		move.l	#vaso_pal,fader_target
		move.l	#c_pic1_pal,fader_copper
		move.w	#255,fader_colors
		move.w	#6,fader_steps
		jsr	fader_makecopper
		jsr	fader_initcrossfade
		jsr	fader_setpalette

		move.l	#vaso_lv3,lv3_vblank
		move.l	#c_pic1,$dff080

.loop2
		wrast	255

		move.l	#vaso_chippic,d0
		lea	c_pic1_bpls,a0
		btst	#7,$dff004
		beq.b	.nolace
		add.l	#80,d0
.nolace		moveq.l	#7,d1
.loop		swap	d0
		move.w	d0,2(a0)
		swap	d0
		move.w	d0,6(a0)
		add.l	#80*512,d0
		addq.l	#8,a0
		dbf	d1,.loop

		tst.l	salir
		bne	.salvaso
		cmp.w	#9,p61_pos
		blt	.loop2

.salvaso
		clr.l	lv3_vblank
		clr.l	lv3_blit
		clr.l	lv3_copper
		rts

vaso_lv3	jsr	fader_setpalette
		rts

vaso_pal	incbin	'Vaso_Whisky.final.pal'
;vaso_pic	dc.l	0

		section	vaso,data_c

		cnop	0,16
c_pic1		dc.w	$1fc,$0007
		dc.w	$08e,$2881,$090,$28C1
		dc.w	$092,$0038,$094,$00D8
		dc.w	$106,$0020
		dc.w	$100,$8215
		dc.w	$102,$0000
		dc.w	$104,$0000
		dc.w	$108,80-8
		dc.w	$10a,80-8

sprite	set	$120
c_pic1_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0

c_pic1_pal	dcb.b	2112


c_pic1_bpls	dc.w	$e0,0,$e2,0	; plane 1+2
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0	; plane 3+4
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0	; plane 5+6
		dc.w	$f4,0,$f6,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0
		dc.l	-2,-2

		cnop	0,16
spr_off		ds.l	8
