		;machine	68030

		opt	debug,l+,c-,p=68030

		XREF	planes1
		XREF	planes2
		XREF	planes3
		XREF	planes4
		XREF	bltbuf1
		XREF	bltbuf2
		XREF	textunel_chunky1
		XREF	textunel_chunky2
		XREF	textunel_offsets
		XREF	textunel_texture

		XREF	fader_target
		XREF	fader_original
		XREF	fader_copper
		XREF	fader_steps
		XREF	fader_colors
		XREF	fader_finish
		XREF	fader_initcrossfade
		XREF	fader_makecopper
		XREF	fader_setpalette

		XREF	blackpal

		XREF	lv3_vblank
		XREF	lv3_copper
		XREF	lv3_blit

		XREF	p61_pos
		XREF	p61_crow

		XREF	salir

		XREF	sinus

		XREF	textunel_tex
		XREF	textunel_shade
		XREF	textunel_tab1
		XREF	textunel_tab2

		XDEF	textunel_main


		IFND	WASIMACROs
		include	include:macros2.i
		ENDC

		incdir	'textunnel'

		section	textunel,code
wrast	macro
.wr1\@	cmp.b	#\1,$dff006
	bne.b	.wr1\@
.wr2\@	cmp.b	#\1,$dff006
	beq.b	.wr2\@
	endm

RESET_SPRITES MACRO	;\1=copperlist sprite label
	lea	\1,a0
	moveq.l	#7,d0
	move.w	#$0120,d1
	move.l	#spr_off,d2
.spr_count\@
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	move.w	d1,(a0)+
	swap	d2
	move.w	d2,(a0)+
	addq.w	#2,d1
	dbf	d0,.spr_count\@
	ENDM


wid		set	160
hei		set	128

		include	'engine.s'

minz		set	64
maxz		set	64+(64*8)

textunel_count	dc.w	0
textunel_upos	dc.w	0
textunel_vpos	dc.w	0
textunel_xpos	dc.w	0
textunel_ypos	dc.w	0

textunel_setup	lea	textunel_tab1,a0
		lea	textunel_tab2,a1
		lea	textunel_offsets,a2

		move.w	#255,d7
.yloop		move.w	#319,d6
.xloop		move.b	(a0)+,d0
		move.w	(a1)+,d1
		move.w	d1,d2
		lsl.w	#8,d1
		move.b	d0,d1
		ext.l	d2
		sub.w	#minz,d2
		blt.b	.less
		ext.l	d2
		divu.w	#((maxz-minz)/64),d2
		move.w	#63,d3
		sub.w	d2,d3
		move.w	d3,d2		
		tst.w	d2
		bge.b	.ok1
		moveq.l	#0,d2
.ok1		move.w	d2,d3
		bra.b	.do
.less		move.w	#63,d3
.do		lsl.w	#8,d3
		move.w	d1,(a2)+
		move.w	d3,(a2)+
		dbra	d6,.xloop
		dbra	d7,.yloop

carging		macro
		move.l	#\1,d0
		move.w	#\2,d1
		mulu.w	#320,d1
		add.l	d1,d0
		clr.l	(a2,d0.l*4)
		endm
		lea	textunel_offsets,a2
		carging	159,129
		carging	160,128
		carging	161,128
		carging	162,129

		lea	textunel_tex,a0
		lea	textunel_texture,a1
		lea	(65536.l,a1),a2
		move.w	#255,d7
.vloop		moveq.l	#63,d6
.uloop		move.l	(a0)+,d0
		move.l	d0,(a1)+
		move.l	d0,(a2)+
		dbra	d6,.uloop
		dbra	d7,.vloop
		rts

textunel_move	jsr	textunnel_swap_screens


		addq.w	#2,textunel_upos
		addq.w	#3,textunel_vpos
		add.w	#$77,textunel_xpos
		add.w	#$55,textunel_ypos
		addq.w	#1,textunel_count

		;cmp.w	#16,p61_pos
		;blt	.nada
		move.w	p61_pos+1,d0
		move.b	p61_crow+1,d0
		cmp.w	#(15<<8)+58,d0
		blt	.nada
		cmp.l	#500,steppp
		bgt	.nada
		lea	steppp,a0
		add.l	#$b0,(1,a0)
.nada

		cmp.w	#17,p61_pos
		blt	.nofade
		cmp.w	#48,p61_crow
		blt	.nofade
		jsr	fader_setpalette
.nofade
		rts

steppp		dc.l	0
		dc.l	0
nframes		dc.l	0

textunel_main
		RESET_SPRITES	c_textunel_spr

		clr.l	lv3_vblank
		lea	(planes1+8*40*256).l,a0
		lea	(planes2+8*40*256).l,a1
		lea	(planes3+8*40*256).l,a2
		move.l	#((8*40*256)/(32*16))-1,d0
		moveq.l	#0,d1
		moveq.l	#0,d2
		moveq.l	#0,d3
		moveq.l	#0,d4
		moveq.l	#0,d5
		moveq.l	#0,d6
		moveq.l	#0,d7
		sub.l	a3,a3
		;sub.l	a4,a4
		;sub.l	a5,a5
.chiploop2	rept	16
		movem.l	d1-d7/a3,-(a0)
		movem.l	d1-d7/a3,-(a1)
		movem.l	d1-d7/a3,-(a2)
		endr
		dbf	d0,.chiploop2

		move.l	#textunelcop_pal,fader_target
		move.l	#textunelcop_pal,fader_original
		move.l	#c_textunel_pal,fader_copper
		move.w	#1,fader_steps
		move.w	#255,fader_colors
		jsr	fader_makecopper
		jsr	fader_initcrossfade
		jsr	fader_setpalette

		move.l	#blackpal,fader_target
		move.l	#textunel_pal,fader_original
		move.l	#c_textunel_pal,fader_copper
		move.w	#5,fader_steps
		move.w	#255,fader_colors
		jsr	fader_initcrossfade

		lea	c_textunel_bpls,a0
		move.l	#planes2,d0
		moveq.l	#7,d7

.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#40*256,d0
		addq.l	#8,a0
		dbra	d7,.sloop

		move.l	#c_textunel,$dff080
		move.l	#textunel_tex,texturemap

		jsr	textunel_setup
		jsr	textunel_InitEngine

		move.l	#textunel_move,lv3_vblank


.loop1		;moveq.l	#2,d0
.ll		;cmp.w	textunel_count(pc),d0
		;bne.b	.ll
		;clr.w	textunel_count
		wrast	255

		jsr	textunnel_cpu
		
		bsr	textunel_paint
		;jsr	textunel_engine

		move.l	steppp,d0
		jsr	CalcCameraStepIEEE
		move.l	steppp,d0
		jsr	CalcObjectsStepIEEE
		jsr	PrecalcMatrix
		jsr	RotatePoints
		jsr	RotateNormals
		;jsr	PrecalcCameraMatrix
		jsr	TransformToCamera2x2
		jsr	MakeRadixTable
		jsr	RadixSort
		jsr	MakePolys
		jsr	MapTriangle2x2

		tst.l	salir
		bne	.saltunnel
	        cmp.w   #17,p61_pos
	        blt.b   .loop1
	        cmp.w   #63,p61_crow
	        blt.b   .loop1

.saltunnel
		bsr	textunnel_wait
		clr.l	lv3_copper
		clr.l	lv3_vblank
		clr.l	lv3_blit

		rts

textunel_pal	incbin	demo:textunnel/txt9.128.pal
textunelcop_pal	incbin	demo:textunnel/pal.txt9.128

textunel_paint	lea	textunel_offsets,a4
		lea	textunel_shade,a5
		lea	textunel_texture+32768,a6

		moveq.l	#0,d1
		move.w	textunel_upos(pc),d0
		move.w	textunel_vpos(pc),d1
		lsl.w	#8,d1
		move.b	d0,d1
		lea	(a6,d1.l),a6

		move.w	#$3fff,d7
		lea	sinus,a0
		moveq.l	#0,d0
		moveq.l	#0,d1
		move.w	textunel_xpos(pc),d0
		move.w	textunel_ypos(pc),d1
		and.w	d7,d0
		and.w	d7,d1
		move.l	(a0,d0.l*4),d0
		move.l	(a0,d1.l*4),d1

		muls.l	#80,d0
		lsl.l	#6,d1
		swap	d0
		swap	d1
		add.w	#80,d0
		add.w	#64,d1
		ext.l	d0
		ext.l	d1
		mulu.w	#320,d1
		add.l	d1,d0
		lea	(a4,d0.l*4),a4

		move.l	textunnel__chunky,a0
		move.l	a0,engine__chunky

		moveq.l	#(wid/16)-1,d7
.xloop		move.l	a0,a1
		move.l	a4,a3
		move.w	#hei-1,d6
.yloop
		rept	16
		move.w	(a4),d4
		move.l	(a4)+,d5
		move.b	(a6,d4.w),d5
		move.b	(a5,d5.w),(a0)+
		endr
		lea	(4*(320-16))(a4),a4
		lea	(wid-16)(a0),a0
		dbra	d6,.yloop
		lea	(4*16)(a3),a4
		lea	(16)(a1),a0
		dbra	d7,.xloop
		rts

		cnop	0,16
;textunel_tex	dc.l	0	;incbin	'chk.txt1'
;textunel_shade	dc.l	0	;incbin	'bin.shade'
;textunel_tab1	dc.l	0	;incbin	'bin.tab1'
;textunel_tab2	dc.l	0	;incbin	'bin.tab2'

plsize	set	2*wid*hei/8
plsiz2	set	2*plsize*2

textunnel_wait	lea	$dff000,a6
	BWAIT
	tst.b	textunnel_proceed
	bne.b	textunnel_wait
	rts

textunnel_cpu	move.l	textunnel__chunky(pc),a6
	move.l	textunnel_pixels(pc),a5
	add.l	a6,a5

	move.l	textunnel__bltbuf_(pc),a4

	move.l	a7,textunnel_stack

	move.l	#$00ff00ff,d7
	move.l	#$0f0f0f0f,d6
	move.l	#$33333333,d5

	move.l	-(a4),a2
	move.l	-(a4),a1
	move.l	-(a4),d4

	bra.b	textunnel_loop

textunnel_data
textunnel__chunky	dc.l	textunel_chunky1
textunnel__chunky_	dc.l	textunel_chunky2

textunnel__planes	dc.l	planes1
textunnel__planes_	dc.l	planes2
textunnel__planes__	dc.l	planes3

textunnel__bltbuf	dc.l	bltbuf1
textunnel__bltbuf_	dc.l	bltbuf2

textunnel_stack	dc.l	0
textunnel_pixels	dc.l	wid*hei
textunnel_proceed	dc.l	0

;merge	macro
;	move.l	\2,\3
;	lsr.l	#\5,\3
;	eor.l	\1,\3
;	and.l	\4,\3
;	eor.l	\3,\1
;	lsl.l	#\5,\3
;	eor.l	\3,\2
;	endm
;
;wordmerge	macro
;	move.l	\1,\3
;	swap	\2
;	move.w	\2,\1
;	move.w	\3,\2
;	swap	\2
;	endm

	cnop	0,16
textunnel_loop	move.l	(a6)+,d0
	move.l	(a6)+,d1
	move.l	(a6)+,d2
	move.l	(a6)+,d3

	;word	d0,d2,d4
	;word	d1,d3,d4
	;merge	d0,d1,d4,d7,8
	;merge	d2,d3,d4,d7,8
	;merge	d0,d2,d4,d6,4
	;merge	d1,d3,d4,d6,4
	;merge	d0,d1,d4,d5,2
	;merge	d2,d3,d4,d5,2

		move.l	d4,(a4)+

	swap    d2	;  4
	move.w  d0,d4	;  6
	move.w  d2,d0	;  8
	move.w  d4,d2	; 10
	swap    d2	; 14

	swap    d3	; 18
	move.w  d1,d4	; 20
	move.w  d3,d1	; 22
	move.w  d4,d3	; 24
	swap    d3	; 28

		move.l	a1,(a4)+

	move.l  d2,d4
	lsr.l   #4,d4
	eor.l   d0,d4
	and.l   d6,d4
	eor.l   d4,d0
	lsl.l   #4,d4
	eor.l   d4,d2

	move.l  d3,d4
	lsr.l   #4,d4
	eor.l   d1,d4
	and.l   d6,d4
	eor.l   d4,d1
	lsl.l   #4,d4
	eor.l   d4,d3

		move.l	a2,(a4)+

	move.l  d1,d4
	lsr.l   #8,d4
	eor.l   d0,d4
	and.l   d7,d4
	eor.l   d4,d0
	lsl.l   #8,d4
	eor.l   d4,d1

	move.l  d3,d4
	lsr.l   #8,d4
	eor.l   d2,d4
	and.l   d7,d4
	eor.l   d4,d2
	lsl.l   #8,d4
	eor.l   d4,d3

	move.l  d1,d4
	lsr.l   #2,d4
	eor.l   d0,d4
	and.l   d5,d4
	eor.l   d4,d0
		move.l	d0,(a4)+
	lsl.l   #2,d4	;  4
	eor.l   d4,d1	;  6
	
		move.l	d1,a1
	move.l  d3,d4	;  8
	lsr.l   #2,d4	; 12
	eor.l   d2,d4	; 14
	and.l   d5,d4	; 16
	eor.l   d4,d2	; 18
	lsl.l   #2,d4	; 22
	eor.l   d3,d4	; 24

		move.l	d2,a2

	cmp.l	a5,a6
	bne	textunnel_loop

	move.l	d4,(a4)+
	move.l	a1,(a4)+
	move.l	a2,(a4)+

	move.l	textunnel_stack,a7

	bsr	textunnel_wait
	st	textunnel_proceed

	bsr	textunnel_dbuff

	lea	$dff000,a6

bwid set 320
bhei set hei
plsize set bwid*bhei/8

	moveq.l	#-1,d0
	moveq.l	#12,d1

	move.w	d1,$62(a6)
	move.w	d1,$64(a6)
	move.w	#0,$66(a6)
	move.l	d0,$44(a6)
	move.l	#$0DE41000,$40(a6)

	move.l	textunnel__bltbuf,a0
	move.l	textunnel__planes,a1
	addq.l	#4,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#(plsize/4),$5c(a6)	; size_v
	move.w	#2,$5e(a6)		; size_h
	move.l	#textunnel_blit_2,lv3_blit
	rts

textunnel_blit_2	lea	$dff000,a6

	move.l	textunnel__bltbuf,a0
	move.l	textunnel__planes,a1
	add.l	#plsize,a1
	addq.l	#4,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#textunnel_blit_3,lv3_blit
	rts

textunnel_blit_3	lea	$dff000,a6

	move.l	textunnel__bltbuf,a0
	move.l	textunnel__planes,a1
	add.l	#plsize*2,a1
	add.l	#12,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#textunnel_blit_4,lv3_blit
	rts

textunnel_blit_4	lea	$dff000,a6

	move.l	textunnel__bltbuf,a0
	move.l	textunnel__planes,a1
	add.l	#3*plsize,a1
	add.l	#12,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#textunnel_blit_5,lv3_blit
	rts

textunnel_blit_5	lea	$dff000,a6

	move.l	textunnel__bltbuf,a0
	move.l	textunnel__planes,a1
	add.l	#4*plsize,a1
	addq.l	#8,a0

	move.w	#$5555,$70(a6)

	move.l	a0,$4c(a6)		; orig 1
	move.l	a0,$50(a6)		; orig 2
	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#textunnel_blit_6,lv3_blit
	rts

textunnel_blit_6	lea	$dff000,a6

	move.l	textunnel__bltbuf,a0
	move.l	textunnel__planes,a1
	add.l	#5*plsize,a1
	addq.l	#8,a0

	move.w	#$aaaa,$70(a6)

	move.l	a0,$50(a6)		; orig 1
	move.l	a0,$4c(a6)		; orig 2

	move.l	a1,$54(a6)		; dest

	move.w	#2,$5e(a6)		; size_h
	move.l	#textunnel_blit_7,lv3_blit
	rts

textunnel_blit_7	lea	$dff000,a6

		move.l	textunnel__bltbuf,a0
		move.l	textunnel__planes,a1
		add.l	#6*plsize,a1

		move.w	#$5555,$70(a6)

		move.l	a0,$4c(a6)		; orig 1
		move.l	a0,$50(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#textunnel_blit_8,lv3_blit
		rts

textunnel_blit_8	lea	$dff000,a6

		move.l	textunnel__bltbuf,a0
			move.l	textunnel__planes,a1
		add.l	#7*plsize,a1

		move.w	#$aaaa,$70(a6)

		move.l	a0,$50(a6)		; orig 1
		move.l	a0,$4c(a6)		; orig 2

		move.l	a1,$54(a6)		; dest

		move.w	#2,$5e(a6)		; size_h
		move.l	#textunnel_blit_end,lv3_blit
		rts

textunnel_blit_end	clr.l	textunnel_proceed
		clr.l	lv3_blit

		lea	textunnel__planes(pc),a0
		movem.l	(a0),d0-d2
		move.l	d2,(a0)+
		move.l	d0,(a0)+
		move.l	d1,(a0)+

		move.l	d0,textunnel_newplanes
		rts

textunnel_dbuff	lea	textunnel__chunky(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)

		lea	textunnel__bltbuf(pc),a0
		movem.l	(a0),d0-d1
		exg.l	d0,d1
		movem.l	d0-d1,(a0)
		rts

textunnel_newplanes	dc.l	planes1

textunnel_swap_screens	move.l	textunnel_newplanes(pc),d0

		lea	c_textunel_bpls,a0
		moveq.l	#7,d7
.sloop		move.w	d0,6(a0)
		swap	d0
		move.w	d0,2(a0)
		swap	d0
		add.l	#plsize,d0
		addq.l	#8,a0
		dbra	d7,.sloop
		rts

		cnop	0,16
texturemap	dc.l	0	;incbin	'chk.txt1'


		section	data_c,data_c

		cnop	0,64
c_textunel	dc.w	$1fc,$4007
		dc.w	$100,$0201

		dc.w	$08e,$2882
		dc.w	$090,$28C1		* DIWindow Size YX
		dc.w	$092,$0038
		dc.w	$094,$00D0-(4*8)	* DDFetch

c_textunel_pal	dcb.b	2112	;incbin	'demo:textunnel/pal.txt9.128'

		dc.w	$100,$0201|$0010
		dc.w	$102,$0010
		dc.w	$104,$0200
		dc.w	$106,$0020

		dc.w	$108,-40
		dc.w	$10a,0

sprite	set	$120
c_textunel_spr
		dc.w	sprite,0,sprite+2,0
		dc.w	sprite+4,0,sprite+6,0
		dc.w	sprite+8,0,sprite+10,0
		dc.w	sprite+12,0,sprite+14,0
		dc.w	sprite+16,0,sprite+18,0
		dc.w	sprite+20,0,sprite+22,0
		dc.w	sprite+24,0,sprite+26,0
		dc.w	sprite+28,0,sprite+30,0
	
c_textunel_bpls
		dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0
		dc.w	$f4,0,$f6,0
		dc.w	$f8,0,$fa,0
		dc.w	$fc,0,$fe,0

		dc.w	$fe8f,$fffe
		dc.w	$9c,$8010		; set copper
		dc.l	-2,-2 

		cnop	0,16
spr_off		ds.l	8
